/**
 *  Contains gauge classes such as Dial and Clock, and other associated classes for styling and appearance.
 */
package com.jidesoft.gauge;


/**
 *  A Paint class where you can easily configure a radial paint that emanates from the pivot point of a dial.
 */
public class DialRadialPaint implements java.awt.Paint {

	/**
	 *  Constructs a Radial gradient paint centred on the pivot point of the dial.
	 *  @param dial the dial from which the paint derives its centre point
	 *  @param fractions fractions for specifying the color mix
	 *  @param colors the colors to use at the points indicated by <code>fractions</code>
	 */
	public DialRadialPaint(Dial dial, float[] fractions, java.awt.Color[] colors) {
	}

	/**
	 *  This constructor allows you to specify fractions and colors as for the other constructor, but also allows
	 *  you to specify an offset for the centre of the radial paint. This could be useful for example if you wanted
	 *  to use an offset to give the impression of light being projected from a particular direction.
	 *  The offset is expressed in terms of the radius
	 *  of the dial and an angle, so the paint will be scalable should the component's size be changed.
	 *  @param dial the dial to which the paint will be applied
	 *  @param fractions the fraction points corresponding to the colors
	 *  @param colors the colors of the radial paint
	 *  @param offsetRadius the radius of the offset, specified as a proportion of the pixel radius
	 *  @param offsetAngle the angle of the offset, specified in degrees.
	 */
	public DialRadialPaint(Dial dial, float[] fractions, java.awt.Color[] colors, float offsetRadius, float offsetAngle) {
	}

	public float getRadiusProportion() {
	}

	/**
	 *  By default the radius of a DialRadialPaint is defined by the radius of the dial itself, but this becomes
	 *  limiting if you want to use it for the paint of a DialFrame surrounding the dial, especially as the fractions
	 *  supplied need to be in the range 0.0 to 1.0. Using this method you can modify the radius used for the Paint
	 *  by a multiplying factor, allowing you to use this paint class for filling a DialFrame.
	 *  @param radiusProportion a multiplying factor to apply to the radius of the dial
	 */
	public void setRadiusProportion(Float radiusProportion) {
	}

	public java.awt.PaintContext createContext(java.awt.image.ColorModel cm, java.awt.Rectangle deviceBounds, java.awt.geom.Rectangle2D userBounds, java.awt.geom.AffineTransform transform, java.awt.RenderingHints hints) {
	}

	public int getTransparency() {
	}
}
