/**
 *  Contains gauge classes such as Dial and Clock, and other associated classes for styling and appearance.
 */
package com.jidesoft.gauge;


/**
 *  An interface for the data model displayed by a meter/gauge
 */
public interface GaugeModel {

	public Positionable getValue(String needleName);

	/**
	 *  The assumption is that with this method, an update event will be fired
	 *  @param needleName the name of the needle
	 *  @param value the value of the needle
	 */
	public void setValue(String needleName, Positionable value);

	public void setValue(String needleName, Positionable value, boolean fireUpdate);

	public int getValueCount();

	public void clearValues();

	public void addGaugeModelListener(GaugeModelListener listener);

	public void removeGaugeModelListener(GaugeModelListener listener);
}
