/**
 *  Contains gauge classes such as Dial and Clock, and other associated classes for styling and appearance.
 */
package com.jidesoft.gauge;


public interface IndicatorRenderer {

	public java.awt.Shape paintIndicator(java.awt.Graphics2D g, AbstractGauge gauge, Double value, IndicatorStyle style);

	/**
	 *  Paints a LegendItem onto the supplied Graphics context using the other supplied parameters to help size and
	 *  style the LegendItem appropriately.
	 *  @param g the Graphics context onto which we paint
	 *  @param gauge the Gauge component (e.g. a Bullet)
	 *  @param style the specified IndicatorStyle that may influence the painting
	 *  @param w the width of the legend item to be painted
	 *  @param h the height of the legend item to be painted
	 *  @return the Shape of the painted item (can be null)
	 */
	public java.awt.Shape paintLegendItem(java.awt.Graphics g, AbstractGauge gauge, IndicatorStyle style, int w, int h);
}
