/**
 *  Contains gauge classes such as Dial and Clock, and other associated classes for styling and appearance.
 */
package com.jidesoft.gauge;


public interface MarkerShapeFactory {

	/**
	 *  Creates a Shape, with centre at the supplied x and y coordinates and with the given width and height
	 *  @param x the pixel x coordinate
	 *  @param y the pixel y coordinate
	 *  @param width the width of the shape
	 *  @param height the height of the shape
	 *  @return a Shape
	 */
	public java.awt.Shape createShape(double x, double y, double width, double height);
}
