/**
 *  Contains gauge classes such as Dial and Clock, and other associated classes for styling and appearance.
 */
package com.jidesoft.gauge;


/**
 *  A class that contains the name and shape of a needle.
 *  Instances of this class may be returned by methods that determine whether a point (esp. the cursor location) is
 *  currently over a needle.
 */
public class NeedleDescriptor {

	/**
	 *  Create a NeedleDescriptor object from the name of the needle and its rendered Shape.
	 *  @param needleName the name of the needle
	 *  @param needleShape the rendered shape of the needle
	 *  @see java.awt.Shape
	 */
	public NeedleDescriptor(String needleName, java.awt.Shape needleShape) {
	}

	/**
	 *  Create a NeedleDescriptor object from the name of the needle and its rendered Shape.
	 *  @param needleName the name of the needle
	 *  @param needleShape the rendered shape of the needle
	 *  @see java.awt.Shape
	 */
	public NeedleDescriptor(String needleName, java.awt.Shape needleShape, int index) {
	}

	/**
	 *  Returns the name of the needle
	 *  @return the name of the needle
	 */
	public String getNeedleName() {
	}

	/**
	 *  Returns the shape of the needle
	 *  @return the shape of the needle
	 */
	public java.awt.Shape getNeedleShape() {
	}

	/**
	 *  Returns the index of the needle in the list of needles maintained by the dial
	 *  @return the index of the needle in the list of needles maintained by the dial
	 */
	public int getIndex() {
	}

	@java.lang.Override
	public String toString() {
	}
}
