/**
 *  Contains gauge classes such as Dial and Clock, and other associated classes for styling and appearance.
 */
package com.jidesoft.gauge;


/**
 *  The NeedleRenderer interface specifies 
 */
public interface NeedleRenderer {

	/**
	 *  Paints a needle onto a meter
	 *  @param g2d the Graphics context onto which the needle is to be drawn
	 *  @param gauge the Meter component onto which the needle will be painted
	 *  @param x the x coordinate of the needle pivot
	 *  @param y the y coordinate of the needle pivot
	 *  @param angle the angle in degrees
	 *  @param radius the radius of the needle in pixels
	 *  @param style the needle style, which provides preferred styling details. A renderer should respect these
	 *  preferences but on occasions may have good reason to override them.
	 */
	public java.awt.Shape paintNeedle(java.awt.Graphics2D g2d, AbstractGauge gauge, Double value, double x, double y, double angle, double radius, NeedleStyle style);
}
