/**
 *  Contains gauge classes such as Dial and Clock, and other associated classes for styling and appearance.
 */
package com.jidesoft.gauge;


/**
 *  A pivot is similar to a DialIntervalMarker, except that it uses a fromAngle and toAngle (specified in degrees)
 *  where a DialIntervalMarker is configured by values on the primary axis. After creating a Pivot instance, you
 *  must add it to the Dial using the addDrawable() method of the dial.
 * 
 *  A pivot is usually used for just that - the pivot of a dial - but the class could be used as a decoration elsewhere
 *  on the dial.
 */
public class Pivot implements com.jidesoft.chart.Drawable, com.jidesoft.chart.ZOrder {

	/**
	 *  Create a circular Pivot on the supplied dial instance using the radius and filled by the
	 *  supplied <em>fill</em> Paint.
	 *  @param dial the dial to which the Pivot will be added
	 *  @param radius the radius of the pivot as a proportion of the radius of the dial
	 *  @param fill the Paint used to fill the dial
	 */
	public Pivot(Dial dial, double radius, java.awt.Paint fill) {
	}

	/**
	 *  Create a Pivot on the supplied dial instance that covers a range of angles from the supplied <em>fromAngle</em>
	 *  to the <em>toAngle</em>, and using the supplied radius as a proportion of the radius of the dial.
	 *  @param dial the dial instance to which the Pivot will be added
	 *  @param radius the radius of the pivot as a proportion of the radius of the dial
	 *  @param fromAngle the start angle of the pivot circle segment.
	 *  @param toAngle the end angle of the pivot circle segment.
	 *  @param fill the Paint used to fill the dial
	 */
	public Pivot(Dial dial, double radius, double fromAngle, double toAngle, java.awt.Paint fill) {
	}

	/**
	 *  Returns the Paint fill used for the Pivot
	 *  @return the Paint fill used for the Pivot
	 */
	public java.awt.Paint getFill() {
	}

	/**
	 *  Specify the Paint fill to use for the Pivot
	 *  @param fill the Paint fill to use for the Pivot
	 */
	public void setFill(java.awt.Paint fill) {
	}

	/**
	 *  The start angle for the segment of the circle covered by the Pivot
	 *  @return the start angle for the segment of the circle covered by the Pivot
	 */
	public double getFromAngle() {
	}

	/**
	 *  Specify the start angle for the segment of the circle covered by the Pivot
	 *  @param fromAngle the start angle (in degrees) of the circle segment covered by the Pivot
	 */
	public void setFromAngle(double fromAngle) {
	}

	/**
	 *  The inner radius of the segment, specified as a proportion of the radius of the dial
	 *  @return the inner radius of the segment
	 */
	public double getInnerRadius() {
	}

	/**
	 *  Specifies the inner radius of the segment as a proportion of the radius of the dial
	 *  @param innerRadius the inner radius of the segment
	 */
	public void setInnerRadius(double innerRadius) {
	}

	/**
	 *  The outer radius of the segment, specified as a proportion of the radius of the dial
	 *  @return the inner radius of the segment
	 */
	public double getOuterRadius() {
	}

	/**
	 *  Specifies the outer radius of the segment as a proportion of the radius of the dial
	 *  @param outerRadius the outer radius of the segment
	 */
	public void setOuterRadius(double outerRadius) {
	}

	/**
	 *  The end angle for the segment of the circle covered by the Pivot
	 *  @return the end angle for the segment of the circle covered by the Pivot
	 */
	public double getToAngle() {
	}

	/**
	 *  Specify the end angle for the segment of the circle covered by the Pivot
	 *  @param toAngle the end angle (in degrees) of the circle covered by the Pivot
	 */
	public void setToAngle(double toAngle) {
	}

	/**
	 *  Returns the z-order specification for the Pivot
	 *  @return the z-order specification for the Pivot
	 *  @see #setZOrder(int) 
	 */
	public int getZOrder() {
	}

	/**
	 *  Provide advice to the dial about whether to paint this on top or underneath the needles. Importantly, needles
	 *  are painted at z = 100 so any value less than that will cause the pivot to be painted underneath the needles.
	 *  @param zOrder a numeric specification for which vertical 'slice' to paint this on
	 */
	public void setZOrder(int zOrder) {
	}

	/**
	 *  The current outline color for the Pivot
	 *  @return the outline color for the Pivot
	 */
	public java.awt.Color getOutlineColor() {
	}

	/**
	 *  Specify the outline color for the Pivot
	 *  @param outlineColor the outline color for the Pivot
	 */
	public void setOutlineColor(java.awt.Color outlineColor) {
	}

	/**
	 *  Returns the width of the outline, in pixels
	 *  @return the width of the outline, in pixels
	 */
	public int getOutlineWidth() {
	}

	/**
	 *  Specify the width of the outline, in pixels
	 *  @param outlineWidth the width of the outline, in pixels
	 */
	public void setOutlineWidth(int outlineWidth) {
	}

	public double getOffsetAngle() {
	}

	public void setOffsetAngle(double offsetAngle) {
	}

	public double getOffsetRadius() {
	}

	public void setOffsetRadius(double offsetRadius) {
	}

	/**
	 *  Returns a boolean to indicate whether the Pivot is currently visible
	 *  @return a boolean to indicate whether the Pivot is currently visible
	 */
	public boolean isVisible() {
	}

	/**
	 *  Specify whether the Pivot is to be visible
	 *  @param visible whether the Pivot is to be visible
	 */
	public void setVisible(boolean visible) {
	}

	protected java.awt.geom.Point2D getCenter() {
	}

	/**
	 *  The <code>draw()</code> method of the <code>Drawable</code> that paints the Pivot onto the Graphics context 
	 *  @param g the Graphics context
	 */
	public void draw(java.awt.Graphics g) {
	}
}
