/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.util.ShapeFactory;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public enum PointShape {
    CIRCLE,
    DISC,
    SQUARE,
    BOX,
    DIAMOND,
    DOWN_TRIANGLE,
    UP_TRIANGLE,
    HORIZONTAL_LINE,
    VERTICAL_LINE,
    UPRIGHT_CROSS,
    DIAGONAL_CROSS;


    public Shape paint(Graphics graphics, double d2, double d3, double d4, Paint paint, boolean bl, Color color, float f2) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setPaint(paint);
        try {
            switch (this) {
                case CIRCLE: {
                    Shape shape = this.b(graphics2D, d2, d3, d4, bl, color, f2);
                    return shape;
                }
                case DISC: {
                    Shape shape = this.c(graphics2D, d2, d3, d4, bl, color, f2);
                    return shape;
                }
                case SQUARE: {
                    Shape shape = this.a(graphics2D, d2, d3, d4, bl, color, f2);
                    return shape;
                }
                case BOX: {
                    Shape shape = this.d(graphics2D, d2, d3, d4, bl, color, f2);
                    return shape;
                }
                case DIAMOND: {
                    Shape shape = this.e(graphics2D, d2, d3, d4, bl, color, f2);
                    return shape;
                }
                case DOWN_TRIANGLE: {
                    Shape shape = this.f(graphics2D, d2, d3, d4, bl, color, f2);
                    return shape;
                }
                case UP_TRIANGLE: {
                    Shape shape = this.g(graphics2D, d2, d3, d4, bl, color, f2);
                    return shape;
                }
                case HORIZONTAL_LINE: {
                    Shape shape = this.h(graphics2D, d2, d3, d4, bl, color, f2);
                    return shape;
                }
                case VERTICAL_LINE: {
                    Shape shape = this.i(graphics2D, d2, d3, d4, bl, color, f2);
                    return shape;
                }
                case UPRIGHT_CROSS: {
                    Shape shape = this.j(graphics2D, d2, d3, d4, bl, color, f2);
                    return shape;
                }
                case DIAGONAL_CROSS: {
                    Shape shape = this.k(graphics2D, d2, d3, d4, bl, color, f2);
                    return shape;
                }
            }
            throw new IllegalArgumentException("Unexpected shape");
        }
        finally {
            graphics2D.dispose();
        }
    }

    private Shape a(Graphics2D graphics2D, double d2, double d3, double d4, boolean bl, Color color, float f2) {
        Rectangle2D.Double double_;
        block3: {
            double d5;
            double d6;
            block2: {
                d6 = d2 - d4 / 2.0;
                d5 = d3 - d4 / 2.0;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                double_ = new Rectangle2D.Double(d6, d5, d4, d4);
                graphics2D.draw(double_);
                if (Orientation.b) break block2;
                if (!bl) break block3;
                graphics2D.setColor(color);
                graphics2D.setStroke(new BasicStroke(f2));
            }
            Rectangle2D.Double double_2 = new Rectangle2D.Double(d6 - (double)f2 / 2.0, d5 - (double)f2 / 2.0, d4 + 1.0 + (double)f2, d4 + 1.0 + (double)f2);
            graphics2D.draw(double_2);
        }
        return double_;
    }

    private Shape b(Graphics2D graphics2D, double d2, double d3, double d4, boolean bl, Color color, float f2) {
        Ellipse2D.Double double_;
        block3: {
            double d5;
            double d6;
            block2: {
                graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                d6 = d2 - (d4 - 1.0) / 2.0;
                d5 = d3 - (d4 - 1.0) / 2.0;
                double_ = new Ellipse2D.Double(d6, d5, d4, d4);
                graphics2D.draw(double_);
                if (Orientation.b) break block2;
                if (!bl) break block3;
                graphics2D.setColor(color);
                graphics2D.setStroke(new BasicStroke(f2));
            }
            Ellipse2D.Double double_2 = new Ellipse2D.Double(d6 - (double)(f2 + 1.0f) / 2.0 - 0.5, d5 - (double)(f2 + 1.0f) / 2.0 - 0.5, d4 + 1.5 + (double)f2, d4 + 1.5 + (double)f2);
            graphics2D.draw(double_2);
        }
        return double_;
    }

    private Shape c(Graphics2D graphics2D, double d2, double d3, double d4, boolean bl, Color color, float f2) {
        Ellipse2D.Double double_;
        block3: {
            double d5;
            double d6;
            block2: {
                graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                d6 = d2 - d4 / 2.0;
                d5 = d3 - d4 / 2.0;
                double_ = new Ellipse2D.Double(d6, d5, d4, d4);
                graphics2D.fill(double_);
                graphics2D.draw(double_);
                if (Orientation.b) break block2;
                if (!bl) break block3;
                graphics2D.setColor(color);
                graphics2D.setStroke(new BasicStroke(f2));
            }
            Ellipse2D.Double double_2 = new Ellipse2D.Double(d6 - (double)f2 / 2.0, d5 - (double)f2 / 2.0, d4 + (double)f2, d4 + (double)f2);
            graphics2D.draw(double_2);
        }
        return double_;
    }

    private Shape d(Graphics2D graphics2D, double d2, double d3, double d4, boolean bl, Color color, float f2) {
        Rectangle2D.Double double_;
        block3: {
            double d5;
            double d6;
            block2: {
                d6 = d2 - (d4 - 1.0) / 2.0;
                d5 = d3 - (d4 - 1.0) / 2.0;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                double_ = new Rectangle2D.Double(d6, d5, d4, d4);
                graphics2D.fill(double_);
                if (Orientation.b) break block2;
                if (!bl) break block3;
                graphics2D.setColor(color);
                graphics2D.setStroke(new BasicStroke(f2));
            }
            Rectangle2D.Double double_2 = new Rectangle2D.Double(d6 - (double)f2 / 2.0, d5 - (double)f2 / 2.0, d4 - 1.0 + (double)f2 / 2.0, d4 - 1.0 + (double)f2 / 2.0);
            graphics2D.draw(double_2);
        }
        return double_;
    }

    private Shape e(Graphics2D graphics2D, double d2, double d3, double d4, boolean bl, Color color, float f2) {
        Shape shape;
        block3: {
            block2: {
                shape = ShapeFactory.createDiamond2D(d2, d3, d4);
                graphics2D.fill(shape);
                if (Orientation.b) break block2;
                if (!bl) break block3;
                graphics2D.setColor(color);
                graphics2D.setStroke(new BasicStroke(f2));
            }
            Shape shape2 = ShapeFactory.createDiamond2D(d2, d3, d4 + (double)f2 - 1.0);
            graphics2D.draw(shape2);
        }
        return shape;
    }

    private Shape f(Graphics2D graphics2D, double d2, double d3, double d4, boolean bl, Color color, float f2) {
        Shape shape;
        block3: {
            block2: {
                shape = ShapeFactory.createDownTriangle2D(d2, d3, d4);
                graphics2D.fill(shape);
                if (Orientation.b) break block2;
                if (!bl) break block3;
                graphics2D.setColor(color);
                graphics2D.setStroke(new BasicStroke(f2));
            }
            Shape shape2 = ShapeFactory.createDownTriangle2D(d2, d3, d4 + (double)((int)f2) - 1.0);
            graphics2D.draw(shape2);
        }
        return shape;
    }

    private Shape g(Graphics2D graphics2D, double d2, double d3, double d4, boolean bl, Color color, float f2) {
        Shape shape;
        block3: {
            block2: {
                shape = ShapeFactory.createUpTriangle2D(d2, d3, d4);
                graphics2D.fill(shape);
                if (Orientation.b) break block2;
                if (!bl) break block3;
                graphics2D.setColor(color);
                graphics2D.setStroke(new BasicStroke(f2));
            }
            Shape shape2 = ShapeFactory.createUpTriangle2D(d2, d3, d4 + (double)((int)f2) - 1.0);
            graphics2D.draw(shape2);
        }
        return shape;
    }

    private Shape h(Graphics2D graphics2D, double d2, double d3, double d4, boolean bl, Color color, float f2) {
        Rectangle2D.Double double_;
        block3: {
            double d5;
            block2: {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                d5 = d2 - (d4 - 1.0) / 2.0;
                double_ = new Rectangle2D.Double(d5, d3 + 1.0 - 0.5, d4, 1.0);
                graphics2D.fill(double_);
                if (Orientation.b) break block2;
                if (!bl) break block3;
                graphics2D.setColor(color);
                graphics2D.setStroke(new BasicStroke(f2));
            }
            Rectangle2D.Double double_2 = new Rectangle2D.Double(d5 - (double)(f2 / 2.0f), d3 + 1.0 - 0.5 - (double)(f2 + 1.0f) / 2.0, d4 - 1.0 + (double)f2, 1.0f + f2);
            graphics2D.draw(double_2);
        }
        return double_;
    }

    private Shape i(Graphics2D graphics2D, double d2, double d3, double d4, boolean bl, Color color, float f2) {
        Rectangle2D.Double double_;
        block3: {
            double d5;
            block2: {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                d5 = d3 - (d4 - 1.0) / 2.0;
                double_ = new Rectangle2D.Double(d2 + 1.0 - 0.5, d5, 1.0, d4);
                graphics2D.fill(double_);
                if (Orientation.b) break block2;
                if (!bl) break block3;
                graphics2D.setColor(color);
                graphics2D.setStroke(new BasicStroke(f2));
            }
            Rectangle2D.Double double_2 = new Rectangle2D.Double(d2 + 1.0 - 0.5 - (double)(f2 + 1.0f) / 2.0, d5 - (double)(f2 / 2.0f), 1.0f + f2, d4 - 1.0 + (double)f2);
            graphics2D.draw(double_2);
        }
        return double_;
    }

    private Shape j(Graphics2D graphics2D, double d2, double d3, double d4, boolean bl, Color color, float f2) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        double d5 = d2 - (d4 - 1.0) / 2.0;
        double d6 = d3 - (d4 - 1.0) / 2.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d5, d3 + 1.0 - 0.5, d4, 1.0);
        Rectangle2D.Double double_2 = new Rectangle2D.Double(d2 + 1.0 - 0.5, d6, 1.0, d4);
        graphics2D.fill(double_);
        graphics2D.fill(double_2);
        Rectangle2D.Double double_3 = double_;
        if (!Orientation.b) {
            double_3.add(double_2);
            if (bl) {
                graphics2D.setColor(color);
                graphics2D.setStroke(new BasicStroke(f2));
                Rectangle2D.Double double_4 = new Rectangle2D.Double(d5 - (double)f2 / 2.0, d6 - (double)(f2 / 2.0f), d4 - 1.0 + (double)f2, d4 - 1.0 + (double)f2);
                graphics2D.draw(double_4);
            }
            double_3 = double_;
        }
        return double_3;
    }

    private Shape k(Graphics2D graphics2D, double d2, double d3, double d4, boolean bl, Color color, float f2) {
        double d5 = 2.0 * Math.sqrt(2.0);
        double d6 = (d4 - 1.0) / 2.0;
        double d7 = d2 - d6;
        double d8 = d3 - d6;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(d2 + 0.5 - d6 + 1.0 / d5, d3 + 0.5 - d6 - 1.0 / d5);
        generalPath.lineTo(d2 + 0.5 + d6 + 1.0 / d5, d3 + 0.5 + d6 - 1.0 / d5);
        generalPath.lineTo(d2 + 0.5 + d6 - 1.0 / d5, d3 + 0.5 + d6 + 1.0 / d5);
        generalPath.lineTo(d2 + 0.5 - d6 - 1.0 / d5, d3 + 0.5 - d6 + 1.0 / d5);
        generalPath.closePath();
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.moveTo(d2 + 0.5 + d6 - 1.0 / d5, d3 + 0.5 - d6 - 1.0 / d5);
        generalPath2.lineTo(d2 + 0.5 - d6 - 1.0 / d5, d3 + 0.5 + d6 - 1.0 / d5);
        generalPath2.lineTo(d2 + 0.5 - d6 + 1.0 / d5, d3 + 0.5 + d6 + 1.0 / d5);
        generalPath2.lineTo(d2 + 0.5 + d6 - 1.0 / d5, d3 + 0.5 - d6 + 1.0 / d5);
        generalPath2.closePath();
        GeneralPath generalPath3 = generalPath;
        if (!Orientation.b) {
            generalPath3.append(generalPath2, false);
            graphics2D.fill(generalPath);
            if (bl) {
                graphics2D.setColor(color);
                graphics2D.setStroke(new BasicStroke(f2));
                Rectangle2D.Double double_ = new Rectangle2D.Double(d7 - (double)f2 / 2.0, d8 - (double)(f2 / 2.0f), d4 - 1.0 + (double)f2, d4 - 1.0 + (double)f2);
                graphics2D.draw(double_);
            }
            generalPath3 = generalPath;
        }
        return generalPath3;
    }

    public static PointShape fromString(String string) {
        String string2 = string;
        if (!Orientation.b) {
            if (string2 == null) {
                throw new IllegalArgumentException("Cannot create PointShape from null");
            }
            string2 = string.trim().toUpperCase();
        }
        String string3 = string2;
        return PointShape.valueOf(string3);
    }
}

