/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.servlet;

import com.jidesoft.chart.servlet.HttpComponentFactory;
import com.jidesoft.chart.util.ChartUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.SwingUtilities;

public class ComponentServlet
extends HttpServlet {
    private static final long serialVersionUID = 7124400889703572316L;
    private Logger a = Logger.getLogger(ComponentServlet.class.getName());
    private HttpComponentFactory<?> b;
    public static boolean c;

    public ComponentServlet() {
    }

    public ComponentServlet(HttpComponentFactory<?> httpComponentFactory) {
        this.setComponentFactory(httpComponentFactory);
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    public HttpComponentFactory<?> getComponentFactory() {
        return this.b;
    }

    public void setComponentFactory(HttpComponentFactory<?> httpComponentFactory) {
        ComponentServlet componentServlet = this;
        if (!c) {
            if (componentServlet.b != null) {
                throw new IllegalStateException("The component factory cannot be changed once it has been set.");
            }
            componentServlet = this;
        }
        componentServlet.b = httpComponentFactory;
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        byte[] byArray = this.paintBytes(httpServletRequest);
        if (!c) {
            if (byArray == null) {
                httpServletResponse.sendError(400);
                return;
            }
            httpServletResponse.setContentType("image/png");
            httpServletResponse.setContentLength(byArray.length);
            httpServletResponse.getOutputStream().write(byArray);
            httpServletResponse.setStatus(200);
        }
    }

    public byte[] paintBytes(final HttpServletRequest httpServletRequest) {
        if (this.b == null) {
            return null;
        }
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Object t = ComponentServlet.this.b.getInstance(httpServletRequest);
                    BufferedImage bufferedImage = ChartUtils.createImage(t, 2);
                    try {
                        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        ComponentServlet.this.a.severe(iOException.getMessage());
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            this.a.info(interruptedException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            this.a.info(invocationTargetException.getMessage());
        }
        return byteArrayOutputStream.toByteArray();
    }
}

