/**
 *  The package contains classes related for Database/JDBC support for JIDE Data Grids product.
 */
package com.jidesoft.database;


public class CrudDatabaseTableModel extends DatabaseTableModel implements CrudTableModel {

	protected ResultSetTableModelCrudSupport _crudSupport;

	protected Record insertRow;

	protected volatile boolean isInInsertRow;

	/**
	 *  Creates a CrudDatabaseTableModel.
	 * 
	 *  @param connection    a database connection.
	 *  @param fromStatement a SQL from statement. It could be <ul> <li>FROM first_table <li>FROM first_table,
	 *                       second_table <li>FROM first_table LEFT JOIN second_table <li>FROM first_table INNER JOIN
	 *                       second_table </ul>
	 *  @throws java.sql.SQLException if a database related error happens. It could be because the connection is closed.
	 */
	public CrudDatabaseTableModel(java.sql.Connection connection, String fromStatement) {
	}

	/**
	 *  Creates a CrudDatabaseTableModel.
	 * 
	 *  @param connection      a database connection.
	 *  @param selectStatement a SQL select statement. If null, we default it to "*".
	 *  @param fromStatement   a SQL from statement. It could be <ul> <li>FROM first_table <li>FROM first_table,
	 *                         second_table <li>FROM first_table LEFT JOIN second_table <li>FROM first_table INNER JOIN
	 *                         second_table </ul>
	 *  @throws java.sql.SQLException if a database related error happens. It could be because the connection is closed.
	 */
	public CrudDatabaseTableModel(java.sql.Connection connection, String selectStatement, String fromStatement) {
	}

	/**
	 *  Creates a CrudDatabaseTableModel.
	 * 
	 *  @param connection      a database connection.
	 *  @param selectStatement a SQL select statement. If null, we default it to "*".
	 *  @param fromStatement   a SQL from statement. It could be <ul> <li>FROM first_table <li>FROM first_table,
	 *                         second_table <li>FROM first_table LEFT JOIN second_table <li>FROM first_table INNER JOIN
	 *                         second_table </ul>
	 *  @param updatable       if the table model is updatable (or editable)
	 *  @throws java.sql.SQLException if a database related error happens. It could be because the connection is closed.
	 */
	public CrudDatabaseTableModel(java.sql.Connection connection, String selectStatement, String fromStatement, boolean updatable) {
	}

	@java.lang.Override
	public int getRowCount() {
	}

	@java.lang.Override
	public Object getValueAt(int rowIndex, int columnIndex) {
	}

	@java.lang.Override
	public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
	}

	/**
	 *  Implementation of the CrudTableModel interface
	 *  (Create, Read, Update and Delete operations over rows on table models)
	 */
	@java.lang.Override
	public void insertRow(Record record) {
	}

	protected Record createRowRecord() {
	}

	@java.lang.Override
	public Record readRow(int rowIndex) {
	}

	@java.lang.Override
	public void updateRow(int rowIndex, Record record) {
	}

	@java.lang.Override
	public void deleteRow(int rowIndex) {
	}

	@java.lang.Override
	protected ResultSetTableModel createResultSetTableModel(java.sql.ResultSet resultSet, int rowCount) {
	}
}
