/**
 *  The package contains classes related for Database/JDBC support for JIDE Data Grids product.
 */
package com.jidesoft.database;


/**
 *  Provides access
 */
public interface CrudRowOperations {

	/**
	 *  Add a row to the table model.
	 * 
	 *  @param record     the data structure
	 *  @throws Exception if encouting any database update error
	 */
	public void insertRow(Record record);

	/**
	 *  Read data of a designated row.
	 * 
	 *  @param rowIndex the row index
	 *  @return the data structure
	 *  @throws Exception if encouting any database read error
	 */
	public Record readRow(int rowIndex);

	/**
	 *  Update data of a designated row with data.
	 * 
	 *  @param rowIndex the row index
	 *  @param columns the data array
	 *  @throws Exception if encouting any database update error
	 */
	public void updateRow(int rowIndex, Record columns);

	/**
	 *  Delete data of a designated row.
	 * 
	 *  @param rowIndex the row index
	 *  @throws Exception if encouting any database update error.
	 */
	public void deleteRow(int rowIndex);
}
