/**
 *  The package contains classes related for Database/JDBC support for JIDE Data Grids product.
 */
package com.jidesoft.database;


/**
 *  <code>DatabaseTableModel</code> uses an existing database connection and a SQL from statement to query the record
 *  from a database and display them in a table model. The from statement could has one database table or multiple
 *  database tables using join statement. The columns in this table model are decided by an optional SQL select statement
 *  you specified. If you didn't specify, we will use "*" which means all the available fields.
 *  <p/>
 *  By default, we use ResultSet.TYPE_SCROLL_SENSITIVE to create a SQL statement to do the query. If your database
 *  doesn't support this, we will fall back to TYPE_INSENSITIVE then TYPE_FORWARD_ONLY. If so, the performance could be
 *  an issue when you scroll down many pages as we have to skip all records one by one. For
 *  <p/>
 *  The main feature of this DatabaseTableModel is not just to display the database table but also to sort and filter the
 *  data using the built-in sort and filter features provided by the database, however, using the APIs provided by the
 *  SortableTableModel and FilterableTableModel provided in JIDE Grids. Usually you get a better performance using the
 *  database to do the sorting and filtering.
 *  <p/>
 *  In <code>DatabaseTableModel</code>, we would try our best to set appropriate cell renderer by using the information
 *  from the <code>ResultSetMetaData</code>.
 *  <p/>
 *  The folowing meta data information will be considered in ConverterContext:
 *  <code><pre>
 *  boolean isCurrency(int column) throws SQLException; // use default currency converter if {@link
 *  #isConsiderCurrencyField()} returns true
 *  int getScale(int column) throws SQLException;       // show the digit number after decimal point
 *  int getPrecision(int column) throws SQLException;   // show the integer part no larger than precision
 *  </pre></code>
 *  <p/>
 *  The following meta data information will be considered in {@link #validate(int, Object)}:
 *  <code><pre>
 *  int isNullable(int column) throws SQLException;     // check it in {@link #validateNullable(int, Object)}
 *  boolean isSigned(int column) throws SQLException;   // check it in {@link #validateSigned(int, Object)}
 *  int getPrecision(int column) throws SQLException;   // check it in {@link #validatePrecision(int, Object)}
 *  </pre></code>
 *  <p/>
 *  Other:
 *  <code><pre>
 *  boolean isReadOnly(int column) throws SQLException; // make it not editable in {@link #isCellEditable(int, int)}
 *  </pre></code>
 *  The following meta data information will not be considered:
 *  <code><pre>
 *  int getColumnDisplaySize(int column) throws SQLException; // no way to set preferred width to table from table model
 *  int getColumnCount() throws SQLException;
 *  boolean isAutoIncrement(int column) throws SQLException;
 *  boolean isSearchable(int column) throws SQLException;
 *  String getColumnLabel(int column) throws SQLException;
 *  String getColumnName(int column) throws SQLException;
 *  String getSchemaName(int column) throws SQLException;
 *  String getTableName(int column) throws SQLException;
 *  String getCatalogName(int column) throws SQLException;
 *  int getColumnType(int column) throws SQLException;
 *  String getColumnTypeName(int column) throws SQLException;
 *  String getColumnClassName(int column) throws SQLException;
 *  boolean isWritable(int column) throws SQLException; // it's database access related
 *  boolean isDefinitelyWritable(int column) throws SQLException; // it's database access related
 *  boolean isCaseSensitive(int column) throws SQLException; // searching case sensitive
 *  </pre></code>
 */
@java.lang.SuppressWarnings("NullableProblems")
public class DatabaseTableModel extends javax.swing.table.AbstractTableModel {

	protected ResultSetTableModel _resultSetTableModel;

	protected java.sql.Connection _connection;

	protected java.sql.Statement _statement;

	protected String _fromStatement;

	protected String _selectStatement;

	protected String _preStatement;

	/**
	 *  converter context for columns which was configured on {@link #refreshData(com.jidesoft.grid.SortItemSupport,
	 *  com.jidesoft.grid.FilterItemSupport)}
	 *  <p/>
	 *  After configuration, this field will be used at {@link #getConverterContextAt(int, int)}
	 *  <p/>
	 *  You can either override {@link #getConverterContextAt(int, int)} or {@link #configureConverterContexts()} to gain
	 *  more control on the cell renderers.
	 */
	protected ConverterContext[] _converterContexts;

	protected SortItemSupport _sortItemSupport;

	protected FilterItemSupport _filterItemSupport;

	/**
	 *  Creates a DatabaseTableModel.
	 * 
	 *  @param connection    a database connection.
	 *  @param fromStatement a SQL from statement. It could be <ul> <li>FROM first_table <li>FROM first_table,
	 *                       second_table <li>FROM first_table LEFT JOIN second_table <li>FROM first_table INNER JOIN
	 *                       second_table </ul>
	 *  @throws SQLException if a database related error happens. It could be because the connection is closed.
	 */
	public DatabaseTableModel(java.sql.Connection connection, String fromStatement) {
	}

	/**
	 *  Creates a DatabaseTableModel.
	 * 
	 *  @param connection      a database connection.
	 *  @param selectStatement a SQL select statement. If null, we default it to "*". If you use AS statement to change
	 *                         the column name, make sure you also call {@link #setColumnMapping(java.util.Map)} to set
	 *                         the mapping.
	 *  @param fromStatement   a SQL from statement. It could be <ul> <li>FROM first_table <li>FROM first_table,
	 *                         second_table <li>FROM first_table LEFT JOIN second_table <li>FROM first_table INNER JOIN
	 *                         second_table </ul>
	 *  @throws SQLException if a database related error happens. It could be because the connection is closed.
	 */
	public DatabaseTableModel(java.sql.Connection connection, String selectStatement, String fromStatement) {
	}

	/**
	 *  Creates a DatabaseTableModel.
	 * 
	 *  @param connection      a database connection.
	 *  @param preStatement    a pre-clause. It will appear at the beginning of all sql statements. For example, WITH abc
	 *                         as ( select dummy from dual ) select * from abc. "WITH abc as ( select dummy from dual )"
	 *                         will be the pre statement. "abc" will be the from statement.
	 *  @param selectStatement a SQL SELECT statement. Do not include the SELECT word in the statement. Just include
	 *                         everything after the SELECT. If null, we default it to "*". If you use AS statement to
	 *                         change the column name, make sure you also call {@link #setColumnMapping(java.util.Map)}
	 *                         to set the mapping.
	 *  @param fromStatement   a SQL FROM clause. Do not include the FROM word in the statement. Just include everything
	 *                         after the FROM. It could be <ul> <li>FROM first_table <li>FROM first_table, second_table
	 *                         <li>FROM first_table LEFT JOIN second_table <li>FROM first_table INNER JOIN second_table
	 *                         </ul>
	 *  @throws SQLException if a database related error happens. It could be because the connection is closed.
	 */
	public DatabaseTableModel(java.sql.Connection connection, String preStatement, String selectStatement, String fromStatement) {
	}

	/**
	 *  Creates a DatabaseTableModel.
	 * 
	 *  @param connection      a database connection.
	 *  @param selectStatement a SQL SELECT statement. Do not include the SELECT word in the statement. Just include
	 *                         everything after the SELECT. If null, we default it to "*". If you use AS statement to
	 *                         change the column name, make sure you also call {@link #setColumnMapping(java.util.Map)}
	 *                         to set the mapping.
	 *  @param fromStatement   a SQL FROM clause. Do not include the FROM word in the statement. Just include everything
	 *                         after the FROM. It could be <ul> <li>FROM first_table <li>FROM first_table, second_table
	 *                         <li>FROM first_table LEFT JOIN second_table <li>FROM first_table INNER JOIN second_table
	 *                         </ul>
	 *  @param updatable       if the table model is updatable (or editable)
	 *  @throws SQLException if a database related error happens. It could be because the connection is closed.
	 */
	public DatabaseTableModel(java.sql.Connection connection, String selectStatement, String fromStatement, boolean updatable) {
	}

	/**
	 *  Creates a DatabaseTableModel.
	 * 
	 *  @param connection      a database connection.
	 *  @param preStatement    a pre-clause. It will appear at the beginning of all sql statements. For example, WITH abc
	 *                         as ( select dummy from dual ) select * from abc. "WITH abc as ( select dummy from dual )"
	 *                         will be the pre statement. "abc" will be the from statement.
	 *  @param selectStatement a SQL SELECT statement. Do not include the SELECT word in the statement. Just include
	 *                         everything after the SELECT. If null, we default it to "*". If you use AS statement to
	 *                         change the column name, make sure you also call {@link #setColumnMapping(java.util.Map)}
	 *                         to set the mapping.
	 *  @param fromStatement   a SQL FROM clause. Do not include the FROM word in the statement. Just include everything
	 *                         after the FROM. It could be <ul> <li>FROM first_table <li>FROM first_table, second_table
	 *                         <li>FROM first_table LEFT JOIN second_table <li>FROM first_table INNER JOIN second_table
	 *                         </ul>
	 *  @param updatable       if the table model is updatable (or editable)
	 *  @throws SQLException if a database related error happens. It could be because the connection is closed.
	 */
	public DatabaseTableModel(java.sql.Connection connection, String preStatement, String selectStatement, String fromStatement, boolean updatable) {
	}

	protected void initDatabase() {
	}

	/**
	 *  Sets the column name mapping. It maps from the new column name to the original column name as specified in the
	 *  SQL select statement. For example if the select statement is "ID, CategoryName as Category, ProductName as
	 *  Product, Amount, OrderDate as Date", the mapping will be like this.
	 *  <code><pre>
	 *  Map<String, String> mapping = new HashMap();
	 *  mapping.put("CATEGORYNAME", "CATEGORY");
	 *  mapping.put("PRODUCTNAME", "PRODUCT");
	 *  mapping.put("ORDERDATE", "DATE");
	 *  </pre></code>
	 *  Please note it has to be all upper cases.
	 * 
	 *  @param columnMapping the column name mapping.
	 */
	public void setColumnMapping(java.util.Map columnMapping) {
	}

	public java.util.Map getColumnMapping() {
	}

	public int getColumnCount() {
	}

	@java.lang.Override
	public String getColumnName(int column) {
	}

	public ConverterContext getConverterContextAt(int rowIndex, int columnIndex) {
	}

	public EditorContext getEditorContextAt(int rowIndex, int columnIndex) {
	}

	public Class getCellClassAt(int rowIndex, int columnIndex) {
	}

	@java.lang.Override
	public Class getColumnClass(int columnIndex) {
	}

	public int getRowCount() {
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
	}

	public int getSortedRowAt(int actualRow) {
	}

	public int getActualRowAt(int row) {
	}

	public void sortColumn(int column) {
	}

	public void sortColumn(int column, boolean reset) {
	}

	public void unsortColumn(int column) {
	}

	public void reverseColumnSortOrder(int column) {
	}

	public void sortColumn(int column, boolean reset, boolean ascending) {
	}

	public boolean isColumnSorted(int column) {
	}

	public boolean isColumnAscending(int column) {
	}

	public void reset() {
	}

	public void toggleSortOrder(int column, boolean extend) {
	}

	public java.util.List getSortingColumns() {
	}

	public void setSortingColumns(java.util.List list) {
	}

	public int getColumnSortRank(int column) {
	}

	public void setMasterSortColumns(int[] masterSortColumns) {
	}

	public int[] getMasterSortColumns() {
	}

	public boolean isMultiColumnSortable() {
	}

	public void setMultiColumnSortable(boolean multiColumnSortable) {
	}

	public boolean isSortable() {
	}

	public void setSortable(boolean sortable) {
	}

	public void resort() {
	}

	public int getSortPriority() {
	}

	public void setSortPriority(int sortPriority) {
	}

	public int getMaximumSortColumns() {
	}

	public void setMaximumSortColumns(int maximumSortColumns) {
	}

	/**
	 *  Adds the specified listener to receive SortEvents pane events from this SortableTableModel.
	 * 
	 *  @param l the SortListener
	 */
	public void addSortListener(SortListener l) {
	}

	/**
	 *  Removes the specified SortListener so that it no longer receives SortEvents from this SortableTableModel .
	 * 
	 *  @param l the SortableTableModel listener
	 */
	public void removeSortListener(SortListener l) {
	}

	/**
	 *  Returns an array of all the <code>SortListener</code>s added to this <code>SortableTableModel</code> with
	 *  <code>addSortListener</code>.
	 * 
	 *  @return all of the <code>SortListener</code>s added or an empty array if no listeners have been added
	 * 
	 *  @see #addSortListener
	 */
	public SortListener[] getSortListeners() {
	}

	/**
	 *  Fires sort event.
	 */
	public void fireSortEvent() {
	}

	/**
	 *  Fires sort event.
	 */
	public void fireSortingEvent() {
	}

	/**
	 *  Check if a certain column is sortable.
	 * 
	 *  @return true if this table column is sortable.
	 * 
	 *  @see #setColumnSortable(int, boolean)
	 */
	public boolean isColumnSortable(int column) {
	}

	/**
	 *  Sets a column sortable or not sortable. Please note, you will have to set it again if the table model structure
	 *  is changed. By default, all columns are sortable.
	 * 
	 *  @param column   the column index.
	 *  @param sortable true to make the column sortable.
	 */
	public void setColumnSortable(int column, boolean sortable) {
	}

	protected void sort() {
	}

	/**
	 *  Create order statement from sort item support.
	 * 
	 *  @param sortItemSupport the sorting information stored in sortItemSupport
	 *  @return the order statement string. null if there is no sorting at all.
	 */
	protected String createOrderStatement(SortItemSupport sortItemSupport) {
	}

	/**
	 *  Convert the existing filter to where statement string.
	 *  <p/>
	 *  We now convert the following filter types to where statement string. Will return an empty string for other filter
	 *  types. {@link com.jidesoft.filter.OrFilter} {@link com.jidesoft.filter.AndFilter} {@link
	 *  com.jidesoft.filter.NotFilter} {@link com.jidesoft.filter.LikeFilter} {@link com.jidesoft.filter.EqualFilter}
	 *  {@link com.jidesoft.filter.BetweenFilter} {@link com.jidesoft.filter.InFilter} {@link
	 *  com.jidesoft.grid.SingleValueFilter} {@link com.jidesoft.grid.MultipleValuesFilter}
	 * 
	 *  @param filterItem the filter item to convert
	 *  @return the where statement string.
	 */
	protected StringBuffer prepareWhereStatement(FilterItem filterItem) {
	}

	/**
	 *  Converts the value defined in the filter to String so that it can be used in SQL. By default, we will put a
	 *  single quote around the string if the value is String or Date type.
	 * 
	 *  @param filter the filter where the value is from.
	 *  @param value  the value
	 *  @return a String representing the value.
	 */
	protected String convertElementToString(Filter filter, Object value) {
	}

	public void refresh() {
	}

	protected String createWhereStatement(FilterItemSupport filterItemSupport) {
	}

	public boolean isColumnFilterable(int column) {
	}

	public boolean isColumnVisible(int column) {
	}

	public boolean isColumnAutoFilterable(int column) {
	}

	public boolean isValuePredetermined(int column) {
	}

	public void addFilter(int column, Filter filter) {
	}

	public void addFilter(Filter filter) {
	}

	public void addFilter(FilterItem filterItem) {
	}

	public void removeFilter(int column, Filter filter) {
	}

	public void removeFilter(Filter filter) {
	}

	public void removeFilter(FilterItem filterItem) {
	}

	public void removeAllFilters(int column) {
	}

	public void removeAllFilters() {
	}

	public void clearFilters() {
	}

	public Filter[] getFilters(int column) {
	}

	public java.util.List getFilterItems() {
	}

	public void setFiltersApplied(boolean apply) {
	}

	public boolean isFiltersApplied() {
	}

	public boolean hasFilter() {
	}

	public boolean hasFilter(int columnIndex) {
	}

	public boolean isAndMode() {
	}

	public void setAndMode(boolean andMode) {
	}

	/**
	 *  Checks if the FilterableTableModel is adjusting. If it is adjusting, FilterableTableModel will not apply filter
	 *  when the actual list model changes.
	 * 
	 *  @return true if adjusting. Otherwise false.
	 */
	public boolean isAdjusting() {
	}

	/**
	 *  Sets the FilterableTableModel to adjusting mode. If it is adjusting, FilterableTableModel will not apply filter
	 *  when the actual table model changes. After you set adjusting to false, FilterableListModel will re-apply the
	 *  filter.
	 * 
	 *  @param adjusting true or false.
	 */
	public void setAdjusting(boolean adjusting) {
	}

	public Object[] getPossibleValues(int columnIndex, java.util.Comparator comparator) {
	}

	public Object[] getPossibleValuesAndConverters(int columnIndex, java.util.Comparator comparator) {
	}

	public boolean isSameConverterAt(int columnIndex) {
	}

	protected String createPossibleValuesStatement(int columnIndex) {
	}

	/**
	 *  Not supported in DatabaseTableModel.
	 * 
	 *  @param pause not used.
	 */
	public void setFilteringPaused(boolean pause) {
	}

	/**
	 *  Not supported in DatabaseTableModel.
	 * 
	 *  @return false.
	 */
	public boolean isFilteringPaused() {
	}

	/**
	 *  Adds a listener to the list that's notified each time a change to the filter occurs.
	 * 
	 *  @param l the FilterableTableModelListener
	 */
	public void addFilterableTableModelListener(FilterableTableModelListener l) {
	}

	/**
	 *  Removes a listener from the list that's notified each time a change to the filter occurs.
	 * 
	 *  @param l the FilterableTableModelListener
	 */
	public void removeFilterableTableModelListener(FilterableTableModelListener l) {
	}

	/**
	 *  Returns an array of all the FilterableTableModel listeners registered on this filter.
	 * 
	 *  @return all of this filter's <code>FilterableTableModelListener</code>s or an empty array if no filter listeners
	 *          are currently registered
	 * 
	 *  @see #addFilterableTableModelListener
	 *  @see #removeFilterableTableModelListener
	 */
	public FilterableTableModelListener[] getFilterableTableModelListeners() {
	}

	/**
	 *  Forwards the given notification event to all <code>FilterableTableModelListeners</code> that registered
	 *  themselves as listeners for this table model.
	 * 
	 *  @param e the event to be forwarded
	 *  @see #addFilterableTableModelListener
	 *  @see FilterableTableModelEvent
	 *  @see javax.swing.event.EventListenerList
	 */
	public void fireFilterChanged(FilterableTableModelEvent e) {
	}

	public void fireFilterAdded(int column, Filter filter) {
	}

	public void fireFilterRemoved(int column, Filter filter) {
	}

	/**
	 *  Gets the filter icon for a particular column.
	 * 
	 *  @param column the column index.
	 *  @return the icon.
	 */
	public javax.swing.Icon getFilterIcon(int column) {
	}

	/**
	 *  Creates a Statement. This instance will be reused to run all queries but the "select count(*)" sql. We will try
	 *  to create ResultSet.TYPE_SCROLL_SENSITIVE Statement if possible. If failed, we will create a
	 *  ResultSet.TYPE_SCROLL_INSENSITIVE. If failed again, we will create ResultSet.TYPE_FORWARD_ONLY statement.
	 * 
	 *  @return a Statement.
	 * 
	 *  @throws SQLException if it fails to create a ResultSet.TYPE_FORWARD_ONLY statement after failed to create the
	 *                       other two types.
	 */
	protected java.sql.Statement createStatement() {
	}

	/**
	 *  Creates a read-only statement. This statement is used to execute the "select count(*)" sql statement. We will try
	 *  to create ResultSet.TYPE_SCROLL_INSENSITIVE statement first. It it failed, we will create an
	 *  ResultSet.TYPE_FORWARD_ONLY statement.
	 * 
	 *  @return a read-only statement.
	 * 
	 *  @throws SQLException if it fails to create a ResultSet.TYPE_FORWARD_ONLY statement after failed to create the
	 *                       ResultSet.TYPE_SCROLL_INSENSITIVE statement.
	 */
	protected java.sql.Statement createReadonlyStatement() {
	}

	/**
	 *  This method is called before every single sql queries to give subclass a chance to override to create their own
	 *  statement. By default, we will create a read-only statement for "select count(*)" statement.
	 * 
	 *  @param statement the default Statement.
	 *  @param sql       the sql statement to be executed.
	 *  @return null if we will use the default Statement. Otherwise you can create a new Statement and return. It will
	 *          be used to execute this sql statement only.
	 * 
	 *  @throws java.sql.SQLException when failed to create a statement.
	 */
	protected java.sql.Statement adjustStatement(java.sql.Statement statement, String sql) {
	}

	/**
	 *  Resubmit the SQL statement.
	 *  <p/>
	 *  Comparing with {@link #refresh()}, this method will throw SQLException. If you would like to handle those
	 *  exception, you would better invoke this method.
	 * 
	 *  @param sortItemSupport   the information for sort items.
	 *  @param filterItemSupport the information for filter items.
	 *  @throws SQLException if a database access error occurs, this method is called on a closed <code>Statement</code>
	 *                       or the given SQL statement produces anything other than a single <code>ResultSet</code>
	 *                       object
	 */
	public void refreshData(SortItemSupport sortItemSupport, FilterItemSupport filterItemSupport) {
	}

	protected ResultSetTableModel createResultSetTableModel(java.sql.ResultSet resultSet, int rowCount) {
	}

	/**
	 *  Configure converter context for columns by the information contained in meta data.
	 *  <p/>
	 *  <code>_converterContexts</code> will be configured here. You can override this method if you need more precise
	 *  control over the cell renderer.
	 *  <p/>
	 * 
	 *  @throws SQLException if it encounters any database access issue.
	 */
	protected void configureConverterContexts() {
	}

	/**
	 *  Creates the sql statement to find out the row count in the result set.
	 * 
	 *  @param filterItemSupport the filterItemSupport which contains the filter information.
	 *  @return the SQl statement to count the rows
	 */
	protected String createCountStatement(FilterItemSupport filterItemSupport) {
	}

	/**
	 *  Creates a full SQL statement.
	 * 
	 *  @param preStatement      a pre-clause. It will appear at the beginning of all sql statements. For example, WITH
	 *                           abc as ( select dummy from dual ) select * from abc. "WITH abc as ( select dummy from
	 *                           dual )" will be the pre statement. "abc" will be the from statement.
	 *  @param selectStatement   a SQL SELECT statement. Do not include the SELECT word in the statement. Just include
	 *                           everything after the SELECT. If null, we default it to "*". If you use AS statement to
	 *                           change the column name, make sure you also call {@link #setColumnMapping(java.util.Map)}
	 *                           to set the mapping.
	 *  @param fromStatement     a SQL FROM clause. Do not include the FROM word in the statement. Just include
	 *                           everything after the FROM. It could be <ul> <li>FROM first_table <li>FROM first_table,
	 *                           second_table <li>FROM first_table LEFT JOIN second_table <li>FROM first_table INNER JOIN
	 *                           second_table </ul>
	 *  @param sortItemSupport   the SortItemSupport which contains the column sorting information.
	 *  @param filterItemSupport the FilterItemSupport which contains the filtering information.
	 *  @returna a full SQL statement.
	 */
	protected StringBuffer createSqlStatement(String preStatement, String selectStatement, String fromStatement, SortItemSupport sortItemSupport, FilterItemSupport filterItemSupport) {
	}

	@java.lang.Override
	public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
	}

	public void invalidateCache(int row) {
	}

	public void invalidateCache() {
	}

	@java.lang.Override
	public boolean isCellEditable(int rowIndex, int columnIndex) {
	}

	public void setUpdatable(boolean updatable) {
	}

	public boolean isUpdatable() {
	}

	public void commit() {
	}

	public void close() {
	}

	/**
	 *  The interface for the table to check if the input value satisfy the request from the meta data of the database.
	 *  You have to install a JideCellEditorListener to invoke this method promptly. Otherwise this method will not take
	 *  effect.
	 *  <p/>
	 *  So far we did three kinds of check int this method, including:
	 *  <code><pre>
	 *  public boolean nullCheck(int columnIndex, Object value) throws SQLException;
	 *  public boolean signCheck(int columnIndex, Object value) throws SQLException;
	 *  public boolean precisionCheck(int columnIndex, Object value) throws SQLException;
	 *  </pre></code>
	 * 
	 *  @param columnIndex the column index to be check in
	 *  @param value       the value to be check
	 *  @return true if the value satisfies the request of meta data. Otherwise false.
	 */
	public boolean validate(int columnIndex, Object value) {
	}

	/**
	 *  The interface for the table to check if the input value is null and meta data prohibits null value.
	 *  <p/>
	 * 
	 *  @param columnIndex the column index to be check in
	 *  @param value       the value to be check
	 *  @return false if the value is null and meta data prohibits null value. Otherwise true.
	 * 
	 *  @throws SQLException if it encounters database access issue.
	 */
	public boolean validateNullable(int columnIndex, Object value) {
	}

	/**
	 *  The interface for the table to check if the input value is negative and meta data prohibits negative value.
	 *  <p/>
	 * 
	 *  @param columnIndex the column index to be check in
	 *  @param value       the value to be check
	 *  @return false if the value is negative and meta data prohibits negative value. Otherwise true.
	 * 
	 *  @throws SQLException if it encounters database access issue.
	 */
	public boolean validateSigned(int columnIndex, Object value) {
	}

	/**
	 *  The interface for the table to check if the input value exceeds the precision meta data allows.
	 *  <p/>
	 * 
	 *  @param columnIndex the column index to be check in
	 *  @param value       the value to be check
	 *  @return false if the value exceeds the precision meta data allows. Otherwise true.
	 * 
	 *  @throws SQLException if it encounters database access issue.
	 */
	public boolean validatePrecision(int columnIndex, Object value) {
	}

	/**
	 *  Get the flag if you want to consider the isCurrency field in metaData.
	 *  <p/>
	 *  The reason we do this is that some database, like Derby, does not support this field and always return true. In
	 *  that case, it could ruin the original format setting and makes our table renderer a normal decimal as a currency
	 *  which is not as expected.
	 *  <p/>
	 *  The default value is false. You can call {@link #setConsiderCurrencyField(boolean)} to switch it to true if you
	 *  make sure that the database supports this field.
	 * 
	 *  @return true if you want to consider isCurrency field in metaData. Otherwise false.
	 */
	public boolean isConsiderCurrencyField() {
	}

	/**
	 *  Set the flag if you want to consider the isCurrency field in metaData.
	 *  <p/>
	 * 
	 *  @param considerCurrencyField the flag if you want to consider isCurrency field in metaData
	 */
	public void setConsiderCurrencyField(boolean considerCurrencyField) {
	}

	public DynamicTableFilter[] getDynamicTableFilters(int modelIndex) {
	}

	public boolean isAllowMultipleValues(int column) {
	}

	public StringConverter getTitleConverter(int column) {
	}

	public FilterTitleFormatter getFilterTitleFormatter(int column) {
	}

	public javax.swing.ListCellRenderer getListCellRenderer(int column) {
	}

	public boolean isUseTableCellRenderer(int column) {
	}

	public boolean isAllowCustomFilter(int column) {
	}
}
