package com.jidesoft.grid;


/**
 *  <code>AbstractPageTableModel</code> is the abstract implementation for <code>PagingSupport</code>. It extends
 *  <code>AbstractTableModel</code> and implements all methods {@link com.jidesoft.paging.PageNavigationSupport} except
 *  {@link #getTotalRecordCount()} and {@link #setTotalRecordCount(int)}.
 */
public abstract class AbstractPageTableModel extends javax.swing.table.AbstractTableModel implements com.jidesoft.paging.PageNavigationSupport, javax.swing.event.TableModelListener {

	public AbstractPageTableModel() {
	}

	public AbstractPageTableModel(int pageSize) {
	}

	public int getPageSize() {
	}

	public void setPageSize(int pageSize) {
	}

	public int getCurrentPage() {
	}

	public void setCurrentPage(int page) {
	}

	protected void setPageCount(int pageCount) {
	}

	public int getPageCount() {
	}

	public void nextPage() {
	}

	public void previousPage() {
	}

	public void firstPage() {
	}

	public void lastPage() {
	}

	/**
	 *  Adds a <code>PageNavigationListener</code> to the page.
	 * 
	 *  @param l the <code>PageNavigationListener</code> to be added
	 */
	public void addPageNavigationListener(com.jidesoft.paging.PageNavigationListener l) {
	}

	/**
	 *  Removes a <code>PageNavigationListener</code> from the page.
	 * 
	 *  @param l the <code>PageNavigationListener</code> to be removed
	 */
	public void removePageNavigationListener(com.jidesoft.paging.PageNavigationListener l) {
	}

	/**
	 *  Returns an array of all the <code>PageNavigationListener</code>s added to this <code>Page</code> with
	 *  <code>addPageNavigationListener</code> .
	 * 
	 *  @return all of the <code>PageNavigationListener</code>s added, or an empty array if no listeners have been added
	 */
	public com.jidesoft.paging.PageNavigationListener[] getPageNavigationListeners() {
	}

	/**
	 *  Runs each <code>PageNavigationListener</code>'s <code>PageNavigationEventFired</code> method.
	 * 
	 *  @param source   of this event
	 *  @param id       event id.
	 *  @param oldValue the old value associated with this event.
	 *  @param newValue the new value associated with this event.
	 */
	public void firePageNavigationEvent(Object source, int id, int oldValue, int newValue) {
	}

	/**
	 *  Adjusts the current page when page size changes so that the first row of the page is still visible after the page
	 *  size changes.
	 * 
	 *  @param oldPageSize the previous page size
	 *  @param newPageSize the new page size
	 */
	@java.lang.SuppressWarnings("UnusedDeclaration")
	protected void pageSizeChanged(int oldPageSize, int newPageSize) {
	}

	protected abstract void pageCountChanged(int oldPageCount, int newPageCount) {
	}

	protected abstract void pageIndexChanged(int oldPageIndex, int newPageIndex) {
	}

	public synchronized int getRowCount() {
	}

	public void tableChanged(javax.swing.event.TableModelEvent e) {
	}

	/**
	 *  Called each time one or more contiguous rows are inserted into the underlying <code>TableModel</code>. This
	 *  default implementation simply fires a corresponding <code>TableModelEvent</code> to the listeners on this model.
	 * 
	 *  @param firstRow the index of the first row that was inserted
	 *  @param lastRow  the index of the last row that was inserted
	 */
	protected void tableRowsInserted(int firstRow, int lastRow) {
	}

	/**
	 *  Called each time one or more contiguous rows are deleted from the underlying <code>TableModel</code>. This
	 *  default implementation simply fires a corresponding <code>TableModelEvent</code> to the listeners on this model.
	 * 
	 *  @param firstRow the index of the first row that was deleted
	 *  @param lastRow  the index of the last row that was deleted
	 */
	protected void tableRowsDeleted(int firstRow, int lastRow) {
	}

	/**
	 *  Called each time one or more contiguous rows are updated in the underlying <code>TableModel</code>. simply fires
	 *  a corresponding <code>TableModelEvent</code> to the listeners on this model.
	 * 
	 *  @param firstRow the index of the first row that was updated
	 *  @param lastRow  the index of the last row that was updated
	 */
	protected void tableRowsUpdated(int firstRow, int lastRow) {
	}

	/**
	 *  Called each time the cells in <code>column</code> in the range [<code>firstRow</code>, <code>lastRow</code>] are
	 *  updated. This default implementation simply fires a corresponding <code> TableModelEvent</code> to the listeners
	 *  on this model.
	 * 
	 *  @param firstRow the index of the first row in the above <code> column</code> that was updated
	 *  @param lastRow  the index of the last row in the above <code> column</code> that was updated
	 *  @param column   the index of the column that was updated
	 */
	public void fireTableCellsUpdated(int firstRow, int lastRow, int column) {
	}

	/**
	 *  Called each time the cells in <code>column</code> in the range [<code>firstRow</code>, <code>lastRow</code>] are
	 *  updated. This default implementation simply fires a corresponding <code> TableModelEvent</code> to the listeners
	 *  on this model.
	 * 
	 *  @param column   the index of the column that was updated
	 *  @param firstRow the index of the first row in the above <code> column</code> that was updated
	 *  @param lastRow  the index of the last row in the above <code> column</code> that was updated
	 */
	protected void tableCellsUpdated(int column, int firstRow, int lastRow) {
	}

	/**
	 *  Creates a CompoundTableModelEvent instance.
	 * 
	 *  @return the CompoundTableModelEvent instance.
	 */
	protected CompoundTableModelEvent createCompoundTableModelEvent() {
	}

	/**
	 *  Called each time all of the data (i.e. all rows) is changed in the underlying<code>TableModel</code>.  This
	 *  default implementation simply fires a corresponding <code>TableModelEvent</code> to the listeners on this model.
	 */
	protected void tableDataChanged() {
	}

	/**
	 *  Called each time the structure (<code>TableColumn</code>s, etc) of the underlying <code>TableModel</code>
	 *  changes. This default implementation simply fires a corresponding <code>TableModelEvent </code> to the listeners
	 *  on this model.
	 */
	protected void tableStructureChanged() {
	}

	@java.lang.Override
	public void fireTableChanged(javax.swing.event.TableModelEvent e) {
	}

	public ConverterContext getConverterContextAt(int rowIndex, int columnIndex) {
	}

	public EditorContext getEditorContextAt(int rowIndex, int columnIndex) {
	}

	public Class getCellClassAt(int rowIndex, int columnIndex) {
	}

	public int getColumnType(int columnIndex) {
	}

	public int getTableIndex(int columnIndex) {
	}
}
