package com.jidesoft.grid;


/**
 *  <code>AdvancedPageTableModel</code> extends <code>AbstractPageTableModel</code> and provides more advanced features
 *  such as sorting and filtering. However it doesn't implement it by leaving it to the subclass. For example, if you are
 *  using Hibernate, you can ask Hibernate to do the filtering or sorting for you. Or if you have a business logic layer
 *  in your application, you can handle it in the business logic layer. All other logic is implemented in this class and
 *  you only need to implement {@link #refreshData(SortItemSupport, FilterItemSupport, int, int)} method to provide the
 *  content for the current page.
 */
public abstract class AdvancePageTableModel extends AbstractPageTableModel {

	protected SortItemSupport _sortItemSupport;

	protected FilterItemSupport _filterItemSupport;

	public AdvancePageTableModel() {
	}

	protected AdvancePageTableModel(int pageSize) {
	}

	@java.lang.Override
	protected void pageCountChanged(int oldPageCount, int newPageCount) {
	}

	@java.lang.Override
	protected void pageIndexChanged(int oldPageIndex, int newPageIndex) {
	}

	public void setTotalRecordCount(int totalRecordCount) {
	}

	public int getTotalRecordCount() {
	}

	public int getColumnCount() {
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
	}

	@java.lang.Override
	public boolean isCellEditable(int rowIndex, int columnIndex) {
	}

	@java.lang.Override
	public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
	}

	@java.lang.Override
	public Class getColumnClass(int columnIndex) {
	}

	@java.lang.Override
	public String getColumnName(int column) {
	}

	public int getSortedRowAt(int actualRow) {
	}

	public int getActualRowAt(int row) {
	}

	public void sortColumn(int column) {
	}

	public void sortColumn(int column, boolean reset) {
	}

	public void unsortColumn(int column) {
	}

	public void reverseColumnSortOrder(int column) {
	}

	public void sortColumn(int column, boolean reset, boolean ascending) {
	}

	public boolean isColumnSorted(int column) {
	}

	public boolean isColumnAscending(int column) {
	}

	public void reset() {
	}

	public void toggleSortOrder(int column, boolean extend) {
	}

	public java.util.List getSortingColumns() {
	}

	public void setSortingColumns(java.util.List list) {
	}

	public int getColumnSortRank(int column) {
	}

	public void setMasterSortColumns(int[] masterSortColumns) {
	}

	public int[] getMasterSortColumns() {
	}

	public boolean isMultiColumnSortable() {
	}

	public void setMultiColumnSortable(boolean multiColumnSortable) {
	}

	public boolean isSortable() {
	}

	public void setSortable(boolean sortable) {
	}

	public void resort() {
	}

	public int getSortPriority() {
	}

	public void setSortPriority(int sortPriority) {
	}

	public int getMaximumSortColumns() {
	}

	public void setMaximumSortColumns(int maximumSortColumns) {
	}

	/**
	 *  Adds the specified listener to receive SortEvents pane events from this SortableTableModel.
	 * 
	 *  @param l the SortListener
	 */
	public void addSortListener(SortListener l) {
	}

	/**
	 *  Removes the specified SortListener so that it no longer receives SortEvents from this SortableTableModel .
	 * 
	 *  @param l the SortableTableModel listener
	 */
	public void removeSortListener(SortListener l) {
	}

	/**
	 *  Returns an array of all the <code>SortListener</code>s added to this <code>SortableTableModel</code> with
	 *  <code>addSortListener</code>.
	 * 
	 *  @return all of the <code>SortListener</code>s added or an empty array if no listeners have been added
	 *  @see #addSortListener
	 */
	public SortListener[] getSortListeners() {
	}

	/**
	 *  Fires sort event.
	 */
	public void fireSortEvent() {
	}

	/**
	 *  Fires sort event.
	 */
	public void fireSortingEvent() {
	}

	/**
	 *  Check if a certain column is sortable.
	 * 
	 *  @return true if this table column is sortable.
	 *  @see #setColumnSortable(int, boolean)
	 */
	public boolean isColumnSortable(int column) {
	}

	/**
	 *  Sets a column sortable or not sortable. Please note, you will have to set it again if the table model structure
	 *  is changed. By default, all columns are sortable.
	 * 
	 *  @param column   the column index.
	 *  @param sortable true to make the column sortable.
	 */
	public void setColumnSortable(int column, boolean sortable) {
	}

	protected void sort() {
	}

	public void refresh() {
	}

	public boolean isColumnFilterable(int column) {
	}

	public boolean isColumnVisible(int column) {
	}

	public boolean isColumnAutoFilterable(int column) {
	}

	public boolean isValuePredetermined(int column) {
	}

	public void addFilter(int column, Filter filter) {
	}

	public void addFilter(Filter filter) {
	}

	public void addFilter(FilterItem filterItem) {
	}

	public void removeFilter(int column, Filter filter) {
	}

	public void removeFilter(Filter filter) {
	}

	public void removeFilter(FilterItem filterItem) {
	}

	public void removeAllFilters(int column) {
	}

	public void removeAllFilters() {
	}

	public void clearFilters() {
	}

	public Filter[] getFilters(int column) {
	}

	public java.util.List getFilterItems() {
	}

	public void setFiltersApplied(boolean apply) {
	}

	public boolean isFiltersApplied() {
	}

	public boolean hasFilter() {
	}

	public boolean hasFilter(int columnIndex) {
	}

	public boolean isAndMode() {
	}

	public void setAndMode(boolean andMode) {
	}

	/**
	 *  Checks if the FilterableTableModel is adjusting. If it is adjusting, FilterableTableModel will not apply filter
	 *  when the actual list model changes.
	 * 
	 *  @return true if adjusting. Otherwise false.
	 */
	public boolean isAdjusting() {
	}

	/**
	 *  Sets the FilterableTableModel to adjusting mode. If it is adjusting, FilterableTableModel will not apply filter
	 *  when the actual table model changes. After you set adjusting to false, FilterableListModel will re-apply the
	 *  filter.
	 * 
	 *  @param adjusting true or false.
	 */
	public void setAdjusting(boolean adjusting) {
	}

	public Object[] getPossibleValues(int columnIndex, java.util.Comparator comparator) {
	}

	public Object[] getPossibleValuesAndConverters(int columnIndex, java.util.Comparator comparator) {
	}

	public boolean isSameConverterAt(int columnIndex) {
	}

	public void setFilteringPaused(boolean pause) {
	}

	public boolean isFilteringPaused() {
	}

	/**
	 *  Adds a listener to the list that's notified each time a change to the filter occurs.
	 * 
	 *  @param l the FilterableTableModelListener
	 */
	public void addFilterableTableModelListener(FilterableTableModelListener l) {
	}

	/**
	 *  Removes a listener from the list that's notified each time a change to the filter occurs.
	 * 
	 *  @param l the FilterableTableModelListener
	 */
	public void removeFilterableTableModelListener(FilterableTableModelListener l) {
	}

	/**
	 *  Returns an array of all the FilterableTableModel listeners registered on this filter.
	 * 
	 *  @return all of this filter's <code>FilterableTableModelListener</code>s or an empty array if no filter listeners
	 *          are currently registered
	 *  @see #addFilterableTableModelListener
	 *  @see #removeFilterableTableModelListener
	 */
	public FilterableTableModelListener[] getFilterableTableModelListeners() {
	}

	/**
	 *  Forwards the given notification event to all <code>FilterableTableModelListeners</code> that registered
	 *  themselves as listeners for this table model.
	 * 
	 *  @param e the event to be forwarded
	 *  @see #addFilterableTableModelListener
	 *  @see com.jidesoft.grid.FilterableTableModelEvent
	 *  @see javax.swing.event.EventListenerList
	 */
	public void fireFilterChanged(FilterableTableModelEvent e) {
	}

	public void fireFilterAdded(int column, Filter filter) {
	}

	public void fireFilterRemoved(int column, Filter filter) {
	}

	/**
	 *  Gets the filter icon for a particular column.
	 * 
	 *  @param column the column index.
	 *  @return the icon.
	 */
	public javax.swing.Icon getFilterIcon(int column) {
	}

	public javax.swing.table.TableModel getCurrentPageModel() {
	}

	public void setCurrentPageModel(javax.swing.table.TableModel model) {
	}

	/**
	 *  Submits the query. At the end of the methods, you just need to create a table model that represents one page of
	 *  the whole table model and call {@link #setCurrentPageModel(javax.swing.table.TableModel)}.
	 * 
	 *  @param sortItemSupport   the information for sort items.
	 *  @param filterItemSupport the information for filter items.
	 *  @param currentPage       the current page.
	 *  @param pageSize          the page size.
	 */
	public abstract void refreshData(SortItemSupport sortItemSupport, FilterItemSupport filterItemSupport, int currentPage, int pageSize) {
	}

	public DynamicTableFilter[] getDynamicTableFilters(int modelIndex) {
	}

	public boolean isAllowMultipleValues(int column) {
	}

	public StringConverter getTitleConverter(int column) {
	}

	public FilterTitleFormatter getFilterTitleFormatter(int column) {
	}

	public javax.swing.ListCellRenderer getListCellRenderer(int column) {
	}

	public boolean isUseTableCellRenderer(int column) {
	}

	public boolean isAllowCustomFilter(int column) {
	}
}
