package com.jidesoft.grid;


/**
 *  <code>DefaultPageTableModel</code> extends <code>AbstractPageTableModel</code> to provide a default implementation
 *  for {@link com.jidesoft.paging.PageNavigationSupport}. It uses the table model wrapper technique we used in JIDE
 *  Grids to provide a view into one page of the original table model. {@link com.jidesoft.paging.PageNavigationBar}
 *  leverages this class to implement the page navigation for any table model.
 *  <p/>
 *  To create a <code>DefaultPageTableModel</code>, you need the original table model.
 *  <code><pre>
 *  DefaultPageTableModel pageTableModel = new DefaultPageTableModel(originalTableModel);
 *  JTable table = new JTable(pageTableModel);
 *  </pre></code>
 *  With this code above, JTable will display the first 10 rows of the original table model. You can call methods such as
 *  {@link #setCurrentPage(int)} to open other pages. You could add buttons to control this
 *  <code>DefaultPageTableModel</code> but that's exactly what <code>PageNavigationBar</code> is for. So in the other
 *  word, there is no need to use <code>DefaultPageTableModel</code> directly unless you want to control the page
 *  navigation yourself.
 * 
 *  @see com.jidesoft.paging.PageNavigationBar
 */
public class DefaultPageTableModel extends AbstractPageTableModel {

	/**
	 *  Creates a <code>DefaultPageTableModel</code> with 10 as the page size.
	 * 
	 *  @param model the original table model.
	 */
	public DefaultPageTableModel(javax.swing.table.TableModel model) {
	}

	/**
	 *  Creates a <code>DefaultPageTableModel</code> with a page size.
	 * 
	 *  @param model    the original table model.
	 *  @param pageSize the page size.
	 */
	public DefaultPageTableModel(javax.swing.table.TableModel model, int pageSize) {
	}

	/**
	 *  Sets the new table model for the DefaultPageTableModel.
	 * 
	 *  @param model the new table model
	 *  @since 3.5.5
	 */
	public void setTableModel(javax.swing.table.TableModel model) {
	}

	public int getActualRowAt(int visualRow) {
	}

	public int getVisualRowAt(int actualRow) {
	}

	public javax.swing.table.TableModel getActualModel() {
	}

	public void addIndexChangeListener(IndexChangeListener l) {
	}

	public void removeIndexChangeListener(IndexChangeListener l) {
	}

	@java.lang.Override
	public IndexChangeListener[] getIndexChangeListeners() {
	}

	@java.lang.Override
	protected void pageCountChanged(int oldPageCount, int newPageCount) {
	}

	@java.lang.Override
	protected void pageIndexChanged(int oldPageIndex, int newPageIndex) {
	}

	public int getColumnCount() {
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
	}

	@java.lang.Override
	public Class getColumnClass(int columnIndex) {
	}

	public ConverterContext getConverterContextAt(int rowIndex, int columnIndex) {
	}

	public EditorContext getEditorContextAt(int rowIndex, int columnIndex) {
	}

	public Class getCellClassAt(int rowIndex, int columnIndex) {
	}

	@java.lang.Override
	public String getColumnName(int column) {
	}

	public Object getColumnIdentifier(int columnIndex) {
	}

	@java.lang.Override
	public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
	}

	@java.lang.Override
	public boolean isCellEditable(int rowIndex, int columnIndex) {
	}

	public int getTotalRecordCount() {
	}

	public void setTotalRecordCount(int totalRecordCount) {
	}

	public int[] getIndexes() {
	}

	public void setIndexes(int[] indexes) {
	}

	protected void reallocateIndexes() {
	}

	public boolean isUpdatable() {
	}

	@java.lang.Override
	public int getColumnType(int columnIndex) {
	}

	@java.lang.Override
	public int getTableIndex(int columnIndex) {
	}

	@java.lang.Override
	public Row getRowAt(int rowIndex) {
	}

	@java.lang.Override
	public int getRowIndex(Row row) {
	}

	@java.lang.Override
	public Object getRoot() {
	}

	@java.lang.Override
	public IndexedRowTableModelWrapper getIndexedRowTableModelWrapper() {
	}
}
