package com.jidesoft.grid;


/**
 *  PagedTablePane is a panel that displays several tables side by side so that more rows are visible at the same time.
 *  A perfect use case is to display a table with not many columns but many rows in a very wide area. If we only display
 *  one table in the area, you may only see 20 rows at a time but if you use PagedTablePane, you can see 40 or 60 rows at
 *  a time.
 *  <p>
 *  <tt >PagedTablePane</tt> must work together with <tt>PagedTablePaneNavigationBar</tt>. You may choose not to display the PagedTablePaneNavigationBar
 *  but you must create one using new PagedTablePaneNavigationBar(a PagedTablePane) to enable the page navigation in the tables.
 */
public class PagedTablePane extends javax.swing.JPanel {

	/**
	 *  True if row selection is allowed in this table scroll pane.
	 */
	protected boolean _rowSelectionAllowed;

	/**
	 *  True if column selection is allowed in this table.
	 */
	protected boolean _columnSelectionAllowed;

	/**
	 *  True if non-contiguous selection is allowed in this table.
	 */
	protected boolean _nonContiguousCellSelectionAllowed;

	/**
	 *  Creates a PagedTablePane with two tables side by side.
	 * 
	 *  @param tableModel the table model.
	 */
	public PagedTablePane(javax.swing.table.TableModel tableModel) {
	}

	public PagedTablePane(javax.swing.table.TableModel tableModel, int column) {
	}

	public void setModel(javax.swing.table.TableModel tableModel) {
	}

	public javax.swing.table.TableModel getModel() {
	}

	/**
	 *  Overrides to create your own table. By default, we will create a SortableTable.
	 * 
	 *  @param model the model
	 *  @return the table
	 */
	protected javax.swing.JTable createTable(javax.swing.table.TableModel model) {
	}

	public javax.swing.JTable[] getTables() {
	}

	/**
	 *  Sets whether the rows in this model can be selected.
	 * 
	 *  @param rowSelectionAllowed true if this model will allow row selection
	 *  @see #getRowSelectionAllowed
	 */
	public void setRowSelectionAllowed(boolean rowSelectionAllowed) {
	}

	/**
	 *  Returns true if rows can be selected.
	 * 
	 *  @return true if rows can be selected, otherwise false
	 * 
	 *  @see #setRowSelectionAllowed
	 */
	public boolean getRowSelectionAllowed() {
	}

	/**
	 *  Sets whether the columns in this model can be selected.
	 * 
	 *  @param columnSelectionAllowed true if this model will allow column selection
	 *  @see #getColumnSelectionAllowed
	 */
	public void setColumnSelectionAllowed(boolean columnSelectionAllowed) {
	}

	/**
	 *  Returns true if columns can be selected.
	 * 
	 *  @return true if columns can be selected, otherwise false
	 * 
	 *  @see #setColumnSelectionAllowed
	 */
	public boolean getColumnSelectionAllowed() {
	}

	/**
	 *  Sets whether this table allows both a column selection and a row selection to exist simultaneously. When set, the
	 *  table treats the intersection of the row and column selection models as the selected cells. Override
	 *  <code>isCellSelected</code> to change this default behavior. This method is equivalent to setting both the
	 *  <code>rowSelectionAllowed</code> property and <code>columnSelectionAllowed</code> property of the
	 *  <code>columnModel</code> to the supplied value.
	 * 
	 *  @param cellSelectionEnabled true if simultaneous row and column selection is allowed
	 *  @see #getCellSelectionEnabled
	 */
	public void setCellSelectionEnabled(boolean cellSelectionEnabled) {
	}

	/**
	 *  Returns true if both row and column selection models are enabled. Equivalent to <code>getRowSelectionAllowed() &&
	 *  getColumnSelectionAllowed()</code>.
	 * 
	 *  @return true if both row and column selection models are enabled
	 * 
	 *  @see #setCellSelectionEnabled
	 */
	public boolean getCellSelectionEnabled() {
	}

	/**
	 *  Sets whether non-contiguous cell selection in this model can be selected. Please note, non-contiguous cell
	 *  selection is a feature in JideTable so you have to use JideTable or its subclasses in order to use this option.
	 *  Also please note, due to limitation of TableScrollPane, only one table can be selected at a time. In the other
	 *  words, you can't select a few cells in header table and a few cells in the main table.
	 * 
	 *  @param nonContiguousCellSelectionAllowed
	 *          true if this model will allow non-contiguous cell selection
	 *  @see #isNonContiguousCellSelectionAllowed
	 */
	public void setNonContiguousCellSelectionAllowed(boolean nonContiguousCellSelectionAllowed) {
	}

	/**
	 *  Returns true if non-contiguous cell selection can be selected.
	 * 
	 *  @return true if -contiguous cell selection is enabled, otherwise false
	 * 
	 *  @see #setNonContiguousCellSelectionAllowed
	 */
	public boolean isNonContiguousCellSelectionAllowed() {
	}

	protected void resynchronizeTablesSelection() {
	}

	/**
	 *  Gets the total row count of TableScrollPane.
	 * 
	 *  @return the total row count of TableScrollPane.
	 */
	public int getRowCount() {
	}

	/**
	 *  Gets the total column count of TableScrollPane.
	 * 
	 *  @return the total column count of TableScrollPane.
	 */
	public int getColumnCount() {
	}

	/**
	 *  Gets the table as the specified row index.
	 * 
	 *  @param row the row index related to TableScrollPane.
	 *  @return a TablePosition. The table field in TablePosition is the child table and the row field is the converted
	 *          row index relative to the child table. The column field is always -1. Because the column index is not
	 *          specified, the table could only be the main table or the column footer table. It will never be the row
	 *          header tables or the row footer table.
	 */
	public PagedTablePane.TablePosition getTableAtRow(int row) {
	}

	/**
	 *  Gets the table as the specified row and column index.
	 * 
	 *  @param row    the row index related to TableScrollPane.
	 *  @param column the column index related to TableScrollPane.
	 *  @return a TablePosition. The table field in TablePosition is the child table, the column field is the converted
	 *          column index relative to the child table and the row field is the converted row index relative to the
	 *          child table.
	 */
	public PagedTablePane.TablePosition getTableAtCell(int row, int column) {
	}

	/**
	 *  Returns the name of the column appearing in the view at column position <code>column</code>.
	 * 
	 *  @param column the column in the view being queried
	 *  @return the name of the column at position <code>column</code> in the view where the first column is column 0
	 */
	public String getColumnName(int column) {
	}

	/**
	 *  Returns the type of the column appearing in the view at column position <code>column</code>.
	 * 
	 *  @param column the column in the view being queried
	 *  @return the type of the column at position <code>column</code> in the view where the first column is column 0
	 */
	public Class getColumnClass(int column) {
	}

	/**
	 *  Returns the cell value at <code>row</code> and <code>column</code>.
	 *  <p/>
	 *  <b>Note</b>: The column is specified in the table view's display order, and not in the <code>TableModel</code>'s
	 *  column order.  This is an important distinction because as the user rearranges the columns in the table, the
	 *  column at a given index in the view will change. Meanwhile the user's actions never affect the model's column
	 *  ordering.
	 * 
	 *  @param row    the row whose value is to be queried
	 *  @param column the column whose value is to be queried
	 *  @return the Object at the specified cell
	 */
	public Object getValueAt(int row, int column) {
	}

	/**
	 *  Sets the value for the cell in the table model at <code>row</code> and <code>column</code>.
	 *  <p/>
	 *  <b>Note</b>: The column is specified in the table view's display order, and not in the <code>TableModel</code>'s
	 *  column order.  This is an important distinction because as the user rearranges the columns in the table, the
	 *  column at a given index in the view will change. Meanwhile the user's actions never affect the model's column
	 *  ordering.
	 *  <p/>
	 *  <code>aValue</code> is the new value.
	 * 
	 *  @param aValue the new value
	 *  @param row    the row of the cell to be changed
	 *  @param column the column of the cell to be changed
	 *  @see #getValueAt
	 */
	public void setValueAt(Object aValue, int row, int column) {
	}

	/**
	 *  Returns true if the cell at <code>row</code> and <code>column</code> is editable.  Otherwise, invoking
	 *  <code>setValueAt</code> on the cell will have no effect.
	 *  <p/>
	 *  <b>Note</b>: The column is specified in the table view's display order, and not in the <code>TableModel</code>'s
	 *  column order.  This is an important distinction because as the user rearranges the columns in the table, the
	 *  column at a given index in the view will change. Meanwhile the user's actions never affect the model's column
	 *  ordering.
	 * 
	 *  @param row    the row whose value is to be queried
	 *  @param column the column whose value is to be queried
	 *  @return true if the cell is editable
	 * 
	 *  @see #setValueAt
	 */
	public boolean isCellEditable(int row, int column) {
	}

	/**
	 *  Returns the index of the first selected row, -1 if no row is selected.
	 * 
	 *  @return the index of the first selected row
	 */
	public int getSelectedRow() {
	}

	/**
	 *  Returns the index of the first selected column, -1 if no column is selected.
	 * 
	 *  @return the index of the first selected column
	 */
	public int getSelectedColumn() {
	}

	/**
	 *  Returns the indices of all selected rows.
	 * 
	 *  @return an array of integers containing the indices of all selected rows, or an empty array if no row is
	 *          selected
	 * 
	 *  @see #getSelectedRow
	 */
	public int[] getSelectedRows() {
	}

	/**
	 *  Convert the view column index in the entire TableScrollPane to model index.
	 * 
	 *  @param modelIndex the model column index
	 *  @return the view index
	 */
	public int convertColumnIndexToView(int modelIndex) {
	}

	/**
	 *  Convert the view column index in the entire TableScrollPane to model index.
	 * 
	 *  @param viewIndex the view column index counting from 0 including row header table, main table and row footer table
	 *  @return the model index.
	 */
	public int convertColumnIndexToModel(int viewIndex) {
	}

	/**
	 *  Returns the indices of all selected columns.
	 * 
	 *  @return an array of integers containing the indices of all selected columns, or an empty array if no column is
	 *          selected
	 * 
	 *  @see #getSelectedColumn
	 */
	public int[] getSelectedColumns() {
	}

	/**
	 *  Returns the number of selected rows.
	 * 
	 *  @return the number of selected rows, 0 if no rows are selected
	 */
	public int getSelectedRowCount() {
	}

	/**
	 *  Returns the number of selected columns.
	 * 
	 *  @return the number of selected columns, 0 if no columns are selected
	 */
	public int getSelectedColumnCount() {
	}

	/**
	 *  Returns true if the specified index is in the valid range of rows, and the row at that index is selected.
	 * 
	 *  @return true if <code>row</code> is a valid index and the row at that index is selected (where 0 is the first
	 *          row)
	 */
	public boolean isRowSelected(int row) {
	}

	/**
	 *  Returns true if the specified index is in the valid range of columns, and the column at that index is selected.
	 * 
	 *  @param column the column in the column model
	 *  @return true if <code>column</code> is a valid index and the column at that index is selected (where 0 is the
	 *          first column)
	 */
	public boolean isColumnSelected(int column) {
	}

	/**
	 *  Returns true if the specified indices are in the valid range of rows and columns and the cell at the specified
	 *  position is selected.
	 * 
	 *  @param row    the row being queried
	 *  @param column the column being queried
	 *  @return true if <code>row</code> and <code>column</code> are valid indices and the cell at index <code>(row,
	 *          column)</code> is selected, where the first row and first column are at index 0
	 */
	public boolean isCellSelected(int row, int column) {
	}

	/**
	 *  Deselects all selected columns and rows.
	 */
	public void clearSelection() {
	}

	public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
	}

	/**
	 *  A class that define a table, a row index and a column index. This class is used by {@link
	 *  TableScrollPane#getTableAtCell(int, int)}, {@link TableScrollPane#getTableAtRow(int)} and {@link
	 *  TableScrollPane#getTableAtColumn(int)} to convert the row index and column index from the TableScrollPane to its
	 *  child tables.
	 */
	public static class TablePosition {


		public PagedTablePane.TablePosition(javax.swing.JTable table, int row, int column) {
		}

		/**
		 *  Get the table field in the class.
		 * 
		 *  @return the JTable.
		 */
		public javax.swing.JTable getTable() {
		}

		/**
		 *  Get the row in the table.
		 * 
		 *  @return the row index.
		 */
		public int getRow() {
		}

		/**
		 *  Get the column in the table.
		 * 
		 *  @return the column index.
		 */
		public int getColumn() {
		}
	}
}
