/**
 *  The package contains classes related for paging and page navigation support for JIDE Data Grids product.
 */
package com.jidesoft.paging;


/**
 *  <code>AbstractPageNavigationSupport</code> is an abstract implementation of <code>PageNavigationSupport</code>. It
 *  implements almost all the interface methods except <code>getTotalRecordCount</code> and
 *  <code>setTotalRecordCount</code>.
 */
public abstract class AbstractPageNavigationSupport implements PageNavigationSupport {

	public AbstractPageNavigationSupport(javax.swing.event.EventListenerList listenerList) {
	}

	public AbstractPageNavigationSupport(int pageSize, javax.swing.event.EventListenerList listenerList) {
	}

	public int getPageSize() {
	}

	public void setPageSize(int pageSize) {
	}

	public int getCurrentPage() {
	}

	public void setCurrentPage(int page) {
	}

	protected void setPageCount(int pageCount) {
	}

	public int getPageCount() {
	}

	public void nextPage() {
	}

	public void previousPage() {
	}

	public void firstPage() {
	}

	public void lastPage() {
	}

	/**
	 *  Adds a <code>PageNavigationListener</code> to the page.
	 * 
	 *  @param l the <code>PageNavigationListener</code> to be added
	 */
	public void addPageNavigationListener(PageNavigationListener l) {
	}

	/**
	 *  Removes a <code>PageNavigationListener</code> from the page.
	 * 
	 *  @param l the <code>PageNavigationListener</code> to be removed
	 */
	public void removePageNavigationListener(PageNavigationListener l) {
	}

	/**
	 *  Returns an array of all the <code>PageNavigationListener</code>s added to this <code>Page</code> with
	 *  <code>addPageNavigationListener</code> .
	 * 
	 *  @return all of the <code>PageNavigationListener</code>s added, or an empty array if no listeners have been added
	 */
	public PageNavigationListener[] getPageNavigationListeners() {
	}

	/**
	 *  Runs each <code>PageNavigationListener</code>'s <code>PageNavigationEventFired</code> method.
	 * 
	 *  @param source   of this event
	 *  @param id       event id.
	 *  @param oldValue the old value associated with this event.
	 *  @param newValue the new value associated with this event.
	 */
	public void firePageNavigationEvent(Object source, int id, int oldValue, int newValue) {
	}
}
