/**
 *  The package contains classes related for paging and page navigation support for JIDE Data Grids product.
 */
package com.jidesoft.paging;


/**
 *  <code>PageNavigationBar</code> provides a quick way to paginate a JTable, a TableScrollPane or a JList. All you need
 *  to do is to call new PageNavigationBar(table) or new PageNavigationBar(list) and add the PageNavigationBar below or
 *  above the table or the list. PageNavigationBar will automatically paginate the table or the list. PageNavigationBar
 *  provides a page index field and buttons to navigate the pages. If the table or the list doesn't have a model that
 *  implementing {@link PageNavigationSupport}, it will automatically create a {@link DefaultPageTableModel} or {@link
 *  DefaultPageListModel} to provide the paging support. Otherwise it will use the existing mode that implements
 *  PageNavigationSupport.
 *  <p/>
 *  <code>PageNavigationBar</code> uses methods provided by <code>PageNavigationSupport</code> to navigate the pages. It
 *  has four buttons and one field. The four buttons are for the first page, the previous page, the next page and the
 *  last page. The field displays the current page index and the total page count. It also allows user to type in the
 *  page index in it and press enter to jump to that page. It has a context menu where allows user to switch from the
 *  default page index mode to the row index mode. In the row index mode, instead of displaying the current page, it
 *  displays the current row index and the total row count. Typing the row index and enter will jump to the row. User can
 *  also press UP, DOWN, PAGE_UP, PAGE_DOWN, CTRL + PAGE_UP, CTRL + PAGE_DOWN, CTRL + HOME, and CTRL + END to navigate
 *  the pages when the focus is in the field. It will also beep when users try to navigate to a page that is not
 *  available. For example user presses page up when it is already on the first page, or try to jump to 100 page when
 *  there are only 99 pages.
 */
public class PageNavigationBar extends javax.swing.JToolBar implements java.beans.PropertyChangeListener {

	protected PageNavigationSupport _pageNavigationSupport;

	public static final String COMMAND_FIRST = "moveToBeginning";

	public static final String COMMAND_PREVIOUS = "moveLeft";

	public static final String COMMAND_NEXT = "moveRight";

	public static final String COMMAND_LAST = "moveToEnd";

	public static final String COMMAND_GOTO = "moveTo";

	public final String CLIENT_PROPERTY_ALWAYS_DISABLED = "PageNavigationBar.alwaysDisabled";

	protected PageNavigationField _pageNavigationField;

	protected PageNavigationBar() {
	}

	/**
	 *  The constructor to install a PageNavigationBar over a TableScrollPane.
	 * 
	 *  @param pane the table scroll pane
	 * 
	 *  @since 3.1.1
	 */
	public PageNavigationBar(TableScrollPane pane) {
	}

	/**
	 *  Creates the page table model.
	 *  <p/>
	 *  By default, it creates a DefaultPageTableModel.
	 * 
	 *  @param model    the target table's model
	 *  @param pageSize the row size of each page
	 * 
	 *  @return the installed table model to support page navigation.
	 */
	protected PageNavigationSupport createPageTableModel(javax.swing.table.TableModel model, int pageSize) {
	}

	/**
	 *  The property change listener to handle the model change of JList/JTable/TableScrollPane.
	 * 
	 *  @param evt the property change event
	 *  @since 3.4.4
	 */
	@java.lang.Override
	public void propertyChange(java.beans.PropertyChangeEvent evt) {
	}

	protected void initComponents() {
	}

	/**
	 *  Creates a ChangeListener that will be added to the NavigationField.
	 * 
	 *  @return a ChangeListener
	 */
	protected javax.swing.event.ChangeListener createChangeListener() {
	}

	/**
	 *  Update the tooltip text of navigation buttons according to the navigation type
	 *  @param key
	 *  @param action
	 *  @since 3.4.2
	 */
	protected void updateTooltipText(String key, javax.swing.Action action) {
	}

	/**
	 *  Creates a FocusListener that will be added to the NavigationField.
	 * 
	 *  @return a FocusListener
	 */
	protected java.awt.event.FocusListener createFocusListener() {
	}

	/**
	 *  Creates a PageNavigationListener that will be added to the PageNavigationSupport.
	 * 
	 *  @return a PageNavigationListener
	 */
	protected PageNavigationListener createPageNavigationListener() {
	}

	/**
	 *  Creates a ListSelectionListener that will be added to the table or the list.
	 * 
	 *  @return a ListSelectionListener
	 */
	protected javax.swing.event.ListSelectionListener createSelectionListener() {
	}

	/**
	 *  Creates a MouseWheelListener that will be added to the table or the list.
	 * 
	 *  @return a MouseWheelListener
	 */
	protected java.awt.event.MouseWheelListener createMouseWheelListener() {
	}

	/**
	 *  Registers the navigation keystrokes. The keystrokes are <ul> <li> UP: the previous record/row <li> DOWN: the next
	 *  record/row <li> PAGE_UP: the previous page <li> PAGE_DOWN: the next page <li> CTRL + PAGE_UP: the first
	 *  record/row in the current page <li> CTRL + PAGE_DOWN: the last record/row in the current page <li> CTRL + END:
	 *  the last record/row in the last page <li> CTRL + HOME: the first record/row in the first page </ul> Those
	 *  keystrokes are supported in both the table/list as well as in the PageNavigationField on the PageNavigationBar.
	 * 
	 *  @param component the component to register actions
	 */
	protected void registerKeyboardActions(javax.swing.JComponent component) {
	}

	/**
	 *  Gets the current record. It is the selected row as in the whole table or list model. If the table or the list is
	 *  not selected, we treat it as the first row is selected.
	 * 
	 *  @return the current record.
	 */
	public int getCurrentRecord() {
	}

	/**
	 *  Sets the table model of the page navigation bar if the wrapped component is a JTable.
	 * 
	 *  @param model the original table model
	 *  @since 3.4.2
	 */
	public void setTableModel(javax.swing.table.TableModel model) {
	}

	/**
	 *  Sets the list model of the page navigation bar if the wrapped component is a JList.
	 * 
	 *  @param model the original list model
	 *  @since 3.4.2
	 */
	public void setListModel(javax.swing.ListModel model) {
	}

	/**
	 *  Creates the navigation field.
	 * 
	 *  @return the navigation field.
	 * 
	 *  @since 3.1.1
	 */
	protected PageNavigationField createNavigationField() {
	}

	/**
	 *  Gets the navigation field.
	 * 
	 *  @return the navigation field.
	 * 
	 *  @since 3.1.1
	 */
	public PageNavigationField getNavigationField() {
	}

	/**
	 *  Updates the navigation field.
	 * 
	 *  @since 3.1.1
	 */
	protected void updateNavigationField() {
	}

	/**
	 *  Creates the button. Our default code is
	 *  <code><pre>
	 *  protected AbstractButton createButton(Action action) {
	 *      AbstractButton button = new JideButton(action);
	 *      button.setName("" + action.getValue(Action.ACTION_COMMAND_KEY));
	 *      button.setDisabledIcon((Icon) action.getValue("disabledIcon"));
	 *      button.setRequestFocusEnabled(false);
	 *      AutoRepeatButtonUtils.install(button, 50, 200);
	 *      return button;
	 *  }
	 *  </pre></code>
	 * 
	 *  @param action the action for the button.
	 * 
	 *  @return a button.
	 */
	protected javax.swing.AbstractButton createButton(javax.swing.Action action) {
	}

	/**
	 *  Gets the localized string from resource bundle. Subclass can override it to provide its own string. For example,
	 *  you can customize the icons by overriding this method. The key for the icons will be in the format of
	 *  "PageNavigationBar.moveLeft.icon" and "PageNavigationBar.moveLeft.disabledIcon" for the move left button. There
	 *  are a total of eight buttons. Once you override, you can return a full qualified path to the icon resource such
	 *  as "/com/yourcompany/icons/moveLeft.png". Note that the icon must be in the class path so that we can access it
	 *  as resource.
	 * 
	 *  @param key the key
	 * 
	 *  @return the localized string.
	 */
	protected String getResourceString(String key) {
	}

	/**
	 *  Gets the flag indicating if PageNavigationBar will automatically select the same view index as previous page
	 *  while changing pages.
	 * 
	 *  @return true if view index will be selected. Otherwise false.
	 * 
	 *  @see #setSelectViewIndex(boolean)
	 */
	public boolean isSelectViewIndex() {
	}

	/**
	 *  Sets the flag indicating if PageNavigationBar will automatically select the same view index as previous page
	 *  while changing pages.
	 *  <p/>
	 *  By default, the flag is true to keep original behavior. You could set it to false if you want the actual selected
	 *  row index be kept while you navigate back to the previous page.
	 * 
	 *  @param selectViewIndex the flag
	 */
	public void setSelectViewIndex(boolean selectViewIndex) {
	}

	/**
	 *  Navigates to the first page.
	 */
	public void firstPage() {
	}

	/**
	 *  Navigates to the last page.
	 */
	public void lastPage() {
	}

	/**
	 *  Gets the page size to change the current record while previous or next page is requested.
	 * 
	 *  @return the page size.
	 */
	protected int getPageSize() {
	}

	/**
	 *  Navigates to the previous page.
	 */
	public void previousPage() {
	}

	/**
	 *  Navigates to the next page.
	 */
	public void nextPage() {
	}

	/**
	 *  Navigates to the first record/row.
	 */
	public void firstRecord() {
	}

	/**
	 *  Navigates to the last record/row.
	 */
	public void lastRecord() {
	}

	/**
	 *  Navigates to the first record/row in the current page.
	 */
	public void firstRecordInPage() {
	}

	/**
	 *  Navigates to the last record/row in the current page.
	 */
	public void lastRecordInPage() {
	}

	/**
	 *  Navigates to the previous record/row, changes the current page if necessary.
	 */
	public void previousRecord() {
	}

	/**
	 *  Navigates to the next record/row, changes the current page if necessary.
	 */
	public void nextRecord() {
	}

	/**
	 *  Navigates to the page as shown in the PageNavigationField.
	 */
	protected void gotoPage() {
	}

	/**
	 *  Navigates to the record/row as shown in the PageNavigationField.
	 */
	protected void gotoRecord() {
	}

	/**
	 *  Gets the record/row count in the current page.
	 * 
	 *  @return the record/row count in the current page.
	 */
	protected int getRecordCountInPage() {
	}

	/**
	 *  Gets the selected record/row index.
	 * 
	 *  @return the selected record/row index.
	 */
	protected int getSelectedRecordIndex() {
	}

	/**
	 *  Sets the selected record/row.
	 * 
	 *  @param row the new selected record/row index.
	 */
	protected void setSelectedRecordIndex(int row) {
	}

	/**
	 *  Navigates to the specified page. It will beep if the page is invalid.
	 * 
	 *  @param page the new page index.
	 */
	public void gotoPage(int page) {
	}

	protected void changeCurrentPage(int newPageIndex) {
	}

	/**
	 *  Navigates to the specified record/row. It will beep if the record/row is invalid.
	 * 
	 *  @param record the new record/row index.
	 *  @return the actual record number that goes to.
	 */
	public int gotoRecord(int record) {
	}

	/**
	 *  Navigates to and select the specified record/row. It will beep if the record/row is invalid.
	 * 
	 *  @param record the new record/row index.
	 *  @since 3.4.1
	 */
	public void selectRecord(int record) {
	}

	protected void notifyUser() {
	}

	protected void updateButtonPanel() {
	}

	/**
	 *  Checks if right now it's the last possible page.
	 * 
	 *  @return true if current page is the last page. Otherwise false.
	 */
	protected boolean isAtLastPage() {
	}

	/**
	 *  Checks if right now it's the first possible page.
	 * 
	 *  @return true if current page is the first page. Otherwise false.
	 */
	protected boolean isAtFirstPage() {
	}

	@java.lang.Override
	public void setEnabled(boolean enabled) {
	}

	/**
	 *  Sets the button visible or invisible.
	 * 
	 *  @param command the name defined in DualList. They are constants starting with "COMMAND_" such as COMMAND_FIRST.
	 *  @param visible true to show the button and false to hide.
	 */
	public void setButtonVisible(String command, boolean visible) {
	}

	/**
	 *  Checks if the button is visible.
	 * 
	 *  @param command the name defined in DualList. They are constants starting with "COMMAND_" such as COMMAND_FIRST.
	 * 
	 *  @return true or false.
	 */
	public boolean isButtonVisible(String command) {
	}

	/**
	 *  Sets the button to always disabled.
	 * 
	 *  @param command the name defined in DualList. They are constants starting with "COMMAND_" such as COMMAND_FIRST.
	 *  @param enabled false to always disable the button.
	 */
	public void setButtonEnabled(String command, boolean enabled) {
	}

	/**
	 *  Checks if the button is always disabled.
	 * 
	 *  @param command the name defined in DualList. They are constants starting with "COMMAND_" such as COMMAND_FIRST.
	 * 
	 *  @return false if the button is always disabled. Otherwise true. Note that this method still could return true
	 *          when the button isEnabled() return false.
	 */
	public boolean isButtonEnabled(String command) {
	}

	/**
	 *  Gets the PageNavigationSupport used by this PageNavigationBar.
	 * 
	 *  @return the PageNavigationSupport used by this PageNavigationBar.
	 */
	public PageNavigationSupport getPageNavigationSupport() {
	}
}
