/**
 *  The package contains classes related for paging and page navigation support for JIDE Data Grids product.
 */
package com.jidesoft.paging;


/**
 *  An <code>EventObject</code> that adds support for <code>PageTableModel</code> objects as the event source.
 */
public class PageNavigationEvent extends java.util.EventObject {

	/**
	 *  The first number in the range of IDs used for <code>AbstractPage</code> events.
	 */
	public static final int PAGE_NAVIGATION_EVENT_FIRST = 14099;

	/**
	 *  The last number in the range of IDs used for <code>AbstractPage</code> events.
	 */
	public static final int PAGE_NAVIGATION_EVENT_LAST = 14101;

	/**
	 *  This event is delivered when total page count changes
	 */
	public static final int PAGE_COUNT_CHANGED = 14099;

	/**
	 *  This event is delivered when the page size changes.
	 */
	public static final int PAGE_SIZE_CHANGED = 14100;

	/**
	 *  This event is delivered when the page index changes.
	 */
	public static final int CURRENT_PAGE_CHANGED = 14101;

	/**
	 *  Constructs an <code>AbstractPageEvent</code> object.
	 * 
	 *  @param source   the <code>AbstractPage</code> object that originated the event
	 *  @param id       an integer indicating the type of event
	 *  @param oldValue the old value associated with this event.
	 *  @param newValue the new value associated with this event.
	 */
	public PageNavigationEvent(Object source, int id, int oldValue, int newValue) {
	}

	/**
	 *  Returns the event type.
	 * 
	 *  @return event id.
	 */
	public int getID() {
	}

	/**
	 *  Gets the old value associated with this event.
	 * 
	 *  @return the old value associated with this event.
	 */
	public int getOldValue() {
	}

	/**
	 *  Gets the new value associated with this event.
	 * 
	 *  @return the new value associated with this event.
	 */
	public int getNewValue() {
	}

	/**
	 *  Returns a parameter string identifying this event. This method is useful for event logging and for debugging.
	 * 
	 *  @return a string identifying the event and its attributes
	 */
	public String paramString() {
	}

	@java.lang.Override
	public String toString() {
	}
}
