package com.jidesoft.grid;


/**
 *  The interface is to define a column that is calculated from other columns of a table model.
 */
public interface CalculatedColumn {

	/**
	 *  Gets the actual table model. Since this is calculated column, it is calculated from an existing column or
	 *  existing columns in the actual table model.
	 * 
	 *  @return the actual table model.
	 */
	public javax.swing.table.TableModel getActualModel();

	/**
	 *  Gets the column name. The column name is displayed on the table column header.
	 * 
	 *  @return the column name.
	 */
	public String getColumnName();

	/**
	 *  Gets the column identifier. The column identifier should be unique in a table model.
	 * 
	 *  @return the column identifier.
	 *  @since 3.5.5
	 */
	public Object getColumnIdentifier();

	/**
	 *  Gets the class of this column.
	 * 
	 *  @return the column class.
	 */
	public Class getColumnClass();

	/**
	 *  Gets the value at the cell of the row index.
	 * 
	 *  @param rowIndex
	 *  @return the cell value.
	 */
	public Object getValueAt(int rowIndex);

	/**
	 *  Gets the depending column index. The depending columns are those columns on which the value is calculated.
	 * 
	 *  @return the depending column index
	 */
	public int[] getDependingColumns();

	/**
	 *  Gets the class of a particular cell.
	 * 
	 *  @return the cell class.
	 */
	public Class getCellClass(int rowIndex);

	/**
	 *  Gets the converter context of a particular cell.
	 * 
	 *  @return the cell converter context.
	 */
	public ConverterContext getConverterContext(int rowIndex);

	/**
	 *  Gets the editor context of a particular cell.
	 * 
	 *  @return the cell editor context.
	 */
	public EditorContext getEditorContext(int rowIndex);
}
