package com.jidesoft.grid;


/**
 *  <code>CsvPivotTableUtils</code> is a class that has methods to export PivotTablePane's content to Character Separated
 *  Values file format.
 *  <p/>
 *  The export feature will not consider the cell contents conversion but you can use ValueConverter to format the value
 *  if you want. It will also optionally consider table header as part of the export. You could also choose any character
 *  including comma as the separator.
 *  <p/>
 *  It does NOT support cell span and will LOSE the collapsed rows/columns because of the CSV format limitation.
 */
public class CsvPivotTableUtils {

	public CsvPivotTableUtils() {
	}

	/**
	 *  Exports the pivotTablePane to an CSV file.
	 * 
	 *  @param pivotTablePane the pivotTablePane to be exported.
	 *  @param fileName       the CSV file name. It should be the full path to the file.
	 *  @return true if exporting succeed. If poi.jar is not in the classpath, false will be returned. Exception will be
	 *  thrown if there is error during the exporting.
	 *  @throws java.io.IOException           if the write to the file failed.
	 *  @throws java.io.FileNotFoundException if the file exists but is a directory rather than a regular file, does not
	 *                                        exist but cannot be created, or cannot be opened for any other reason
	 */
	public static boolean export(com.jidesoft.pivot.PivotTablePane pivotTablePane, String fileName) {
	}

	/**
	 *  Exports the pivotTablePane to an CSV file.
	 * 
	 *  @param pivotTablePane     the pivotTablePane to be exported.
	 *  @param fileName           the CSV file name. It should be the full path to the file.
	 *  @param cellValueConverter the converter to convert cell value to the value that can be set to CSV cell.
	 *  @return true if exporting succeed. If poi.jar is not in the classpath, false will be returned. Exception will be
	 *  thrown if there is error during the exporting.
	 *  @throws java.io.IOException           if the write to the file failed.
	 *  @throws java.io.FileNotFoundException if the file exists but is a directory rather than a regular file, does not
	 *                                        exist but cannot be created, or cannot be opened for any other reason
	 */
	public static boolean export(com.jidesoft.pivot.PivotTablePane pivotTablePane, String fileName, ValueConverter cellValueConverter) {
	}

	/**
	 *  Exports the pivotTablePane to an CSV file.
	 * 
	 *  @param pivotTablePane     the pivotTablePane to be exported.
	 *  @param fileName           the CSV file name. It should be the full path to the file.
	 *  @param cellValueConverter the converter to convert cell value to the value that can be set to CSV cell.
	 *  @param separator          the character used to separate the cells. By default, it is a comma.
	 *  @return true if exporting succeed. If poi.jar is not in the classpath, false will be returned. Exception will be
	 *  thrown if there is error during the exporting.
	 *  @throws java.io.IOException           if the write to the file failed.
	 *  @throws java.io.FileNotFoundException if the file exists but is a directory rather than a regular file, does not
	 *                                        exist but cannot be created, or cannot be opened for any other reason
	 */
	public static boolean export(com.jidesoft.pivot.PivotTablePane pivotTablePane, String fileName, ValueConverter cellValueConverter, char separator) {
	}

	/**
	 *  Exports the pivotTablePane to a CSV file output steam.
	 * 
	 *  @param pivotTablePane the pivotTablePane to be exported.
	 *  @param out            the output stream
	 *  @return true if exporting succeed. If poi.jar is not in the classpath, false will be returned. Exception will be
	 *  thrown if there is error during the exporting.
	 *  @throws java.io.IOException           if the write to the file failed.
	 *  @throws java.io.FileNotFoundException if the file exists but is a directory rather than a regular file, does not
	 *                                        exist but cannot be created, or cannot be opened for any other reason
	 */
	public static boolean export(com.jidesoft.pivot.PivotTablePane pivotTablePane, java.io.OutputStream out) {
	}

	/**
	 *  Exports the pivotTablePane to a CSV file output steam.
	 * 
	 *  @param pivotTablePane     the pivotTablePane to be exported.
	 *  @param out                the output stream
	 *  @param cellValueConverter the converter to convert cell value to the value that can be set to CSV cell.
	 *  @return true if exporting succeed. If poi.jar is not in the classpath, false will be returned. Exception will be
	 *  thrown if there is error during the exporting.
	 *  @throws java.io.IOException           if the write to the file failed.
	 *  @throws java.io.FileNotFoundException if the file exists but is a directory rather than a regular file, does not
	 *                                        exist but cannot be created, or cannot be opened for any other reason
	 */
	public static boolean export(com.jidesoft.pivot.PivotTablePane pivotTablePane, java.io.OutputStream out, ValueConverter cellValueConverter) {
	}

	/**
	 *  Exports the pivotTablePane to a CSV file output steam.
	 * 
	 *  @param pivotTablePane     the pivotTablePane to be exported.
	 *  @param out                the output stream
	 *  @param cellValueConverter the converter to convert cell value to the value that can be set to CSV cell.
	 *  @param separator          the character used to separate the cells. By default, it is a comma.
	 *  @return true if exporting succeed. If poi.jar is not in the classpath, false will be returned. Exception will be
	 *  thrown if there is error during the exporting.
	 *  @throws java.io.IOException           if the write to the file failed.
	 *  @throws java.io.FileNotFoundException if the file exists but is a directory rather than a regular file, does not
	 *                                        exist but cannot be created, or cannot be opened for any other reason
	 */
	public static boolean export(com.jidesoft.pivot.PivotTablePane pivotTablePane, java.io.OutputStream out, ValueConverter cellValueConverter, char separator) {
	}

	/**
	 *  A class that has all the parameters that could be customized when exporting a PivotTablePane to csv file.
	 * 
	 *  @since 3.3.8
	 */
	public static class CsvPivotTableExportConfig {


		/**
		 *  The constructor.
		 */
		public CsvPivotTableUtils.CsvPivotTableExportConfig() {
		}

		/**
		 *  Gets the cell value converter.
		 * 
		 *  @return the cell value converter.
		 */
		public ValueConverter getCellValueConverter() {
		}

		/**
		 *  Sets the cell value converter.
		 * 
		 *  @param cellValueConverter the cell value converter
		 */
		public void setCellValueConverter(ValueConverter cellValueConverter) {
		}

		/**
		 *  Gets the separator to separate the cells.
		 * 
		 *  @return the separator. By default, it's a comma.
		 */
		public char getSeparator() {
		}

		/**
		 *  Sets the separator to separate the cells.
		 * 
		 *  @param separator the separator
		 */
		public void setSeparator(char separator) {
		}

		/**
		 *  Gets the charset name.
		 * 
		 *  @return the charset name.
		 */
		public String getCharsetName() {
		}

		/**
		 *  Sets the charset name.
		 * 
		 *  @param charsetName the charset name
		 */
		public void setCharsetName(String charsetName) {
		}
	}
}
