package com.jidesoft.grid;


/**
 *  <tt>ExpressionCalculatedColumn</tt> is a special <code>CalculatedColumn</code> that can accept a string as
 *  expression. For example, if your table model has a Quality column and an UnitPrice column, you can write an
 *  expression string like "[Quality] * [UnitPrice]" to calculate for this Sales column using
 *  <code>ExpressionCalculatedColumn</code>.
 *  <p/>
 *  For performance consideration, if you know the depending columns beforehand, it is better you call {@link
 *  #setDependingColumns(int[])} to set it. By doing this, the expression calculation method will not look at other
 *  columns.
 *  <p/>
 *  For details of the expression grammar, please refer to JIDE Pivot Grids Developer Guide "Expression For
 *  ExpressionCalculatedColumn" section.
 *  <p/>
 *  For ExpressionCalculatedColumn, we have to get some related information from the depending columns.
 *  So please make sure the table model you passed in as a parameter has the information of the depending columns.
 */
public class ExpressionCalculatedColumn extends AbstractCalculatedColumn {

	public java.util.List _dependingColumnNames;

	public ExpressionCalculatedColumn(javax.swing.table.TableModel model, String expressionString) {
	}

	public ExpressionCalculatedColumn(javax.swing.table.TableModel model, String newColumnName, String expressionString) {
	}

	/**
	 *  Gets the expression string.
	 * 
	 *  @return the expression string.
	 */
	public String getExpressionString() {
	}

	/**
	 *  Sets the expression string. Please refer to JIDE Pivot Grid Developer Guide "Expression For
	 *  ExpressionCalculatedColumn" section for more information.
	 * 
	 *  @param expressionString the new expression string.
	 *  @throws IllegalArgumentException if the expressionString is not a valid expression.
	 */
	public void setExpressionString(String expressionString) {
	}

	public Object getValueAt(int rowIndex) {
	}

	/**
	 *  Sets the depending columns. When you write an expression, it will usually refer to one or several columns in the
	 *  table model. By referring to those columns, it means the value of this column will depend on the value of those
	 *  columns. When the value of those columns change, we should recalculate the value of this column. By specifying
	 *  the depending columns, we will automate this recalculation process.
	 *  <p/>
	 *  Please note, you don't have to set the depending columns. If you don't, we will automatically find out based on
	 *  the expression. If you set, we will use the depending columns you set.
	 * 
	 *  @param columns the column int array that this column's expression is referring to.
	 */
	public void setDependingColumns(int[] columns) {
	}

	/**
	 *  Gets the depending columns.
	 * 
	 *  @return the depending columns. Default is an empty int array.
	 */
	public int[] getDependingColumns() {
	}
}
