package com.jidesoft.grid;


/**
 *  A direct mapping from a single existing column of a table model. It can be used with CalculatedTableModel to create a
 *  completely new table model based on the original table model. The SingleColumn can be created based on the column
 *  index or the column name (the first one in case there are duplicated column names) as in the original table model. By
 *  default it will gets the same column name and the same column class. However you can define a new column name and a
 *  new column class. If the actual model is a ContextSensitiveTableModel, the SingleColumn will automatically find the
 *  ConverterContext and EditorContext defined in the ContextSensitiveTableModel and set them.
 */
public class SingleColumn extends AbstractCalculatedColumn {

	public SingleColumn(javax.swing.table.TableModel model, int columnIndex) {
	}

	public SingleColumn(javax.swing.table.TableModel model, String columnName) {
	}

	public SingleColumn(javax.swing.table.TableModel model, String columnName, String newColumnName) {
	}

	public SingleColumn(javax.swing.table.TableModel model, int columnIndex, String newColumnName) {
	}

	public SingleColumn(javax.swing.table.TableModel model, int columnIndex, String newColumnName, Class columnClass) {
	}

	public SingleColumn(javax.swing.table.TableModel model, String columnName, String newColumnName, Class columnClass) {
	}

	public SingleColumn(javax.swing.table.TableModel model, int columnIndex, ObjectGrouper objectGrouper) {
	}

	public SingleColumn(javax.swing.table.TableModel model, int columnIndex, String newColumnName, ObjectGrouper objectGrouper) {
	}

	public SingleColumn(javax.swing.table.TableModel model, String columnName, ObjectGrouper objectGrouper) {
	}

	public SingleColumn(javax.swing.table.TableModel model, String columnName, String newColumnName, ObjectGrouper objectGrouper) {
	}

	/**
	 *  Gets the column index as in the actual table model.
	 * 
	 *  @return the column index as in the actual table model.
	 */
	public int getColumnIndex() {
	}

	/**
	 *  Sets the column index as in the actual table model. This method will update the column name, column class,
	 *  converter context and editor context.
	 * 
	 *  @param columnIndex the column index as in the actual table model.
	 */
	public void setColumnIndex(int columnIndex) {
	}

	@java.lang.Override
	public void setObjectGrouper(ObjectGrouper objectGrouper) {
	}

	/**
	 *  Gets the value at the specified row index.
	 * 
	 *  @param rowIndex the row index.
	 *  @return the value at the specified row index.
	 */
	public Object getValueAt(int rowIndex) {
	}

	/**
	 *  Sets the value at the specified row index.
	 * 
	 *  @param value    a new value at the specified row index.
	 *  @param rowIndex the row index.
	 */
	public void setValueAt(Object value, int rowIndex) {
	}

	/**
	 *  Checks if the cell is editable at the specified row index. If getObjectGrouper() is not null, this method will
	 *  return false as there is usually no way to edit a grouped value (because grouping is one direction). Otherwise,
	 *  it will return the value from the actual model's isCellEditable method.
	 * 
	 *  @param rowIndex the row index.
	 *  @return true if the cell is editable. Otherwise false.
	 */
	public boolean isCellEditable(int rowIndex) {
	}

	/**
	 *  Gets the depending column index. By default, it will be getColumnIndex().
	 * 
	 *  @return the depending column index.
	 */
	public int[] getDependingColumns() {
	}

	@java.lang.Override
	public Class getCellClass(int rowIndex) {
	}

	@java.lang.Override
	public ConverterContext getConverterContext(int rowIndex) {
	}

	@java.lang.Override
	public EditorContext getEditorContext(int rowIndex) {
	}
}
