package com.jidesoft.hssf;


/**
 *  <code>HssfAggregateTableUtils</code> is a class that has methods to export any AggregateTable's content to Excel file
 *  format using POI. You can find more information about POI at http://poi.apache.org/spreadsheet/index.html.
 *  <p/>
 *  The export feature will not consider the cell contents conversion but you can use CellValueConverter to format the
 *  value if you want. It also supports cell span if the table model is SpanModel. It will also optionally consider table
 *  header as part of the export. Cell style is also supported as far as the Excel format allows.
 *  <p/>
 *  Please set the client property {@link HssfTableUtils#CLIENT_PROPERTY_EXCEL_OUTPUT_FORMAT} for the target
 *  AggregateTable before you invoke this method so that you can choose the output format. If you didn't set the client
 *  property, we will use office2003 format for backward compatibility concern.
 *  @deprecated replaced by {@link com.jidesoft.hssf.HssfTableUtils}
 */
@java.lang.Deprecated
public class HssfAggregateTableUtils {

	public HssfAggregateTableUtils() {
	}

	/**
	 *  Check if poi.jar is in the classpath. All <code>export</code> methods in this util called this method first
	 *  before continuing.
	 * 
	 *  @return true if poi.jar is in the classpath. Otherwise false.
	 */
	public static boolean isHssfInstalled() {
	}

	/**
	 *  Exports the AggregateTable to an Excel file.
	 * 
	 *  @param table     the AggregateTable to be exported.
	 *  @param fileName  the Excel file name. It should be the full path to the file.
	 *  @param sheetName the worksheet name.
	 *  @param append    whether it appends to the existing Excel file or it creates a new Excel file.
	 *  @return true if exporting succeed. If poi.jar is not in the classpath, false will be returned. Exception will be
	 *          thrown if there is error during the exporting.
	 * 
	 *  @throws IOException                   if the write to the file failed.
	 *  @throws java.io.FileNotFoundException if the file exists but is a directory rather than a regular file, does not
	 *                                        exist but cannot be created, or cannot be opened for any other reason
	 */
	public static boolean export(com.jidesoft.pivot.AggregateTable table, String fileName, String sheetName, boolean append) {
	}

	/**
	 *  Exports the AggregateTable to an Excel file.
	 * 
	 *  @param table              the AggregateTable to be exported.
	 *  @param fileName           the Excel file name. It should be the full path to the file.
	 *  @param sheetName          the worksheet name.
	 *  @param append             whether it appends to the existing Excel file or it creates a new Excel file.
	 *  @param includeTableHeader whether to include the table header.
	 *  @return true if exporting succeed. If poi.jar is not in the classpath, false will be returned. Exception will be
	 *          thrown if there is error during the exporting.
	 * 
	 *  @throws IOException                   if the write to the file failed.
	 *  @throws java.io.FileNotFoundException if the file exists but is a directory rather than a regular file, does not
	 *                                        exist but cannot be created, or cannot be opened for any other reason
	 */
	public static boolean export(com.jidesoft.pivot.AggregateTable table, String fileName, String sheetName, boolean append, boolean includeTableHeader) {
	}

	/**
	 *  Exports the AggregateTable to an Excel file.
	 * 
	 *  @param table              the AggregateTable to be exported.
	 *  @param fileName           the Excel file name. It should be the full path to the file.
	 *  @param sheetName          the worksheet name.
	 *  @param append             whether it appends to the existing Excel file or it creates a new Excel file.
	 *  @param includeTableHeader whether to include the table header.
	 *  @param converter          the converter to convert cell value to the value that can be set to Excel cell.
	 *  @return true if exporting succeed. If poi.jar is not in the classpath, false will be returned. Exception will be
	 *          thrown if there is error during the exporting.
	 * 
	 *  @throws IOException                   if the write to the file failed.
	 *  @throws java.io.FileNotFoundException if the file exists but is a directory rather than a regular file, does not
	 *                                        exist but cannot be created, or cannot be opened for any other reason
	 */
	public static boolean export(com.jidesoft.pivot.AggregateTable table, String fileName, String sheetName, boolean append, boolean includeTableHeader, HssfTableUtils.CellValueConverter converter) {
	}

	/**
	 *  Exports the AggregateTable to an Excel file.
	 * 
	 *  @param table              the AggregateTable to be exported.
	 *  @param firstRow           the first row to be exported
	 *  @param firstColumn        the first row to be exported
	 *  @param numberOfRows       number of rows to be exported, -1 means all rows.
	 *  @param numberOfColumns    number of columns to be exported. -1 means all columns.
	 *  @param fileName           the Excel file name. It should be the full path to the file.
	 *  @param sheetName          the worksheet name.
	 *  @param append             whether it appends to the existing Excel file or it creates a new Excel file.
	 *  @param includeTableHeader whether to include the table header.
	 *  @param converter          the converter to convert cell value to the value that can be set to Excel cell.
	 *  @return true if exporting succeed. If poi.jar is not in the classpath, false will be returned. Exception will be
	 *          thrown if there is error during the exporting.
	 * 
	 *  @throws IOException                   if the write to the file failed.
	 *  @throws java.io.FileNotFoundException if the file exists but is a directory rather than a regular file, does not
	 *                                        exist but cannot be created, or cannot be opened for any other reason
	 */
	public static boolean export(com.jidesoft.pivot.AggregateTable table, int firstRow, int firstColumn, int numberOfRows, int numberOfColumns, String fileName, String sheetName, boolean append, boolean includeTableHeader, HssfTableUtils.CellValueConverter converter) {
	}

	/**
	 *  Exports the AggregateTable to as Excel file output steam.
	 * 
	 *  @param table     the AggregateTable to be exported.
	 *  @param out       the output stream
	 *  @param sheetName the worksheet name.
	 *  @return true if exporting succeed. If poi.jar is not in the classpath, false will be returned. Exception will be
	 *          thrown if there is error during the exporting.
	 * 
	 *  @throws IOException                   if the write to the file failed.
	 *  @throws java.io.FileNotFoundException if the file exists but is a directory rather than a regular file, does not
	 *                                        exist but cannot be created, or cannot be opened for any other reason
	 */
	public static boolean export(com.jidesoft.pivot.AggregateTable table, java.io.OutputStream out, String sheetName) {
	}

	/**
	 *  Exports the AggregateTable to as Excel file output steam.
	 * 
	 *  @param table              the AggregateTable to be exported.
	 *  @param out                the output stream
	 *  @param sheetName          the worksheet name.
	 *  @param includeTableHeader whether to include the table header.
	 *  @return true if exporting succeed. If poi.jar is not in the classpath, false will be returned. Exception will be
	 *          thrown if there is error during the exporting.
	 * 
	 *  @throws IOException                   if the write to the file failed.
	 *  @throws java.io.FileNotFoundException if the file exists but is a directory rather than a regular file, does not
	 *                                        exist but cannot be created, or cannot be opened for any other reason
	 */
	public static boolean export(com.jidesoft.pivot.AggregateTable table, java.io.OutputStream out, String sheetName, boolean includeTableHeader) {
	}

	/**
	 *  Exports the AggregateTable to as Excel file output steam.
	 * 
	 *  @param table              the AggregateTable to be exported.
	 *  @param out                the output stream
	 *  @param sheetName          the worksheet name.
	 *  @param includeTableHeader whether to include the table header.
	 *  @param converter          the converter to convert cell value to the value that can be set to Excel cell.
	 *  @return true if exporting succeed. If poi.jar is not in the classpath, false will be returned. Exception will be
	 *          thrown if there is error during the exporting.
	 * 
	 *  @throws IOException                   if the write to the file failed.
	 *  @throws java.io.FileNotFoundException if the file exists but is a directory rather than a regular file, does not
	 *                                        exist but cannot be created, or cannot be opened for any other reason
	 */
	public static boolean export(com.jidesoft.pivot.AggregateTable table, java.io.OutputStream out, String sheetName, boolean includeTableHeader, HssfTableUtils.CellValueConverter converter) {
	}

	/**
	 *  Exports the AggregateTable to as Excel file output steam.
	 * 
	 *  @param table              the AggregateTable to be exported.
	 *  @param out                the output stream
	 *  @param firstRow           the first row to be exported
	 *  @param firstColumn        the first row to be exported
	 *  @param numberOfRows       number of rows to be exported, -1 means all rows.
	 *  @param numberOfColumns    number of columns to be exported. -1 means all columns.
	 *  @param sheetName          the worksheet name.
	 *  @param includeTableHeader whether to include the table header.
	 *  @param cellValueConverter the converter to convert cell value to the value that can be set to Excel cell.
	 *  @return true if exporting succeed. If poi.jar is not in the classpath, false will be returned. Exception will be
	 *          thrown if there is error during the exporting.
	 * 
	 *  @throws IOException                   if the write to the file failed.
	 *  @throws java.io.FileNotFoundException if the file exists but is a directory rather than a regular file, does not
	 *                                        exist but cannot be created, or cannot be opened for any other reason
	 */
	public static boolean export(com.jidesoft.pivot.AggregateTable table, java.io.OutputStream out, int firstRow, int firstColumn, int numberOfRows, int numberOfColumns, String sheetName, boolean includeTableHeader, HssfTableUtils.CellValueConverter cellValueConverter) {
	}

	/**
	 *  Exports the AggregateTable to as Excel file output steam.
	 * 
	 *  @param table               the AggregateTable to be exported.
	 *  @param out                 the output stream
	 *  @param firstRow            the first row to be exported
	 *  @param firstColumn         the first row to be exported
	 *  @param numberOfRows        number of rows to be exported, -1 means all rows.
	 *  @param numberOfColumns     number of columns to be exported. -1 means all columns.
	 *  @param sheetName           the worksheet name.
	 *  @param includeTableHeader  whether to include the table header.
	 *  @param cellValueConverter  the converter to convert cell value to the value that can be set to Excel cell.
	 *  @param columnNameConverter the converter to convert the column name.
	 *  @return true if exporting succeed. If poi.jar is not in the classpath, false will be returned. Exception will be
	 *          thrown if there is error during the exporting.
	 * 
	 *  @throws IOException                   if the write to the file failed.
	 *  @throws java.io.FileNotFoundException if the file exists but is a directory rather than a regular file, does not
	 *                                        exist but cannot be created, or cannot be opened for any other reason
	 */
	public static boolean export(com.jidesoft.pivot.AggregateTable table, java.io.OutputStream out, int firstRow, int firstColumn, int numberOfRows, int numberOfColumns, String sheetName, boolean includeTableHeader, HssfTableUtils.CellValueConverter cellValueConverter, StringConverter columnNameConverter) {
	}

	/**
	 *  Exports the AggregateTable to the specified location of an Excel sheet.
	 * 
	 *  @param table       the AggregateTable to be exported.
	 *  @param wb          the Workbook
	 *  @param sheet       the worksheet
	 *  @param startRow    the starting row. The first cell of the table will appear at this row index.
	 *  @param startColumn the starting column. The first cell of the table will appear at this row index.
	 */
	public static void exportToSheet(com.jidesoft.pivot.AggregateTable table, Workbook wb, Sheet sheet, int startRow, int startColumn) {
	}

	/**
	 *  Exports the AggregateTable to the specified location of an Excel sheet.
	 * 
	 *  @param table       the AggregateTable to be exported.
	 *  @param wb          the Workbook
	 *  @param sheet       the worksheet
	 *  @param startRow    the starting row. The first cell of the table will appear at this row index.
	 *  @param startColumn the starting column. The first cell of the table will appear at this row index.
	 *  @param converter   the converter to convert cell value to the value that can be set to Excel cell.
	 */
	public static void exportToSheet(com.jidesoft.pivot.AggregateTable table, Workbook wb, Sheet sheet, int startRow, int startColumn, HssfTableUtils.CellValueConverter converter) {
	}

	/**
	 *  Exports the AggregateTable to the specified location of an Excel sheet.
	 * 
	 *  @param table              the AggregateTable to be exported.
	 *  @param wb                 the Workbook
	 *  @param sheet              the worksheet
	 *  @param startRow           the starting row. The first cell of the table will appear at this row index.
	 *  @param startColumn        the starting column. The first cell of the table will appear at this row index.
	 *  @param includeTableHeader whether to include the table header.
	 */
	public static void exportToSheet(com.jidesoft.pivot.AggregateTable table, Workbook wb, Sheet sheet, int startRow, int startColumn, boolean includeTableHeader) {
	}

	/**
	 *  Exports the AggregateTable to the specified location of an Excel sheet.
	 * 
	 *  @param table              the AggregateTable to be exported.
	 *  @param wb                 the Workbook
	 *  @param sheet              the worksheet
	 *  @param startRow           the starting row. The first cell of the table will appear at this row index.
	 *  @param startColumn        the starting column. The first cell of the table will appear at this row index.
	 *  @param includeTableHeader whether to include the table header.
	 *  @param converter          the converter to convert cell value to the value that can be set to Excel cell.
	 */
	public static void exportToSheet(com.jidesoft.pivot.AggregateTable table, Workbook wb, Sheet sheet, int startRow, int startColumn, boolean includeTableHeader, HssfTableUtils.CellValueConverter converter) {
	}

	/**
	 *  Exports the AggregateTable to the specified location of an Excel sheet.
	 * 
	 *  @param table               the AggregateTable to be exported.
	 *  @param wb                  the Workbook
	 *  @param sheet               the worksheet
	 *  @param startRow            the starting row. The first cell of the table will appear at this row index.
	 *  @param startColumn         the starting column. The first cell of the table will appear at this row index.
	 *  @param includeTableHeader  whether to include the table header.
	 *  @param converter           the converter to convert cell value to the value that can be set to Excel cell.
	 *  @param columnNameConverter the converter to convert the column name.
	 */
	public static void exportToSheet(com.jidesoft.pivot.AggregateTable table, Workbook wb, Sheet sheet, int startRow, int startColumn, boolean includeTableHeader, HssfTableUtils.CellValueConverter converter, StringConverter columnNameConverter) {
	}

	/**
	 *  Exports the AggregateTable to the specified location of an Excel sheet.
	 * 
	 *  @param table              the AggregateTable to be exported.
	 *  @param firstRow           the first row to be exported
	 *  @param firstColumn        the first row to be exported
	 *  @param numberOfRows       number of rows to be exported, -1 means all rows.
	 *  @param numberOfColumns    number of columns to be exported. -1 means all columns.
	 *  @param wb                 the Workbook
	 *  @param sheet              the worksheet
	 *  @param startRow           the starting row. The first cell of the table will appear at this row index.
	 *  @param startColumn        the starting column. The first cell of the table will appear at this row index.
	 *  @param includeTableHeader whether to include the table header.
	 *  @param cellValueConverter the converter to convert cell value to the value that can be set to Excel cell.
	 */
	public static void exportToSheet(com.jidesoft.pivot.AggregateTable table, int firstRow, int firstColumn, int numberOfRows, int numberOfColumns, Workbook wb, Sheet sheet, int startRow, int startColumn, boolean includeTableHeader, HssfTableUtils.CellValueConverter cellValueConverter) {
	}

	/**
	 *  Exports the AggregateTable to the specified location of an Excel sheet.
	 * 
	 *  @param table               the AggregateTable to be exported.
	 *  @param firstRow            the first row to be exported
	 *  @param firstColumn         the first row to be exported
	 *  @param numberOfRows        number of rows to be exported, -1 means all rows.
	 *  @param numberOfColumns     number of columns to be exported. -1 means all columns.
	 *  @param wb                  the Workbook
	 *  @param sheet               the worksheet
	 *  @param startRow            the starting row. The first cell of the table will appear at this row index.
	 *  @param startColumn         the starting column. The first cell of the table will appear at this row index.
	 *  @param includeTableHeader  whether to include the table header.
	 *  @param cellValueConverter  the converter to convert cell value to the value that can be set to Excel cell.
	 *  @param columnNameConverter the converter to convert the column name.
	 */
	public static void exportToSheet(com.jidesoft.pivot.AggregateTable table, int firstRow, int firstColumn, int numberOfRows, int numberOfColumns, Workbook wb, Sheet sheet, int startRow, int startColumn, boolean includeTableHeader, HssfTableUtils.CellValueConverter cellValueConverter, StringConverter columnNameConverter) {
	}

	/**
	 *  Exports the AggregateTable to the specified location of an Excel sheet.
	 * 
	 *  @param table  the AggregateTable to be exported.
	 *  @param wb     the Workbook
	 *  @param sheet  the worksheet
	 *  @param format HssfTableFormat instance which stores every single information needed for exporting to sheet
	 */
	public static void exportToSheet(com.jidesoft.pivot.AggregateTable table, Workbook wb, Sheet sheet, HssfTableFormat format) {
	}

	/**
	 *  Exports a value to a particular cell in the sheet.
	 * 
	 *  @param sheet       the worksheet
	 *  @param rowIndex    the row index of the cell
	 *  @param columnIndex the column index of the cell
	 *  @param value       the value
	 */
	public static void exportToCell(Sheet sheet, int rowIndex, int columnIndex, Object value) {
	}
}
