package com.jidesoft.hssf;


/**
 *  <code>HssfPivotTableUtils</code> is a class that has methods to export PivotTablePane to Excel file format using POI
 *  and keep the pivot table layout.
 *  <p/>
 *  Please set the client property {@link #CLIENT_PROPERTY_EXCEL_OUTPUT_FORMAT} for the target PivotTablePane before you
 *  invoke this method so that you can choose the output format. If you didn't set the client property, we will use
 *  office2003 format for backward compatibility concern.
 */
public class HssfPivotTableUtils extends HssfTableUtils {

	public HssfPivotTableUtils() {
	}

	/**
	 *  Exports the pivot table to Excel file.
	 * 
	 *  @param pane      the <code>PivotTablePane</code>.
	 *  @param fileName  the Excel file name. It should be the full path to the file.
	 *  @param sheetName the worksheet name.
	 *  @param append    whether it appends to the existing Excel file or it creates a new Excel file.
	 *  @return true if exporting succeed. If poi.jar is not in the classpath, false will be returned. Exception will be
	 *          thrown if there is error during the exporting.
	 * 
	 *  @throws java.io.IOException if if an I/O error occurs when writing to the file.
	 */
	public static boolean export(com.jidesoft.pivot.PivotTablePane pane, String fileName, String sheetName, boolean append) {
	}

	/**
	 *  Exports the pivot table to Excel file.
	 * 
	 *  @param pane      the <code>PivotTablePane</code>.
	 *  @param fileName  the Excel file name. It should be the full path to the file.
	 *  @param sheetName the worksheet name.
	 *  @param append    whether it appends to the existing Excel file or it creates a new Excel file.
	 *  @param converter the converter to converts cell value to the value that can be set to Excel cell. Please note,
	 *                   this converter is only used to convert the cell in the data area, not any cells in row header or
	 *                   column header area.
	 *  @return true if exporting succeed. If poi.jar is not in the classpath, false will be returned. Exception will be
	 *          thrown if there is error during the exporting.
	 * 
	 *  @throws java.io.IOException if if an I/O error occurs when writing to the file.
	 */
	public static boolean export(com.jidesoft.pivot.PivotTablePane pane, String fileName, String sheetName, boolean append, CellValueConverter converter) {
	}

	/**
	 *  Exports the pivot table to Excel file.
	 * 
	 *  @param pane        the <code>PivotTablePane</code>.
	 *  @param fileName    the Excel file name. It should be the full path to the file.
	 *  @param sheetName   the worksheet name.
	 *  @param append      whether it appends to the existing Excel file or it creates a new Excel file.
	 *  @param converter   the converter to converts cell value to the value that can be set to Excel cell. Please note,
	 *                     this converter is only used to convert the cell in the data area, not any cells in row header
	 *                     or column header area.
	 *  @param freezePanes true to freeze the header areas. It means the header areas will stay when scroll horizontally
	 *                     and vertically.
	 *  @return true if exporting succeed. If poi.jar is not in the classpath, false will be returned. Exception will be
	 *          thrown if there is error during the exporting.
	 * 
	 *  @throws java.io.IOException if if an I/O error occurs when writing to the file.
	 */
	public static boolean export(com.jidesoft.pivot.PivotTablePane pane, String fileName, String sheetName, boolean append, CellValueConverter converter, boolean freezePanes) {
	}

	/**
	 *  Exports the pivot table to Excel file.
	 * 
	 *  @param pane      the <code>PivotTablePane</code>.
	 *  @param fileName  the Excel file name. It should be the full path to the file.
	 *  @param sheetName the worksheet name.
	 *  @param append    whether it appends to the existing Excel file or it creates a new Excel file.
	 *  @param format    HssfTableFormat instance which stores every single information needed for exporting to sheet.
	 *  @return true if exporting succeed. If poi.jar is not in the classpath, false will be returned. Exception will be
	 *          thrown if there is error during the exporting.
	 * 
	 *  @throws java.io.IOException if if an I/O error occurs when writing to the file.
	 */
	public static boolean export(com.jidesoft.pivot.PivotTablePane pane, String fileName, String sheetName, boolean append, HssfTableFormat format) {
	}

	/**
	 *  Exports the pivot table to Excel file as an output steam.
	 * 
	 *  @param pane      the <code>PivotTablePane</code>.
	 *  @param out       the output stream
	 *  @param sheetName the worksheet name.
	 *  @return true if exporting succeed. If poi.jar is not in the classpath, false will be returned. Exception will be
	 *          thrown if there is error during the exporting.
	 * 
	 *  @throws java.io.IOException if if an I/O error occurs when writing to the OutputStream.
	 */
	public static boolean export(com.jidesoft.pivot.PivotTablePane pane, java.io.OutputStream out, String sheetName) {
	}

	/**
	 *  Exports the pivot table to Excel file.
	 * 
	 *  @param pane      the <code>PivotTablePane</code>.
	 *  @param out       the output stream
	 *  @param sheetName the worksheet name.
	 *  @param converter the converter to converts cell value to the value that can be set to Excel cell.
	 *  @return true if exporting succeed. If poi.jar is not in the classpath, false will be returned. Exception will be
	 *          thrown if there is error during the exporting.
	 * 
	 *  @throws java.io.IOException if if an I/O error occurs when writing to the OutputStream.
	 */
	public static boolean export(com.jidesoft.pivot.PivotTablePane pane, java.io.OutputStream out, String sheetName, CellValueConverter converter) {
	}

	/**
	 *  Exports the pivot table to Excel file.
	 * 
	 *  @param pane        the <code>PivotTablePane</code>.
	 *  @param out         the output stream
	 *  @param sheetName   the worksheet name.
	 *  @param converter   the converter to converts cell value to the value that can be set to Excel cell.
	 *  @param freezePanes true to freeze the header areas. It means the header areas will stay when scroll horizontally
	 *                     and vertically.
	 *  @return true if exporting succeed. If poi.jar is not in the classpath, false will be returned. Exception will be
	 *          thrown if there is error during the exporting.
	 * 
	 *  @throws java.io.IOException if if an I/O error occurs when writing to the OutputStream.
	 */
	public static boolean export(com.jidesoft.pivot.PivotTablePane pane, java.io.OutputStream out, String sheetName, CellValueConverter converter, boolean freezePanes) {
	}

	/**
	 *  Export the PivotTablePane to a Workbook.
	 * 
	 *  @param wb        the Workbook instance
	 *  @param sheetName the sheet name
	 *  @param pane      the PivotTablePane to be exported
	 *  @param format    the format to define how the PivotTablePane should be exported
	 */
	@java.lang.SuppressWarnings("Since15")
	public static void exportToWorkbook(Workbook wb, String sheetName, com.jidesoft.pivot.PivotTablePane pane, HssfTableFormat format) {
	}
}
