/**
 *  The package contains classes for JIDE Pivot Grid product.
 */
package com.jidesoft.pivot;


/**
 *  <code>AggregateTable</code> provides a way to aggregate a table model with duplicated values using a TreeTable-like
 *  expandable cells and cell spans.
 *  <p/>
 *  If you have a very huge table and observe obvious performance issue while scrolling. You could use the following code
 *  to enhance the performance. Of course, you have to prepare for huge memory usage for the cache. That's why we didn't
 *  put it on JIDE jar.
 *  <code><pre>
 *          // After you create the AggregateTable instance, you can add a CachedTableModel wrapper to improve the
 *  performance.
 *          _aggregateTable.setModel(new CachedTableModel(_aggregateTable.getModel()));
 *  </pre></code>
 */
public class AggregateTable extends SortableTable {

	public static final String PROPERTY_DOUBLE_CLICK_ENABLED = "doubleClickEnabled";

	/**
	 *  Creates an empty AggregateTable.
	 */
	public AggregateTable() {
	}

	/**
	 *  Creates an AggregateTable. The model could be a regular TableModel. If so, after you create the table, you need
	 *  to call aggregate() method to aggregate certain columns. You can also pass in an aggregated
	 *  <code>AggregateTableModel</code>. If so, you of course don't need to call aggregate() method.
	 * 
	 *  @param model the table model.
	 */
	public AggregateTable(javax.swing.table.TableModel model) {
	}

	@java.lang.Override
	protected ISortableTableModel createSortableTableModel(javax.swing.table.TableModel model) {
	}

	@java.lang.Override
	public void setModel(javax.swing.table.TableModel model) {
	}

	@java.lang.Override
	public void tableChanged(javax.swing.event.TableModelEvent e) {
	}

	@java.lang.Override
	protected void tableStructureChanged(javax.swing.event.TableModelEvent e) {
	}

	/**
	 *  Gets the <code>AggregateTableModel</code> for this table.
	 * 
	 *  @return the <code>AggregateTableModel</code>.
	 */
	public AggregateTableModel getAggregateTableModel() {
	}

	@java.lang.Override
	public void updateUI() {
	}

	/**
	 *  Gets the TableHeader's tooltip for a particular model column index
	 * 
	 *  @param modelIndex the model column index.
	 *  @return the tooltip for the model column index where the mouse is over.
	 */
	@java.lang.Override
	public String getTableHeaderToolTipText(int modelIndex) {
	}

	/**
	 *  Creates the special cell renderer for the first column which paints +/- icon and tree line.
	 * 
	 *  @return an instance of TreeTableCellRenderer. The same instance will be used to paint the cell of all rows in
	 *          TreeTable.
	 */
	protected javax.swing.table.TableCellRenderer createCellRenderer() {
	}

	/**
	 *  Creates the mouse listener used to handle mouse click on +/- icon.
	 *  <p/>
	 *  Please override this method if you are NOT in JDK 1.6. Otherwise, please use {@link
	 *  #createExpandMouseInputListener(javax.swing.event.MouseInputListener)} instead.
	 * 
	 *  @return a mouse listener.
	 *  @see #createExpandMouseInputListener(javax.swing.event.MouseInputListener)
	 */
	protected java.awt.event.MouseListener createExpandMouseListener() {
	}

	/**
	 *  Gets the flag indicating if context menu should be displayed on right click.
	 * 
	 *  @return true if the context menu should be displayed. Otherwise false.
	 *  @see #setShowContextMenu(boolean)
	 *  @since 3.2.1
	 */
	public boolean isShowContextMenu() {
	}

	/**
	 *  Sets the flag indicating if context menu should be displayed on right click.
	 *  <p/>
	 *  By default, the flag is true. However, if you want to add an additional mouse listener to do something else, you
	 *  might have to set this flag to false to make your listener get mouse event correctly.
	 * 
	 *  @param showContextMenu the flag
	 *  @since 3.2.1
	 */
	public void setShowContextMenu(boolean showContextMenu) {
	}

	/**
	 *  Gets the flag indicating if the AggregateTable should use native renderer to paint its aggregated cells.
	 * 
	 *  @return true if native renderer should be used. Otherwise false.
	 *  @since 3.5.12
	 */
	public boolean isUseNativeRenderer() {
	}

	/**
	 *  Sets the flag indicating if the AggregateTable should use native renderer to paint its aggregated cells.
	 * 
	 *  @param useNativeRenderer the flag
	 *  @since 3.5.12
	 */
	public void setUseNativeRenderer(boolean useNativeRenderer) {
	}

	/**
	 *  Creates the mouse listener used to handle mouse click on +/- icon.
	 *  <p/>
	 *  Please override this method if you are in JDK 1.6. In other JDK releases, please use {@link
	 *  #createExpandMouseListener()} instead.
	 * 
	 *  @param listener old listener
	 *  @return a mouse listener.
	 *  @see #createExpandMouseListener()
	 */
	protected javax.swing.event.MouseInputListener createExpandMouseInputListener(javax.swing.event.MouseInputListener listener) {
	}

	/**
	 *  Handles the mouse event. It does two things. If single mouse clicks on the +/- icon will expand/collapse the
	 *  row.
	 * 
	 *  @param e the mouse event.
	 */
	protected void handleMouseEvent(java.awt.event.MouseEvent e) {
	}

	/**
	 *  Gets the popup menu customizer to customize the menu when user right click on the cells on aggregated column.
	 * 
	 *  @return the popup menu customizer.
	 */
	public AggregateTable.PopupMenuCustomizer getCellPopupMenuCustomizer() {
	}

	/**
	 *  Sets the popup menu customizer to customize the menu when user right click on the cells on aggregated column.
	 * 
	 *  @param popupMenuCustomizer a new PopupMenuCustomizer.
	 */
	public void setCellPopupMenuCustomizer(AggregateTable.PopupMenuCustomizer popupMenuCustomizer) {
	}

	/**
	 *  Expands the cell.
	 * 
	 *  @param rowIndex    the row index of the cell
	 *  @param columnIndex the column index of the cell
	 *  @since 3.3.0
	 */
	public void expand(int rowIndex, int columnIndex) {
	}

	/**
	 *  Collapses the cell.
	 * 
	 *  @param rowIndex    the row index of the cell
	 *  @param columnIndex the column index of the cell
	 *  @since 3.3.0
	 */
	public void collapse(int rowIndex, int columnIndex) {
	}

	/**
	 *  Expands all the cells.
	 */
	public void expandAll() {
	}

	/**
	 *  Collapses all the cells.
	 */
	public void collapseAll() {
	}

	/**
	 *  Creates the TableColumnModelListener used to handle column rearrangement.
	 * 
	 *  @return a TableColumnModelListener.
	 */
	protected AggregateTable.DraggingHandler createDraggingColumnPropertyChangeListener() {
	}

	protected void updateAggregateColumns(javax.swing.table.TableColumn draggingColumn, int originalColumnIndex) {
	}

	@java.lang.Override
	public javax.swing.table.TableCellRenderer getCellRenderer(int rowIndex, int columnIndex) {
	}

	public Expandable getExpandableAt(int rowIndex, int columnIndex) {
	}

	/**
	 *  This is an interface for HeaderTableCellRenderer so that it can find the correct HeaderTableModel.
	 * 
	 *  @return the HeaderTableModel.
	 */
	public HeaderTableModel getHeaderTableModel() {
	}

	/**
	 *  Sets the aggregated columns. Nothing is changed at this point until {@link #aggregate()} is called.
	 * 
	 *  @param columnNames the name of the columns to be aggregated.
	 */
	public void setAggregatedColumns(String[] columnNames) {
	}

	/**
	 *  Sets the aggregated columns. Nothing is changed at this point until {@link #aggregate()} is called.
	 * 
	 *  @param columns the index of the columns to be aggregated.
	 */
	public void setAggregatedColumns(int[] columns) {
	}

	/**
	 *  Aggregates the specified columns.
	 * 
	 *  @param columnNames the name of the columns that will be aggregated.
	 */
	public void aggregate(String[] columnNames) {
	}

	/**
	 *  Aggregates the specified columns.
	 * 
	 *  @param columns the index of the columns to be aggregated.
	 */
	public void aggregate(int[] columns) {
	}

	/**
	 *  Aggregates the table model. You should call {@link #setAggregatedColumns(String[])} or {@link
	 *  #setAggregatedColumns(int[])} before calling this method. Or you can combine the two calls into {@link
	 *  #aggregate(String[])} or {@link #aggregate(int[])}.
	 */
	public void aggregate() {
	}

	/**
	 *  Overrides so that clicking in the +/- icon area will not start editing the cell.
	 * 
	 *  @param row    the row to be edited
	 *  @param column the column to be edited
	 *  @param o      the event that starts the cell editing
	 *  @return false if for any reason the cell cannot be edited, or if the indices are invalid
	 */
	@java.lang.Override
	public boolean editCellAt(int row, int column, java.util.EventObject o) {
	}

	/**
	 *  Gets the grouping behavior when dragging columns.
	 *  <p/>
	 * 
	 *  @return the flag that if the dragging column will make the column grouped/ungrouped.
	 *  @see #setAutoAdjustGrouping(boolean)
	 */
	public boolean isAutoAdjustGrouping() {
	}

	/**
	 *  Sets the flag that controls the grouping behavior when dragging columns.
	 *  <p/>
	 *  If the flag is true,
	 *  <p/>
	 *  in the scenario that column A,B are grouping while column C,D,E are not grouped, move D before C will make D
	 *  grouped.
	 *  <p/>
	 *  in the scenario that column A,B are grouping while column C,D,E are not grouped, move A after B will make A
	 *  ungrouping.
	 *  <p/>
	 *  If the flag is false,
	 *  <p/>
	 *  in the scenario that column A,B are grouping while column C,D,E are not grouped, move D before C will keep D not
	 *  grouped.
	 *  <p/>
	 *  in the scenario that column A,B are grouping while column C,D,E are not grouped, move A after B will keep A
	 *  grouping.
	 *  <p/>
	 *  Before 2.6.0 release, the behavior is the same as the flag is true. However, after 2.6.0 release, the default
	 *  setting of this flag is false. So if you want to get exactly the same column dragging behavior as before release
	 *  2.6.0, please call the following code:
	 *  <code><pre>
	 *  setAutoAdjustGrouping(true);
	 *  setAutoGrouping(true);
	 *  </pre></code>
	 * 
	 *  @param autoAdjustGrouping the flag that if the dragging column will change its group/ungroup behavior while
	 *                            dragged to boundary
	 */
	public void setAutoAdjustGrouping(boolean autoAdjustGrouping) {
	}

	/**
	 *  Gets the flag if we should group the column if dragging the column to the very beginning of the table when there
	 *  is no grouping.
	 *  <p/>
	 * 
	 *  @return the flag if we should group the column if dragging the column to the very beginning of the table when
	 *          there is no grouping.
	 *  @see #setAutoGrouping(boolean)
	 */
	public boolean isAutoGrouping() {
	}

	/**
	 *  Sets the flag if we should group the column if dragging the column to the very beginning of the table when there
	 *  is no grouping.
	 *  <p/>
	 *  This flag will take effect only when {@link #isAutoAdjustGrouping()} returns true. If that method returns false,
	 *  this behavior looks like this flag is FALSE no matter what the value actually is.
	 *  <p/>
	 *  If the flag is true,
	 *  <p/>
	 *  in the scenario that column A,B,C,D,E are all not grouped, move E before A will make E grouped.
	 *  <p/>
	 *  If the flag is false,
	 *  <p/>
	 *  in the scenario that column A,B,C,D,E are all not grouped, move E before A will keep E ungrouping.
	 *  <p/>
	 *  Before 2.6.0 release, the behavior is the same as the flag is true. However, after 2.6.0 release, the default
	 *  setting of this flag is false. So if you want to get exactly the same column dragging behavior as before release
	 *  2.6.0, please call the following code:
	 *  <code><pre>
	 *  setAutoAdjustGrouping(true);
	 *  setAutoGrouping(true);
	 *  </pre></code>
	 *  <p/>
	 * 
	 *  @param autoGrouping the flag if we should group the column if dragging the column to the very beginning of the
	 *                      table when there is no grouping.
	 */
	public void setAutoGrouping(boolean autoGrouping) {
	}

	/**
	 *  Gets an optional version string.
	 * 
	 *  @return version string.
	 */
	public String getVersion() {
	}

	/**
	 *  Sets version string.
	 * 
	 *  @param version the version of the saved layout.
	 */
	public void setVersion(String version) {
	}

	/**
	 *  Checks if the +/- icon should visible for the node.
	 * 
	 *  @param node the node.
	 *  @return true or false.
	 */
	public boolean isExpandIconVisible(Node node) {
	}

	/**
	 *  Gets the resource string used in AggregateTable. Subclass can override it to provide their own strings.
	 * 
	 *  @param key the resource key
	 *  @return the localized string.
	 */
	public String getResourceString(String key) {
	}

	/**
	 *  Gets the string value with summary name or the total/grand total. For example, if the stringValue parameter is
	 *  "Aug", this method will return "Aug Sum" if the cell is a subtotal row/column of "Sum". If the cell is a grand
	 *  total row or column, this method will return "Grand Total" which is defined in pivot.properties.
	 * 
	 *  @param rowIndex    the row index of the cell
	 *  @param columnIndex the column index of the cell
	 *  @param converter   the cell value converter if applicable. null if you are not invoking this method for exporting
	 *                     to excel purpose.
	 *  @return the string including the summary, total or grand total.
	 */
	public String getValueAtInString(int rowIndex, int columnIndex, ValueConverter converter) {
	}

	/**
	 *  Only adjust the cell value string on aggregated columns.
	 * 
	 *  @param rowIndex    the row index
	 *  @param columnIndex the column index
	 *  @return true if the column index is less than aggregated column count. Otherwise false.
	 */
	public boolean needAdjustCellValueString(int rowIndex, int columnIndex) {
	}

	/**
	 *  Sets the visibility of the column.
	 * 
	 *  @param fieldName the pivot field name
	 *  @param visible   the visibility of this column
	 */
	public void setColumnVisible(String fieldName, boolean visible) {
	}

	@java.lang.Override
	public String getTableHeaderToolTipText(java.awt.event.MouseEvent event) {
	}

	@java.lang.Override
	public void prepareBeforeGroup() {
	}

	protected class ExpandMouseListener {


		protected AggregateTable.ExpandMouseListener() {
		}

		@java.lang.Override
		public void mousePressed(java.awt.event.MouseEvent e) {
		}

		@java.lang.Override
		public void mouseClicked(java.awt.event.MouseEvent e) {
		}

		@java.lang.Override
		public void mouseReleased(java.awt.event.MouseEvent e) {
		}
	}

	protected class DelegateExpandMouseInputListener {


		public AggregateTable.DelegateExpandMouseInputListener(javax.swing.event.MouseInputListener listener) {
		}

		@java.lang.Override
		public void mousePressed(java.awt.event.MouseEvent e) {
		}

		@java.lang.Override
		public void mouseClicked(java.awt.event.MouseEvent e) {
		}

		@java.lang.Override
		public void mouseReleased(java.awt.event.MouseEvent e) {
		}

		@java.lang.Override
		public void mouseDragged(java.awt.event.MouseEvent e) {
		}

		@java.lang.Override
		public void mouseMoved(java.awt.event.MouseEvent e) {
		}
	}

	/**
	 *  Popup menu customizer interface without row index and column index as input.
	 */
	public static interface class PopupMenuCustomizer {


		public void customize(javax.swing.JPopupMenu menu, java.awt.Component target) {
		}
	}

	/**
	 *  Popup menu customizer interface with row index and column index as input.
	 */
	public static interface class TablePopupMenuCustomizer {


		public void customize(javax.swing.JPopupMenu menu, java.awt.Component target, int rowIndex, int columnIndex) {
		}
	}

	public class DraggingHandler {


		public AggregateTable.DraggingHandler() {
		}

		public void propertyChange(java.beans.PropertyChangeEvent evt) {
		}

		public void columnAdded(javax.swing.event.TableColumnModelEvent e) {
		}

		public void columnRemoved(javax.swing.event.TableColumnModelEvent e) {
		}

		public void columnMoved(javax.swing.event.TableColumnModelEvent e) {
		}

		public void columnMarginChanged(javax.swing.event.ChangeEvent e) {
		}

		public void columnSelectionChanged(javax.swing.event.ListSelectionEvent e) {
		}
	}
}
