/**
 *  The package contains classes for JIDE Pivot Grid product.
 */
package com.jidesoft.pivot;


/**
 *  A <code>AggregateTableColumnChooserPopupMenuCustomizer</code> to add menu items related to show or hide the columns
 *  to a popup menu just for AggregateTable and AggregateTablePane. To use it, you can use the code like this.
 *  <code><pre>
 *  TableHeaderPopupMenuInstaller installer = new TableHeaderPopupMenuInstaller(aggregateTable)
 *  installer.addTableHeaderPopupMenuCustomizer(new AggregateTableColumnChooserPopupMenuCustomizer());
 *  </pre></code>
 */
public class AggregateTableColumnChooserPopupMenuCustomizer extends TableColumnChooserPopupMenuCustomizer {

	public AggregateTableColumnChooserPopupMenuCustomizer() {
	}

	/**
	 *  Gets the display column name to be displayed on the popup menu.
	 * 
	 *  @param table       the table
	 *  @param columnIndex the inner column index indicating the order in PivotField
	 *  @return the display name for the column at the specified column index.
	 */
	protected String getDisplayColumnName(javax.swing.JTable table, int columnIndex) {
	}

	/**
	 *  The method generates the context menu items by clickingColumn. After the process, the popup will contain all the
	 *  generated menu items. You can override the method to add some new menu items or delete some existing menu items
	 *  as you wish. You can use CONTEXT_MENU_... as the name to find the existing menu items.
	 *  <code><pre>
	 *       for (int i = 0; i < popup.getComponentCount(); i++) {
	 *           if (CONTEXT_MENU_HIDE.equals(popup.getComponent(i).getName())) {
	 *               popup.remove(popup.getComponent(i));
	 *           }
	 *       }
	 *  </pre></code>
	 * 
	 *  @param header         the table header
	 *  @param popup          the popup menu to be displayed
	 *  @param clickingColumn the column index clicked
	 */
	public void customizePopupMenu(javax.swing.table.JTableHeader header, javax.swing.JPopupMenu popup, int clickingColumn) {
	}

	protected TableColumnChooserDialog createTableColumnChooserDialog(java.awt.Window window, String title, javax.swing.JTable table) {
	}

	/**
	 *  Calls to AggregateTableUtils.showColumn to show the column.
	 * 
	 *  @param table            the table
	 *  @param columnIndex      the model column index.
	 *  @param columnIdentifier the column identifier
	 *  @since 3.2.2
	 */
	protected void showColumn(javax.swing.JTable table, int columnIndex, Object columnIdentifier) {
	}

	/**
	 *  Calls to AggregateTableUtils.hideColumn to hide the column.
	 * 
	 *  @param table            the table
	 *  @param columnIndex      the model column index.
	 *  @param columnIdentifier the column identifier
	 *  @since 3.2.2
	 */
	protected void hideColumn(javax.swing.JTable table, int columnIndex, Object columnIdentifier) {
	}

	/**
	 *  Gets the localized string from resource bundle. Subclass can override it to provide its own string. Available
	 *  keys are defined in grid.properties that begin with "TableColumnChooser.".
	 * 
	 *  @param key the resource string key
	 *  @return the localized string.
	 */
	protected String getResourceString(String key) {
	}

	protected void showAllColumns(javax.swing.JTable table, AggregateTablePane pane) {
	}
}
