/**
 *  The package contains classes for JIDE Pivot Grid product.
 */
package com.jidesoft.pivot;


/**
 *  <code>AggregateTableModel</code> takes any table models and aggregates the same values on the aggregated columns and
 *  add expand/collapse icon or cell span to the cell on these aggregated rows.
 *  <p/>
 *  It is very similar to <code>DefaultGroupTableModel</code> except DefaultGroupTableModel is a kind of TreeTableModel,
 *  v.s. AggregateTableModel is just a regular TableModel.
 *  <p/>
 *  <code>AggregateTableModel</code> used <code>PivotDataModel</code> to do the aggregation. We tried to hide this
 *  implementation detail from user as much as we can. But there is a {@link #getField(String)} method which exposes the
 *  actual <code>PivotField</code> to the user. You can use this <code>PivotField</code> to add summary to the aggregated
 *  column.
 *  <p/>
 *  If you have a table model, you call {@link #AggregateTableModel(javax.swing.table.TableModel)} to create an
 *  <code>AggregateTableModel</code>. Then you call {@link #setAggregatedColumns(int[])} or {{@link
 *  #setAggregatedColumns(String[])} to aggregate the columns that have duplicated values. At last, you call {@link
 *  #aggregate()}. This call will make the <code>AggregateTableModel</code> to be ready to be used by {@link
 *  com.jidesoft.pivot.AggregateTable}.
 */
public class AggregateTableModel extends JoinTableModel {

	public static final String PROPERTY_AGGREGATED_COLUMNS_CHANGING = "aggregateColumnsChanging";

	public AggregateTableModel(javax.swing.table.TableModel model) {
	}

	public AggregateTableModel(javax.swing.table.TableModel model, String[] aggregateColumnNames) {
	}

	public AggregateTableModel(javax.swing.table.TableModel model, int[] aggregateColumnNames) {
	}

	/**
	 *  Creates PivotDataModel and overrides calculate method to update the aggregate table model. See below for the
	 *  default code.
	 *  <code><pre>
	 *  return new AggregateTablePivotDataModel(model);
	 *  </pre></code>
	 * 
	 *  @param model the table model
	 *  @return PivotDataModel
	 */
	protected PivotDataModel createPivotDataModel(javax.swing.table.TableModel model) {
	}

	protected void customizePivotDataModel(PivotDataModel pivotDataModel) {
	}

	/**
	 *  Sets the aggregated columns. The previous aggregated columns setting will be reset. If you want to add some
	 *  column name instead of reset, please call {@link #addAggregatedColumn(int)}
	 *  <p/>
	 *  Sets the aggregated columns. Nothing is changed at this point until {@link #aggregate()} is called.
	 * 
	 *  @param columns the index of the columns to be aggregated.
	 */
	public void setAggregatedColumns(int[] columns) {
	}

	/**
	 *  Sets the aggregated columns. The previous aggregated columns setting will be reset. If you want to add some
	 *  column name instead of reset, please call {@link #addAggregatedColumn(int)}
	 *  <p/>
	 *  Nothing is changed at this point until {@link #aggregate()} is called.
	 * 
	 *  @param columnNames the name of the columns to be aggregated.
	 */
	public void setAggregatedColumns(String[] columnNames) {
	}

	public void addAggregatedColumn(int index, int column) {
	}

	public void addAggregatedColumn(int column) {
	}

	public void removeAggregatedColumn(int column) {
	}

	public void hideColumn(int column) {
	}

	/**
	 *  Checks if the table model has been aggregated.
	 * 
	 *  @return true or false.
	 */
	public boolean isAggregated() {
	}

	/**
	 *  Checks if the table model has been aggregated.
	 * 
	 *  @param column the column index.
	 *  @return true or false.
	 */
	public boolean isColumnAggregated(int column) {
	}

	/**
	 *  Sets showSummary flag. If true, there will be a summary row before the aggregated rows. The value of this summary
	 *  rows are depending on the corresponding PivotField's getSummaryType.
	 * 
	 *  @param show true or false.
	 */
	public void setShowSummary(boolean show) {
	}

	/**
	 *  Gets the showSummary flag.
	 * 
	 *  @return true if summary is shown. Otherwise false.
	 */
	public boolean isShowSummary() {
	}

	/**
	 *  Sets summaryMode flag. If false, only the first row will be displayed when the value is collapsed. If true, the
	 *  collapsed row will display the summary of all the rows. This method basically calls to {@link
	 *  PivotDataModel#setSummaryMode(boolean)}.
	 * 
	 *  @param show true or false.
	 */
	public void setSummaryMode(boolean show) {
	}

	/**
	 *  Gets the summaryMode flag.
	 * 
	 *  @return true if summary is shown when the row is collapsed. Otherwise the first row will be displayed.
	 */
	public boolean isSummaryMode() {
	}

	/**
	 *  Sets showSummaryOnly flag. If true, the last aggregated column will not be expandable.
	 * 
	 *  @param showSummaryOnly true or false.
	 */
	public void setShowSummaryOnly(boolean showSummaryOnly) {
	}

	/**
	 *  Gets the showSummaryOnly flag.
	 * 
	 *  @return true if the last aggregated column is not expandable. Otherwise false.
	 */
	public boolean isShowSummaryOnly() {
	}

	/**
	 *  Sets the flag if the aggregated columns should be sorted automatically. If true, the aggregated columns will be
	 *  sorted automatically.
	 * 
	 *  @param sorted true or false.
	 */
	public void setSortAggregatedColumns(boolean sorted) {
	}

	/**
	 *  Gets the flag if the aggregated columns should be sorted automatically
	 * 
	 *  @return true if the aggregated columns is sorted automatically. Otherwise false.
	 */
	public boolean isSortAggregatedColumns() {
	}

	/**
	 *  Sets showGrandTotal flag. If true, the last row will be the grand total row.
	 * 
	 *  @param show true or false.
	 */
	public void setShowGrandTotal(boolean show) {
	}

	/**
	 *  Gets the showSummary flag.
	 * 
	 *  @return true if summary is shown. Otherwise false.
	 */
	public boolean isShowGrandTotal() {
	}

	/**
	 *  Gets the maximum number of aggregated rows.
	 * 
	 *  @return the maximum number of aggregated rows.
	 */
	public int getMaximumAggregatedRows() {
	}

	/**
	 *  Sets the maximum number of aggregated rows. For example, if you set it to 5, the aggregated table will display
	 *  only five rows when you expand the row for the last aggregated column. You need to call aggregate() method when
	 *  this property is changed.
	 * 
	 *  @param maximumAggregatedRows the maximum number of aggregated rows.
	 */
	public void setMaximumAggregatedRows(int maximumAggregatedRows) {
	}

	/**
	 *  Gets the PivotField from the underlying PivotDataModel.
	 * 
	 *  @param name the name of the field. It should be the column name.
	 *  @return the PivotField.
	 */
	public PivotField getField(String name) {
	}

	/**
	 *  Gets the PivotField from the underlying PivotDataModel.
	 * 
	 *  @param columnIndex the column index.
	 *  @return the PivotField.
	 */
	public PivotField getField(int columnIndex) {
	}

	/**
	 *  Aggregates the table model. Please note, this method could take a long time if you have a huge table model to
	 *  aggregate. At the end, it will fire TableStructureChanged event.
	 *  <p/>
	 *  To keep the column order, please try call YourAggregateTable#aggregate() instead of call this method directly.
	 */
	public void aggregate() {
	}

	public boolean hasAggregateColumns() {
	}

	/**
	 *  Gets the count of aggregated columns.
	 * 
	 *  @return the column count.
	 *  @since 3.2.3
	 */
	@java.lang.Override
	public int getGroupColumnCount() {
	}

	/**
	 *  Gets the corresponding column index in its actual table model for the designated aggregated column.
	 * 
	 *  @param index the aggregated column index
	 *  @return the corresponding column index in its actual table model
	 *  @since 3.2.3
	 */
	@java.lang.Override
	public int getGroupColumnAt(int index) {
	}

	/**
	 *  Gets the corresponding column order in its actual table model for the designated aggregated column.
	 * 
	 *  @param index the aggregated column index
	 *  @return the corresponding column order in its actual table model
	 *  @since 3.2.3
	 */
	@java.lang.Override
	public final int getGroupColumnOrder(int index) {
	}

	/**
	 *  Sets the aggregated columns.
	 * 
	 *  @param columns the columns array
	 *  @param orders  no use for AggregateTableModel
	 *  @since 3.2.3
	 */
	@java.lang.Override
	public void setGroupColumns(int[] columns, int[] orders) {
	}

	/**
	 *  Aggregates the table model.
	 * 
	 *  @since 3.2.3
	 */
	@java.lang.Override
	public void groupAndRefresh() {
	}

	@java.lang.Override
	public void groupAndRefresh(boolean needSendStructureChange) {
	}

	/**
	 *  Checks if the column is groupable or not.
	 * 
	 *  @param columnIndex the column index
	 *  @return true if the column is groupable. Otherwise false.
	 *  @since 3.2.3
	 */
	@java.lang.Override
	public boolean isColumnGroupable(int columnIndex) {
	}

	/**
	 *  Always displays the grouped columns for AggregateTable.
	 * 
	 *  @return true.
	 *  @since 3.2.3
	 */
	@java.lang.Override
	public final boolean isDisplayGroupColumns() {
	}

	@java.lang.Override
	public boolean groupColumnsFirst() {
	}

	@java.lang.Override
	public Object getGroupColumnIdentifier(int groupColumnIndex) {
	}

	/**
	 *  Gets the number of aggregated column count.
	 * 
	 *  @return the number of aggregated column count.
	 */
	public int getAggregatedColumnCount() {
	}

	/**
	 *  Gets the aggregated column indices recorded in {@link com.jidesoft.pivot.PivotField}, which could be different
	 *  with {@link #getAggregatedColumns()} if you just invoked {@link #setAggregatedColumns(int[])} and did not invoke
	 *  {@link #aggregate()} yet.
	 * 
	 *  @return the aggregated column indices.
	 */
	public int[] getAggregatedColumnsInPivotFields() {
	}

	/**
	 *  Gets the aggregated column indices.
	 * 
	 *  @return the aggregated column indices.
	 */
	public int[] getAggregatedColumns() {
	}

	public CellStyleProvider getCellStyleProvider() {
	}

	public void setCellStyleProvider(CellStyleProvider cellStyleProvider) {
	}

	@java.lang.Override
	public CellStyle getCellStyleAt(int rowIndex, int columnIndex) {
	}

	@java.lang.Override
	public boolean isCellStyleOn() {
	}

	/**
	 *  Sets the statistics calculator.
	 * 
	 *  @param summaryCalculator the summary calculator.
	 */
	public void setSummaryCalculator(PivotSummaryCalculator summaryCalculator) {
	}

	/**
	 *  Gets the statistics calculator used to calculate all the statistics for the pivot data model.
	 * 
	 *  @return the statistics calculator.
	 */
	public SummaryCalculator getSummaryCalculator() {
	}

	/**
	 *  Gets the actual column index in the actual table model that is passed to the constructor of the
	 *  AggregateTableModel.
	 * 
	 *  @param columnModelIndex the column index as in the AggregateTableModel.
	 *  @return the actual column index in the actual table model that is passed to the constructor of the
	 *  AggregateTableModel.
	 */
	public int getActualModelColumnIndex(int columnModelIndex) {
	}

	/**
	 *  Gets the column index as in the AggregateTableModel.
	 * 
	 *  @param actualColumnIndex the actual model index as in the table model passed to the constructor of the
	 *                           AggregateTableModel.
	 *  @return the column index as in the AggregateTableModel.
	 */
	public int getModelColumnIndex(int actualColumnIndex) {
	}

	/**
	 *  Gets the actual row indices based on the visual row index and the aggregated column index.
	 * 
	 *  @param visualRow                   the visual row index.
	 *  @param aggregatedColumnVisualIndex the visual column index of the aggregated column. It must be greater than 0
	 *                                     and less then the count of the aggregated columns.
	 *  @return a list of the actual row indices.
	 */
	public Integer[] getActualRowsAt(int visualRow, int aggregatedColumnVisualIndex) {
	}

	/**
	 *  Gets the view row index based on the actual row index.
	 * 
	 *  @param actualRow the row index in the actual table model
	 *  @return the view row index. -1 if not found.
	 */
	public int getRowAt(int actualRow) {
	}

	/**
	 *  Gets the actual row index based on the visual row index.
	 * 
	 *  @param visualRow the visual row index.
	 *  @return the actual row index. If -1, it means there are multiple rows for the specified visual row index (such as
	 *  a summary row). In this case, you can use {@link #getActualRowsAt(int)} to find out all the rows.
	 */
	public int getActualRowAt(int visualRow) {
	}

	/**
	 *  Gets the visual row index representing the specified actual row.
	 * 
	 *  @param actualRow the actual row index.
	 *  @return the visual row index. -1 if there is no visual row representing it.
	 *  @since 3.1.1
	 */
	public int getVisualRowAt(int actualRow) {
	}

	/**
	 *  Gets the actual rows based on the visual row index.
	 * 
	 *  @param visualRow the visual row index.
	 *  @return the actual row indices. In most cases, it will return a list with just one row index. But if the row is a
	 *  summary row, it could return a list of several row indices which results in the summary row.
	 */
	public java.util.List getActualRowsAt(int visualRow) {
	}

	/**
	 *  Gets the PivotDataModel. This is the actual class that does the aggregation.
	 * 
	 *  @return the PivotDataModel.
	 */
	public IPivotDataModel getPivotDataModel() {
	}

	@java.lang.Override
	public Object getColumnIdentifier(int columnIndex) {
	}

	@java.lang.Override
	public synchronized Class getColumnClass(int columnIndex) {
	}

	@java.lang.Override
	public synchronized String getColumnName(int columnIndex) {
	}

	@java.lang.Override
	public synchronized int getColumnCount() {
	}

	@java.lang.Override
	public synchronized int getRowCount() {
	}

	@java.lang.Override
	public synchronized Object getValueAt(int rowIndex, int columnIndex) {
	}

	@java.lang.Override
	public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
	}

	@java.lang.Override
	public ConverterContext getConverterContextAt(int rowIndex, int columnIndex) {
	}

	@java.lang.Override
	public EditorContext getEditorContextAt(int rowIndex, int columnIndex) {
	}

	@java.lang.Override
	public Class getCellClassAt(int rowIndex, int columnIndex) {
	}

	@java.lang.Override
	public CellSpan getCellSpanAt(int rowIndex, int columnIndex) {
	}

	@java.lang.Override
	public boolean isCellSpanOn() {
	}

	@java.lang.Override
	public int getTableIndex(int columnIndex) {
	}

	@java.lang.Override
	public int getColumnType(int columnIndex) {
	}

	public javax.swing.table.TableModel getActualModel() {
	}

	/**
	 *  Support for reporting bound property changes for Object properties. This method can be called when a bound
	 *  property has changed and it will send the appropriate PropertyChangeEvent to any registered
	 *  PropertyChangeListeners.
	 * 
	 *  @param propertyName the property whose value has changed
	 *  @param oldValue     the property's previous value
	 *  @param newValue     the property's new value
	 */
	protected synchronized void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
	}

	/**
	 *  Adds a PropertyChangeListener to the listener list.
	 * 
	 *  @param listener the PropertyChangeListener to be added
	 *  @see #removePropertyChangeListener
	 *  @see #getPropertyChangeListeners
	 *  @see #addPropertyChangeListener(java.lang.String, java.beans.PropertyChangeListener)
	 */
	public synchronized void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  Removes a PropertyChangeListener from the listener list. This method should be used to remove
	 *  PropertyChangeListeners that were registered for all bound properties of this class.
	 *  <p/>
	 *  If listener is null, no exception is thrown and no action is performed.
	 * 
	 *  @param listener the PropertyChangeListener to be removed
	 *  @see #addPropertyChangeListener
	 *  @see #getPropertyChangeListeners
	 *  @see #removePropertyChangeListener(java.lang.String, java.beans.PropertyChangeListener)
	 */
	public synchronized void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  Returns an array of all the property change listeners registered on this component.
	 * 
	 *  @return all of this component's <code>PropertyChangeListener</code>s or an empty array if no property change
	 *  listeners are currently registered
	 *  @see #addPropertyChangeListener
	 *  @see #removePropertyChangeListener
	 *  @see #getPropertyChangeListeners(java.lang.String)
	 *  @see java.beans.PropertyChangeSupport#getPropertyChangeListeners
	 *  @since 1.4
	 */
	public synchronized java.beans.PropertyChangeListener[] getPropertyChangeListeners() {
	}

	/**
	 *  Adds a PropertyChangeListener to the listener list for a specific property.
	 * 
	 *  @param propertyName one of the property names listed above
	 *  @param listener     the PropertyChangeListener to be added
	 *  @see #removePropertyChangeListener(java.lang.String, java.beans.PropertyChangeListener)
	 *  @see #getPropertyChangeListeners(java.lang.String)
	 *  @see #addPropertyChangeListener(java.lang.String, java.beans.PropertyChangeListener)
	 */
	public synchronized void addPropertyChangeListener(String propertyName, java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  Removes a PropertyChangeListener from the listener list for a specific property. This method should be used to
	 *  remove PropertyChangeListeners that were registered for a specific bound property.
	 *  <p/>
	 *  If listener is null, no exception is thrown and no action is performed.
	 * 
	 *  @param propertyName a valid property name
	 *  @param listener     the PropertyChangeListener to be removed
	 *  @see #addPropertyChangeListener(java.lang.String, java.beans.PropertyChangeListener)
	 *  @see #getPropertyChangeListeners(java.lang.String)
	 *  @see #removePropertyChangeListener(java.beans.PropertyChangeListener)
	 */
	public synchronized void removePropertyChangeListener(String propertyName, java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  Returns an array of all the listeners which have been associated with the named property.
	 * 
	 *  @param propertyName the property name.
	 *  @return all of the <code>PropertyChangeListeners</code> associated with the named property or an empty array if
	 *  no listeners have been added
	 *  @see #addPropertyChangeListener(java.lang.String, java.beans.PropertyChangeListener)
	 *  @see #removePropertyChangeListener(java.lang.String, java.beans.PropertyChangeListener)
	 *  @see #getPropertyChangeListeners
	 */
	public synchronized java.beans.PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
	}

	public boolean isSettingAggregateColumns() {
	}

	public void setSettingAggregateColumns(boolean settingAggregateColumns) {
	}

	/**
	 *  Gets actual column index in actual table model from the column index in AggregateTableModel.
	 * 
	 *  @param column the column index in AggregateTableModel
	 *  @return the actual column index in actual table model. -1 if not found.
	 *  @since 3.2.0
	 */
	@java.lang.Override
	public int getActualColumnAt(int column) {
	}

	/**
	 *  Gets the column index in AggregateTableModel from actual column index in actual table model.
	 * 
	 *  @param actualColumn the actual column index in actual table model
	 *  @return the column index in AggregateTableModel. -1 if not found.
	 *  @since 3.2.0
	 */
	@java.lang.Override
	public int getVisualColumnAt(int actualColumn) {
	}

	@java.lang.Override
	public void addIndexChangeListener(IndexChangeListener l) {
	}

	@java.lang.Override
	public void removeIndexChangeListener(IndexChangeListener l) {
	}

	@java.lang.Override
	public IndexChangeListener[] getIndexChangeListeners() {
	}

	/**
	 *  The PivotDataModel for AggregateTable to use.
	 * 
	 *  @since 3.3.0
	 */
	protected class AggregateTablePivotDataModel {


		public AggregateTableModel.AggregateTablePivotDataModel(javax.swing.table.TableModel tableModel) {
		}

		@java.lang.Override
		protected boolean tableRowsInserted(int firstRow, int lastRow) {
		}

		@java.lang.Override
		protected boolean tableRowsDeleted(int firstRow, int lastRow) {
		}

		@java.lang.Override
		public void initialize() {
		}

		@java.lang.Override
		public void calculate() {
		}

		@java.lang.Override
		public void setOriginalTableModel(javax.swing.table.TableModel tableModel) {
		}

		@java.lang.Override
		public boolean isHideExpandIconOnSingleRow() {
		}
	}
}
