/**
 *  The package contains classes for JIDE Pivot Grid product.
 */
package com.jidesoft.pivot;


/**
 *  A <code>TableScrollPane</code> which uses AggregateTable as the row header table to implement the freeze column
 *  feature on an AggregateTable.
 *  <p/>
 *  If you have a very big table and observe obvious performance issue while scrolling. You could use the following code
 *  to enhance the performance. Of course, you have to prepare for huge memory usage for the cache. That's why we didn't
 *  put it on JIDE jar.
 *  <code><pre>
 *          // After you create the AggregrateTablePane instance, you can add a CachedTableModel wrapper to improve the performance.
 *          _aggregateTablePane.setTableModel(new CachedTableModel(_aggregateTablePane.getTableModel()));
 *  </pre></code>
 */
public class AggregateTablePane extends TableScrollPane {

	public AggregateTablePane(MultiTableModel model) {
	}

	public AggregateTablePane(javax.swing.table.TableModel model, String[] columnNames) {
	}

	public AggregateTablePane(javax.swing.table.TableModel model, int[] column) {
	}

	/**
	 *  Sets the original table model and recreates all child tables.
	 * 
	 *  @param tableModel the new MultiTableModel
	 */
	@java.lang.Override
	public void setTableModel(MultiTableModel tableModel) {
	}

	/**
	 *  Gets the underlying AggregateTableModel.
	 * 
	 *  @return the AggregateTableModel.
	 */
	public AggregateTableModel getAggregateTableModel() {
	}

	@java.lang.Override
	protected javax.swing.JTable createTable(javax.swing.table.TableModel model, boolean sortable, int type) {
	}

	/**
	 *  Creates a SortableAggregateTableModel or regular SortableTableModel for the MultiTableModel if isSortable() is
	 *  true. Otherwise, tableModel itself will be returned.
	 * 
	 *  @param tableModel the MultiTableModel
	 *  @param sortable   true or false. If true, the tableModel should be wrapped into a SortableAggregateTableModel or
	 *                    regular SortableTableModel.
	 *  @return a SortableAggregateTableModel or regular SortableTableModel for the MultiTableModel if isSortable() is
	 *          true.
	 */
	@java.lang.Override
	protected javax.swing.table.TableModel createSortableTableModel(MultiTableModel tableModel, boolean sortable) {
	}
}
