/**
 *  The package contains classes for JIDE Pivot Grid product.
 */
package com.jidesoft.pivot;


/**
 *  A helper class that can support persist AggregateTablePane's layout to/from xml file.
 */
public class AggregateTablePanePersistenceUtils {

	public AggregateTablePanePersistenceUtils() {
	}

	/**
	 *  Saves the AggregateTablePane's layout to a file.
	 * 
	 *  @param pane     the AggregateTablePane
	 *  @param fileName the file name
	 *  @throws javax.xml.parsers.ParserConfigurationException
	 *                              if a DocumentBuilder cannot be created which satisfies the configuration
	 *  @throws java.io.IOException If the pathname argument is null or any IO errors happen
	 */
	public static void save(AggregateTablePane pane, String fileName) {
	}

	/**
	 *  Saves the AggregateTablePane's layout to an output stream.
	 * 
	 *  @param pane the AggregateTablePane
	 *  @param out  the output stream
	 *  @throws javax.xml.parsers.ParserConfigurationException
	 *                              if a DocumentBuilder cannot be created which satisfies the configuration
	 *  @throws java.io.IOException If the pathname argument is null or any IO errors happen
	 */
	public static void save(AggregateTablePane pane, java.io.OutputStream out) {
	}

	/**
	 *  Saves the AggregateTablePane's layout to an XML Document
	 * 
	 *  @param pane the AggregateTablePane
	 *  @return XML Document which has the AggregateTablePane's layout.
	 *  @throws javax.xml.parsers.ParserConfigurationException
	 *           if a DocumentBuilder cannot be created which satisfies the configuration
	 */
	public static org.w3c.dom.Document save(AggregateTablePane pane) {
	}

	/**
	 *  Saves the AggregateTablePane's layout to a file.
	 * 
	 *  @param pane     the AggregateTablePane
	 *  @param fileName the file name
	 *  @param callback The callback which will be called when saving each element to the XML document.
	 *  @throws javax.xml.parsers.ParserConfigurationException
	 *                              if a DocumentBuilder cannot be created which satisfies the configuration
	 *  @throws java.io.IOException If the pathname argument is null or any IO errors happen
	 */
	public static void save(AggregateTablePane pane, String fileName, PersistenceUtilsCallback.Save callback) {
	}

	/**
	 *  Saves the AggregateTablePane's layout to a file.
	 * 
	 *  @param pane     the AggregateTablePane
	 *  @param fileName the file name
	 *  @param callback the callback which will be called when saving each element to the XML document
	 *  @param encoding the encoding choice. It would be UTF-8 in default if you call the method without this parameter.
	 *  @throws javax.xml.parsers.ParserConfigurationException
	 *                              if a DocumentBuilder cannot be created which satisfies the configuration
	 *  @throws java.io.IOException If the pathname argument is null or any IO errors happen
	 */
	public static void save(AggregateTablePane pane, String fileName, PersistenceUtilsCallback.Save callback, String encoding) {
	}

	/**
	 *  Saves the AggregateTablePane's layout to an output stream.
	 * 
	 *  @param pane     the AggregateTablePane
	 *  @param out      the output stream
	 *  @param callback The callback which will be called when saving each element to the XML document.
	 *  @throws javax.xml.parsers.ParserConfigurationException
	 *                              if a DocumentBuilder cannot be created which satisfies the configuration
	 *  @throws java.io.IOException If the pathname argument is null or any IO errors happen
	 */
	public static void save(AggregateTablePane pane, java.io.OutputStream out, PersistenceUtilsCallback.Save callback) {
	}

	/**
	 *  Saves the AggregateTablePane's layout to an output stream.
	 * 
	 *  @param pane     the AggregateTablePane
	 *  @param out      the output stream
	 *  @param callback The callback which will be called when saving each element to the XML document.
	 *  @param encoding the encoding choice. It would be UTF-8 in default if you call the method without this parameter.
	 *  @throws javax.xml.parsers.ParserConfigurationException
	 *                              if a DocumentBuilder cannot be created which satisfies the configuration
	 *  @throws java.io.IOException If the pathname argument is null or any IO errors happen
	 */
	public static void save(AggregateTablePane pane, java.io.OutputStream out, PersistenceUtilsCallback.Save callback, String encoding) {
	}

	/**
	 *  Saves the AggregateTablePane's layout to an XML Document
	 * 
	 *  @param pane     the AggregateTablePane
	 *  @param callback The callback which will be called when saving each element to the XML document.
	 *  @return XML Document which has the AggregateTablePane's layout.
	 *  @throws javax.xml.parsers.ParserConfigurationException
	 *           if a DocumentBuilder cannot be created which satisfies the configuration
	 */
	public static org.w3c.dom.Document save(AggregateTablePane pane, PersistenceUtilsCallback.Save callback) {
	}

	/**
	 *  Loads the AggregateTablePane's layout from an input stream.
	 * 
	 *  @param pane the AggregateTablePane
	 *  @param in   the input stream
	 *  @throws javax.xml.parsers.ParserConfigurationException
	 *                              if a DocumentBuilder cannot be created which satisfies the configuration
	 *  @throws SAXException        if either the XML parser or the application has errors
	 *  @throws java.io.IOException if the pathname argument is null or any IO errors happen
	 */
	public static void load(AggregateTablePane pane, java.io.InputStream in) {
	}

	/**
	 *  Loads the layout from xml file.
	 * 
	 *  @param pane     the AggregateTablePane
	 *  @param fileName the layout file name.
	 *  @throws javax.xml.parsers.ParserConfigurationException
	 *                                   if a DocumentBuilder cannot be created which satisfies the configuration
	 *                                   requested.
	 *  @throws org.xml.sax.SAXException If any parse errors occur.
	 *  @throws java.io.IOException      If the pathname argument is null or any IO errors happen
	 */
	public static void load(AggregateTablePane pane, String fileName) {
	}

	/**
	 *  Loads the layout from xml document.
	 * 
	 *  @param pane     the AggregateTablePane
	 *  @param document the XML document
	 */
	public static void load(AggregateTablePane pane, org.w3c.dom.Document document) {
	}

	/**
	 *  Loads the layout from input stream.
	 * 
	 *  @param pane     the AggregateTablePane
	 *  @param in       the input stream
	 *  @param callback The callback which will be called when loading each element in the XML document.
	 *  @throws javax.xml.parsers.ParserConfigurationException
	 *                                   if a DocumentBuilder cannot be created which satisfies the configuration
	 *                                   requested.
	 *  @throws org.xml.sax.SAXException If any parse errors occur.
	 *  @throws java.io.IOException      If the pathname argument is null or any IO errors happen
	 */
	public static void load(AggregateTablePane pane, java.io.InputStream in, PersistenceUtilsCallback.Load callback) {
	}

	/**
	 *  Loads the layout from xml file.
	 * 
	 *  @param pane     the AggregateTablePane
	 *  @param fileName the layout file name.
	 *  @param callback The callback which will be called when loading each element in the XML document.
	 *  @throws javax.xml.parsers.ParserConfigurationException
	 *                                   if a DocumentBuilder cannot be created which satisfies the configuration
	 *                                   requested.
	 *  @throws org.xml.sax.SAXException If any parse errors occur.
	 *  @throws java.io.IOException      If the pathname argument is null or any IO errors happen
	 */
	public static void load(AggregateTablePane pane, String fileName, PersistenceUtilsCallback.Load callback) {
	}

	/**
	 *  Loads the layout from xml document.
	 * 
	 *  @param pane     the AggregateTablePane
	 *  @param document the XML document
	 *  @param callback The callback which will be called when loading each element in the XML document.
	 */
	public static void load(AggregateTablePane pane, org.w3c.dom.Document document, PersistenceUtilsCallback.Load callback) {
	}

	/**
	 *  Gets the version of the layout file. Null is the layout file is invalid.
	 * 
	 *  @param in the InputStream
	 *  @return the version.
	 *  @throws javax.xml.parsers.ParserConfigurationException
	 *                                   if a DocumentBuilder cannot be created which satisfies the configuration
	 *                                   requested.
	 *  @throws org.xml.sax.SAXException If any parse errors occur.
	 *  @throws java.io.IOException      If the pathname argument is null or any IO errors happen
	 */
	public static String getVersion(java.io.InputStream in) {
	}

	/**
	 *  Gets the version of the layout file. Null is the layout file is invalid.
	 * 
	 *  @param fileName the Document for the layout
	 *  @return the version.
	 *  @throws javax.xml.parsers.ParserConfigurationException
	 *                                   if a DocumentBuilder cannot be created which satisfies the configuration
	 *                                   requested.
	 *  @throws org.xml.sax.SAXException If any parse errors occur.
	 *  @throws java.io.IOException      If the pathname argument is null or any IO errors happen
	 */
	public static String getVersion(String fileName) {
	}

	/**
	 *  Gets the version of the layout file. Null is the layout file is invalid.
	 * 
	 *  @param document the Document for the layout
	 *  @return the version.
	 */
	public static String getVersion(org.w3c.dom.Document document) {
	}

	/**
	 *  Checks if the layout is valid.
	 * 
	 *  @param pane the aggregate table pane.
	 *  @param in   the input steam which is an XML layout file.
	 *  @throws javax.xml.parsers.ParserConfigurationException
	 *                                   if a DocumentBuilder cannot be created which satisfies the configuration
	 *                                   requested.
	 *  @throws org.xml.sax.SAXException if any parse error occurs.
	 *  @throws java.io.IOException      if any IO error occurs.
	 *  @throws IllegalArgumentException if the layout content is invalid such as version number is missing or the field
	 *                                   in the layout is no longer in the pivot table pane.
	 */
	public static void isLayoutValid(AggregateTablePane pane, java.io.InputStream in) {
	}

	/**
	 *  Checks if the layout is valid.
	 * 
	 *  @param pane     the aggregate table pane.
	 *  @param fileName the file name of an XML layout file.
	 *  @throws javax.xml.parsers.ParserConfigurationException
	 *                                   if a DocumentBuilder cannot be created which satisfies the configuration
	 *                                   requested.
	 *  @throws org.xml.sax.SAXException if any parse error occurs.
	 *  @throws java.io.IOException      if any IO error occurs.
	 *  @throws IllegalArgumentException if the layout content is invalid such as version number is missing or the field
	 *                                   in the layout is no longer in the pivot table pane.
	 */
	public static void isLayoutValid(AggregateTablePane pane, String fileName) {
	}

	/**
	 *  Checks if the layout is valid.
	 * 
	 *  @param pane     the aggregate table pane.
	 *  @param document the XML Document
	 *  @throws IllegalArgumentException if the layout content is invalid such as version number is missing or the field
	 *                                   in the layout is no longer in the pivot table pane.
	 */
	public static void isLayoutValid(AggregateTablePane pane, org.w3c.dom.Document document) {
	}
}
