/**
 *  The package contains classes for JIDE Pivot Grid product.
 */
package com.jidesoft.pivot;


/**
 *  A helper class that can support persist AggregateTable's layout to/from xml file.
 */
public class AggregateTablePersistenceUtils {

	public AggregateTablePersistenceUtils() {
	}

	/**
	 *  Saves the AggregateTable's layout to a file.
	 * 
	 *  @param table    the AggregateTable
	 *  @param fileName the file name
	 *  @throws javax.xml.parsers.ParserConfigurationException
	 *                              if a DocumentBuilder cannot be created which satisfies the configuration
	 *  @throws java.io.IOException If the pathname argument is null or any IO errors happen
	 */
	public static void save(AggregateTable table, String fileName) {
	}

	/**
	 *  Saves the AggregateTable's layout to an output stream.
	 * 
	 *  @param table the AggregateTable
	 *  @param out   the output stream
	 *  @throws javax.xml.parsers.ParserConfigurationException
	 *                              if a DocumentBuilder cannot be created which satisfies the configuration
	 *  @throws java.io.IOException If the pathname argument is null or any IO errors happen
	 */
	public static void save(AggregateTable table, java.io.OutputStream out) {
	}

	/**
	 *  Saves the AggregateTable's layout to an XML Document
	 * 
	 *  @param table the AggregateTable
	 *  @return XML Document which has the AggregateTable's layout.
	 *  @throws javax.xml.parsers.ParserConfigurationException
	 *           if a DocumentBuilder cannot be created which satisfies the configuration
	 */
	public static org.w3c.dom.Document save(AggregateTable table) {
	}

	/**
	 *  Saves the AggregateTable's layout to a file.
	 * 
	 *  @param table    the AggregateTable
	 *  @param fileName the file name
	 *  @param callback The callback which will be called when saving each element to the XML document.
	 *  @throws javax.xml.parsers.ParserConfigurationException
	 *                              if a DocumentBuilder cannot be created which satisfies the configuration
	 *  @throws java.io.IOException If the pathname argument is null or any IO errors happen
	 */
	public static void save(AggregateTable table, String fileName, PersistenceUtilsCallback.Save callback) {
	}

	/**
	 *  Saves the AggregateTable's layout to a file.
	 * 
	 *  @param table    the AggregateTable
	 *  @param fileName the file name
	 *  @param callback the callback which will be called when saving each element to the XML document
	 *  @param encoding the encoding choice. It would be UTF-8 in default if you call the method without this parameter.
	 *  @throws javax.xml.parsers.ParserConfigurationException
	 *                              if a DocumentBuilder cannot be created which satisfies the configuration
	 *  @throws java.io.IOException If the pathname argument is null or any IO errors happen
	 */
	public static void save(AggregateTable table, String fileName, PersistenceUtilsCallback.Save callback, String encoding) {
	}

	/**
	 *  Saves the AggregateTable's layout to an output stream.
	 * 
	 *  @param table    the AggregateTable
	 *  @param out      the output stream
	 *  @param callback The callback which will be called when saving each element to the XML document.
	 *  @throws javax.xml.parsers.ParserConfigurationException
	 *                              if a DocumentBuilder cannot be created which satisfies the configuration
	 *  @throws java.io.IOException If the pathname argument is null or any IO errors happen
	 */
	public static void save(AggregateTable table, java.io.OutputStream out, PersistenceUtilsCallback.Save callback) {
	}

	/**
	 *  Saves the AggregateTable's layout to an output stream.
	 * 
	 *  @param table    the AggregateTable
	 *  @param out      the output stream
	 *  @param callback The callback which will be called when saving each element to the XML document.
	 *  @param encoding the encoding choice. It would be UTF-8 in default if you call the method without this parameter.
	 *  @throws javax.xml.parsers.ParserConfigurationException
	 *                              if a DocumentBuilder cannot be created which satisfies the configuration
	 *  @throws java.io.IOException If the pathname argument is null or any IO errors happen
	 */
	public static void save(AggregateTable table, java.io.OutputStream out, PersistenceUtilsCallback.Save callback, String encoding) {
	}

	/**
	 *  Saves the AggregateTable's layout to an XML Document
	 * 
	 *  @param table    the AggregateTable
	 *  @param callback The callback which will be called when saving each element to the XML document.
	 *  @return XML Document which has the AggregateTable's layout.
	 *  @throws javax.xml.parsers.ParserConfigurationException
	 *           if a DocumentBuilder cannot be created which satisfies the configuration
	 */
	public static org.w3c.dom.Document save(AggregateTable table, PersistenceUtilsCallback.Save callback) {
	}

	/**
	 *  Loads the AggregateTable's layout from an input stream.
	 * 
	 *  @param table the AggregateTable
	 *  @param in    the input stream
	 *  @throws javax.xml.parsers.ParserConfigurationException
	 *                                   if a DocumentBuilder cannot be created which satisfies the configuration
	 *  @throws org.xml.sax.SAXException if either the XML parser or the application has errors
	 *  @throws java.io.IOException      if the pathname argument is null or any IO errors happen
	 */
	public static void load(AggregateTable table, java.io.InputStream in) {
	}

	/**
	 *  Loads the layout from xml file.
	 * 
	 *  @param table    the AggregateTable
	 *  @param fileName the layout file name.
	 *  @throws javax.xml.parsers.ParserConfigurationException
	 *                                   if a DocumentBuilder cannot be created which satisfies the configuration
	 *                                   requested.
	 *  @throws org.xml.sax.SAXException If any parse errors occur.
	 *  @throws java.io.IOException      If the pathname argument is null or any IO errors happen
	 */
	public static void load(AggregateTable table, String fileName) {
	}

	/**
	 *  Loads the layout from xml document.
	 * 
	 *  @param table    the AggregateTable
	 *  @param document the XML document
	 */
	public static void load(AggregateTable table, org.w3c.dom.Document document) {
	}

	/**
	 *  Loads the layout from input stream.
	 * 
	 *  @param table    the AggregateTable
	 *  @param in       the input stream
	 *  @param callback The callback which will be called when loading each element in the XML document.
	 *  @throws javax.xml.parsers.ParserConfigurationException
	 *                                   if a DocumentBuilder cannot be created which satisfies the configuration
	 *                                   requested.
	 *  @throws org.xml.sax.SAXException If any parse errors occur.
	 *  @throws java.io.IOException      If the pathname argument is null or any IO errors happen
	 */
	public static void load(AggregateTable table, java.io.InputStream in, PersistenceUtilsCallback.Load callback) {
	}

	/**
	 *  Loads the layout from xml file.
	 * 
	 *  @param table    the AggregateTable
	 *  @param fileName the layout file name.
	 *  @param callback The callback which will be called when loading each element in the XML document.
	 *  @throws javax.xml.parsers.ParserConfigurationException
	 *                                   if a DocumentBuilder cannot be created which satisfies the configuration
	 *                                   requested.
	 *  @throws org.xml.sax.SAXException If any parse errors occur.
	 *  @throws java.io.IOException      If the pathname argument is null or any IO errors happen
	 */
	public static void load(AggregateTable table, String fileName, PersistenceUtilsCallback.Load callback) {
	}

	/**
	 *  Loads the layout from xml document.
	 * 
	 *  @param table    the AggregateTable
	 *  @param document the XML document
	 *  @param callback The callback which will be called when loading each element in the XML document.
	 */
	public static void load(AggregateTable table, org.w3c.dom.Document document, PersistenceUtilsCallback.Load callback) {
	}

	/**
	 *  Gets the version of the layout file. Null is the layout file is invalid.
	 * 
	 *  @param in the InputStream
	 *  @return the version.
	 *  @throws javax.xml.parsers.ParserConfigurationException
	 *                                   if a DocumentBuilder cannot be created which satisfies the configuration
	 *                                   requested.
	 *  @throws org.xml.sax.SAXException If any parse errors occur.
	 *  @throws java.io.IOException      If the pathname argument is null or any IO errors happen
	 */
	public static String getVersion(java.io.InputStream in) {
	}

	/**
	 *  Gets the version of the layout file. Null is the layout file is invalid.
	 * 
	 *  @param fileName the Document for the layout
	 *  @return the version.
	 *  @throws javax.xml.parsers.ParserConfigurationException
	 *                                   if a DocumentBuilder cannot be created which satisfies the configuration
	 *                                   requested.
	 *  @throws org.xml.sax.SAXException If any parse errors occur.
	 *  @throws java.io.IOException      If the pathname argument is null or any IO errors happen
	 */
	public static String getVersion(String fileName) {
	}

	/**
	 *  Gets the version of the layout file. Null is the layout file is invalid.
	 * 
	 *  @param document the Document for the layout
	 *  @return the version.
	 */
	public static String getVersion(org.w3c.dom.Document document) {
	}

	/**
	 *  Checks if the layout is valid.
	 * 
	 *  @param table the aggregate table.
	 *  @param in    the input steam which is an XML layout file.
	 *  @throws javax.xml.parsers.ParserConfigurationException
	 *                                   if a DocumentBuilder cannot be created which satisfies the configuration
	 *                                   requested.
	 *  @throws org.xml.sax.SAXException if any parse error occurs.
	 *  @throws java.io.IOException      if any IO error occurs.
	 *  @throws IllegalArgumentException if the layout content is invalid such as version number is missing or the field
	 *                                   in the layout is no longer in the pivot table pane.
	 */
	public static void isLayoutValid(AggregateTable table, java.io.InputStream in) {
	}

	/**
	 *  Checks if the layout is valid.
	 * 
	 *  @param table    the aggregate table.
	 *  @param fileName the file name of an XML layout file.
	 *  @throws javax.xml.parsers.ParserConfigurationException
	 *                                   if a DocumentBuilder cannot be created which satisfies the configuration
	 *                                   requested.
	 *  @throws org.xml.sax.SAXException if any parse error occurs.
	 *  @throws java.io.IOException      if any IO error occurs.
	 *  @throws IllegalArgumentException if the layout content is invalid such as version number is missing or the field
	 *                                   in the layout is no longer in the pivot table pane.
	 */
	public static void isLayoutValid(AggregateTable table, String fileName) {
	}

	/**
	 *  Checks if the layout is valid.
	 * 
	 *  @param table    the aggregate table.
	 *  @param document the XML Document
	 *  @throws IllegalArgumentException if the layout content is invalid such as version number is missing or the field
	 *                                   in the layout is no longer in the pivot table pane.
	 */
	public static void isLayoutValid(AggregateTable table, org.w3c.dom.Document document) {
	}
}
