/**
 *  The package contains classes for JIDE Pivot Grid product.
 */
package com.jidesoft.pivot;


/**
 *  A <code>TableHeaderPopupMenuCustomizer</code> for <code>AggregateTable</code> and <code>AggregateTablePane</code>. To
 *  use it, you can use the code like this.
 *  <code><pre>
 *  TableHeaderPopupMenuInstaller installer = new TableHeaderPopupMenuInstaller(aggregateTable)
 *  installer.addTableHeaderPopupMenuCustomizer(new AggregateTablePopupMenuCustomizer());
 *  </pre></code>
 *  The <code>AggregateTablePopupMenuCustomizer</code> will add the "Group", "Ungroup", "Expand" and "Collapse" etc menu
 *  items to the popup menu. For <code>AggregateTablePane</code>, you need to install the installer to both the main
 *  table and the row header table.
 */
public class AggregateTablePopupMenuCustomizer {

	/**
	 *  CONTEXT_MENU_... are the possible menu names displayed in the menu. You can use these string as name to locate
	 *  the existing menu items.
	 * 
	 *  @see #customizePopupMenu(javax.swing.table.JTableHeader, javax.swing.JPopupMenu, int)
	 */
	public static final String CONTEXT_MENU_UNGROUP = "HeaderTable.ungroup";

	public static final String CONTEXT_MENU_GROUP = "HeaderTable.group";

	public static final String CONTEXT_MENU_EXPAND = "HeaderTable.expandColumn";

	public static final String CONTEXT_MENU_COLLAPSE = "HeaderTable.collapseColumn";

	public static final String CONTEXT_MENU_EXPAND_ALL = "HeaderTable.expandAll";

	public static final String CONTEXT_MENU_COLLAPSE_ALL = "HeaderTable.collapseAll";

	public static final String CONTEXT_MENU_SET_SUBTOTAL = "HeaderTable.setSubtotal";

	public static final String CONTEXT_MENU_SHOW_GRAND_TOTAL = "HeaderTable.showGrandTotal";

	public static final String CONTEXT_MENU_SET_SUMMARY = "HeaderTable.setSummary";

	public static final String CONTEXT_MENU_AUTOMATIC = "HeaderTable.automatic";

	public AggregateTablePopupMenuCustomizer() {
	}

	/**
	 *  Gets the aggregatable columns. By default, all columns are aggregatable but you can use {@link
	 *  #setAggregatableColumns(int[])} to set the columns.
	 * 
	 *  @return the aggregatable columns.
	 */
	public int[] getAggregatableColumns() {
	}

	/**
	 *  Sets the aggregatable columns. Only columns included in the array is allowed to be grouped.
	 * 
	 *  @param aggregatableColumns the aggregatable columns
	 */
	public void setAggregatableColumns(int[] aggregatableColumns) {
	}

	/**
	 *  Gets the localized string from resource bundle. Subclass can override it to provide its own string. Available
	 *  keys are defined in pivot.properties that begin with "HeaderTable." and "AggregateTable.".
	 * 
	 *  @param key the resource string key
	 *  @return the localized string.
	 */
	protected String getResourceString(String key) {
	}

	/**
	 *  The method generates the context menu items by clickingColumn. After the process, the popup will contain all the
	 *  generated menu items. You can override the method to add some new menu items or delete some existing menu items
	 *  as you wish. You can use CONTEXT_MENU_... as the name to find the existing menu items.
	 *  <code><pre>
	 *       for (int i = 0; i < popup.getComponentCount(); i++) {
	 *           if (CONTEXT_MENU_COLLAPSE.equals(popup.getComponent(i).getName())) {
	 *               popup.remove(popup.getComponent(i));
	 *           }
	 *       }
	 *  </pre></code>
	 * 
	 *  @param header         the table header
	 *  @param popup          the popup menu to be displayed
	 *  @param clickingColumn the column index clicked
	 */
	public void customizePopupMenu(javax.swing.table.JTableHeader header, javax.swing.JPopupMenu popup, int clickingColumn) {
	}
}
