/**
 *  The package contains classes for JIDE Pivot Grid product.
 */
package com.jidesoft.pivot;


/**
 *  Utility methods for AggregateTable.
 *  <p/>
 *  AggregateTable will change its model each time you call aggregate() if the aggregated columns are changed. Hence, the
 *  table model is not as "solid" as in other normal table. The solid model data in AggregateTable is the order PivotDataModel
 *  keeps its PivotFields. To make sure you can get correct column name, you need convert the column index in table model
 *  to field index first. That's why we have those utility methods for AggregateTable.
 *  <p/>
 *  The field index means that the order of the PivotField inside the PivotDataModel. You would be able to invoke
 *  {@link PivotDataModel#getField(int)} to get the PivotField instance with the field index.
 *  <p/>
 *  In those utility methods, we will use fieldIndex to indicate the solid index in PivotField while tableModelIndex means
 *  the model index in current view.
 */
public class AggregateTableUtils {

	public AggregateTableUtils() {
	}

	/**
	 *  Gets AggregateTablePane which contains the table if any.
	 * 
	 *  @param table the table
	 *  @return the AggregateTablePane if found. Otherwise null.
	 */
	public static AggregateTablePane getAggregateTablePane(javax.swing.JTable table) {
	}

	/**
	 *  Checks if the column is visible in the table.
	 * 
	 *  @param table      the table
	 *  @param fieldIndex the pivot field index
	 *  @return true if the column is currently visible. Otherwise false.
	 */
	public static boolean isColumnVisible(javax.swing.JTable table, int fieldIndex) {
	}

	/**
	 *  Gets column name of the table.
	 * 
	 *  @param table      the table
	 *  @param fieldIndex the pivot field index
	 *  @return the column name.
	 */
	public static String getColumnName(javax.swing.JTable table, int fieldIndex) {
	}

	/**
	 *  Gets column identifier of the table.
	 * 
	 *  @param table      the table
	 *  @param fieldIndex the pivot field index
	 *  @return the column identifier.
	 */
	public static Object getColumnIdentifier(javax.swing.JTable table, int fieldIndex) {
	}

	/**
	 *  Get which table the column identifier belongs to. In AggregateTablePane scenario, it could be different with the
	 *  input table.
	 * 
	 *  @param table            the index table
	 *  @param fieldName        the pivot field name
	 *  @return the table which contains the name of the pivot field.
	 */
	public static javax.swing.JTable getColumnTable(javax.swing.JTable table, Object fieldName) {
	}

	/**
	 *  Gets the field index from the column fieldName you have.
	 * 
	 *  @param table      the table
	 *  @param fieldName  the pivot field name
	 *  @return the field index. -1 if not found.
	 *  @deprecated replaced by {@link #getFieldIndex(javax.swing.JTable, Object)}
	 */
	@java.lang.Deprecated
	protected static int getInnerModelIndex(javax.swing.JTable table, Object fieldName) {
	}

	/**
	 *  Gets the field index from the column fieldName you have.
	 * 
	 *  @param table      the table
	 *  @param fieldName  the pivot field name
	 *  @return the field index. -1 if not found.
	 */
	public static int getFieldIndex(javax.swing.JTable table, Object fieldName) {
	}

	/**
	 *  Gets the model index in table model from the field index.
	 * 
	 *  @param table           the table
	 *  @param fieldIndex      the field index
	 *  @return the model index
	 *  @deprecated replaced by {@link #getTableModelIndex(javax.swing.JTable, int)}
	 */
	@java.lang.Deprecated
	protected static int getOuterModelIndex(javax.swing.JTable table, int fieldIndex) {
	}

	/**
	 *  Gets the model index in table model from the field index.
	 * 
	 *  @param table           the table
	 *  @param fieldIndex      the field index
	 *  @return the model index
	 */
	protected static int getTableModelIndex(javax.swing.JTable table, int fieldIndex) {
	}

	/**
	 *  Hide column with fieldName and table model index.
	 * 
	 *  @param table      the table
	 *  @param fieldName  the pivot field name
	 *  @param modelIndex the table model index
	 */
	public static void hideColumn(javax.swing.JTable table, Object fieldName, int modelIndex) {
	}

	/**
	 *  Show column with fieldName and table model index
	 * 
	 *  @param table      the table
	 *  @param fieldName  the pivot filed name
	 *  @param modelIndex the table model index
	 */
	public static void showColumn(javax.swing.JTable table, Object fieldName, int modelIndex) {
	}
}
