/**
 *  The package contains classes for JIDE Pivot Grid product.
 */
package com.jidesoft.pivot;


/**
 *  CompoundKey is a class that takes several objects and make them into one value so that it can be used as the key for
 *  a Map.
 */
public class CompoundKey implements Comparable, java.io.Serializable {

	/**
	 *  Creates a CompoundKey.
	 * 
	 *  @param keys An array of keys.
	 */
	protected CompoundKey(Object[] keys) {
	}

	/**
	 *  Reuse the same instance of compound key.
	 * 
	 *  @param keys the keys
	 *  @return the same instance of compound key that was created before.
	 */
	public static CompoundKey newInstance(Object[] keys) {
	}

	/**
	 *  Gets the hash code for this compound key.
	 */
	@java.lang.Override
	public int hashCode() {
	}

	/**
	 *  Compare two CompoundKeys.
	 * 
	 *  @param o The Object to check for equality.
	 *  @return a negative integer, zero, or a positive integer as this object is less than, equal to, or greater than
	 *  the specified object.
	 */
	public int compareTo(CompoundKey o) {
	}

	/**
	 *  Compare two CompoundKeys with the specified sort orders for each key.
	 * 
	 *  @param thatKey        the key to be compared
	 *  @param pivotDataModel the pivot data model
	 *  @param fields         the pivot fields
	 *  @param orders         the order of each field
	 *  @return a negative integer, zero, or a positive integer as this object is less than, equal to, or greater than
	 *  the specified object.
	 */
	public int compareTo(CompoundKey thatKey, IPivotDataModel pivotDataModel, PivotField[] fields, int[] orders) {
	}

	/**
	 *  Indicates whether this key contains the same key values as another CompoundKey.
	 * 
	 *  @param o The other object to compare to this
	 *  @return true if, and only if, the other object o is a CompoundKey and o contains exactly the same number of key
	 *  values as this key, and the key values in o are equal to, and in the same order as, the key values in this key.
	 */
	@java.lang.Override
	public boolean equals(Object o) {
	}

	/**
	 *  Gets the keys used in this CompoundKey.
	 * 
	 *  @return the keys used in this CompoundKey.
	 */
	public Object[] getKeys() {
	}

	@java.lang.Override
	public String toString() {
	}

	/**
	 *  Gets the number of keys.
	 * 
	 *  @return the number of keys.
	 */
	public int getKeyCount() {
	}

	/**
	 *  Checks if the first number of keys in this CompoundKey are the same as the keys in the specified key.
	 * 
	 *  @param key key to compare with
	 *  @return true if the first number of keys in this CompoundKey are the same as the keys in the specified key.
	 */
	public boolean startsWith(CompoundKey key) {
	}

	public int hashCode(int i) {
	}

	/**
	 *  Gets several CompoundKeys that are partial of this CompoundKey. For example, if a CompoundKey has {a,b,c}, this
	 *  method will return {a}, {a,b}, and the CompoundKey itself {a,b,c}, as an array. All CompoundKeys in the return
	 *  array will make {@link #startsWith(CompoundKey)} true.
	 * 
	 *  @return the prefixes of the CompoundKey.
	 */
	public CompoundKey[] getCompoundKeyPrefixes() {
	}

	/**
	 *  Gets the last key from this compound key.
	 * 
	 *  @return the last key from this compound key.
	 */
	public Object getLastKey() {
	}

	/**
	 *  Gets the immediate prefix. For example, if the CompoundKey has three keys, the immediate prefix will have the
	 *  first two keys. If there are no keys, it will return an empty CompoundKey.
	 * 
	 *  @return the immediate prefix.
	 *  @see #getCompoundKeyPrefixes()
	 */
	public CompoundKey getCompoundKeyPrefix() {
	}

	/**
	 *  Gets the prefix of the specified length. The length should be between 0 and the CompoundKey length.
	 * 
	 *  @param prefixLength the prefix length.
	 *  @return the prefix having the specified length.
	 *  @see #getCompoundKeyPrefixes()
	 */
	public CompoundKey getCompoundKeyPrefix(int prefixLength) {
	}

	public static void clearCache() {
	}

	public Values toValues() {
	}

	public Values toValues(int count, int summaryType) {
	}
}
