/**
 *  The package contains classes for JIDE Pivot Grid product.
 */
package com.jidesoft.pivot;


/**
 *  Default implementation of ExpandableValue interface. This is the main class used in HeaderTableModel to store the
 *  data.
 *  <p/>
 *  The equality of two <code>DefaultExpandableValue</code>s is depending on the actual value from {@link #getValue()}.
 *  To improve the performance, it also stores the hash code if PivotDataModel.isValueImmutable() return true. In the
 *  other word, if the value passed to DefaultExpandableValue(Object value) as parameter is immutable or you will make
 *  sure they are used as immutable even the value itself is mutable, we will cache the hash code. In Java, all primitive
 *  types and String are immutable so this will cover a large percentage of use cases.
 */
public class DefaultExpandableValue extends DefaultExpandable implements ExpandableValue {

	public DefaultExpandableValue(Object value) {
	}

	public Object getValue() {
	}

	public void setValue(Object value) {
	}

	@java.lang.Override
	public boolean equals(Object o) {
	}

	@java.lang.Override
	public int hashCode() {
	}

	@java.lang.Override
	public String toString() {
	}

	/**
	 *  Overrides this method to do a different calculation.
	 * 
	 *  @return the number of visible expandable.
	 */
	@java.lang.Override
	public int getNumberOfVisibleExpandable() {
	}

	@java.lang.Override
	public Object addChild(int index, Object child) {
	}

	@java.lang.Override
	public void addChildren(int index, java.util.List children) {
	}

	@java.lang.Override
	public void removeAllChildren() {
	}

	@java.lang.Override
	public boolean removeChild(Object child) {
	}

	/**
	 *  Gets the first descendant value at the specified level. If level is 0, the value of this DefaultExpandableValue
	 *  will be returned. If the level is 1, the value of the first child of this DefaultExpandableValue will be
	 *  returned. If level is 2, the value of the first child of the first child of the DefaultExpandableValue will be
	 *  returned, and so on. If the DefaultExpandableValue doesn't have that many levels or, it will return null.
	 * 
	 *  @param level the descendant level
	 *  @return the first descendant value at the specified level
	 */
	public Object getFirstDescendantValueAt(int level) {
	}
}
