/**
 *  The package contains classes for JIDE Pivot Grid product.
 */
package com.jidesoft.pivot;


/**
 *  Default implementation of SummaryCalculator. In this implementation, it calculates seven statistics - Sum, Min, Max,
 *  Mean, Var, StdDev, Count - for numbers (all classes extending Number and primitives) and BigDecimals; Max, Min, Count
 *  for String and only Count for all other data types.
 *  <p/>
 *  You can always add your own summary. For example, you want to add a new summary called "Last Value". Here is the
 *  sample code.
 *  <pre><code>
 *  pivotDataModel.setSummaryCalculator(new DefaultSummaryCalculator(){
 *      final int SUMMARY_LAST_VALUE = PivotConstants.SUMMARY_RESERVED_MAX + 1;
 *      private double _lastValue;
 *      public void addValue(Object v) {
 *          super.addValue(v);
 *          if (object instanceof Number) {
 *              _lastValue = ((Number) object).doubleValue();
 *           }
 *      }
 *  <p/>
 *      public void clear() {
 *          super.clear();
 *          _lastValue = 0;
 *      }
 *  <p/>
 *      public int getNumberOfSummaries() {
 *          return super.getNumberOfSummaries() + 1;
 *      }
 *  <p/>
 *      public String getSummaryName(int type) {
 *          if(type == SUMMARY_LAST_VALUE) {
 *             return "Last Value";
 *          }
 *          return super.getSummaryName(type);
 *      }
 *  <p/>
 *      public Object getSummaryResult(int type) {
 *          if(type == SUMMARY_LAST_VALUE) {
 *              return new Double(_lastValue);
 *          }
 *          return super.getSummaryResult(type);
 *      }
 *  });
 *  </code></pre>
 *  In the example, we use the {@link DefaultPivotSummaryCalculator} because we just need to add one more summary. If you
 *  want to provide your own way to calculate the summaries, you can implement {@link PivotSummaryCalculator} interface
 *  directly.
 *  <p/>
 *  <code>DefaultSummaryCalculator</code> has built-in support for Numbers, BigDecimals, Dates/Calendars and Booleans. If
 *  you need to calculate other data types, you can create your own <code>SummaryCalculator</code> extending
 *  <code>DefaultSummaryCalculator</code>.
 */
public class DefaultPivotSummaryCalculator extends DefaultSummaryCalculator implements PivotSummaryCalculator {

	public DefaultPivotSummaryCalculator() {
	}

	/**
	 *  Adds a value for calculation. Different from {@link #addValue(Object)} which only takes the value as parameter,
	 *  this method provides PivotDataModel, PivotField and row/column index of the cell as in the DataTableModel.
	 * 
	 *  @param dataModel   the PivotDataModel
	 *  @param field       the PivotField
	 *  @param rowIndex    the row index as in the PivotDataModel#getDataTableModel. It could be -1 if the row index is
	 *                     not available.
	 *  @param columnIndex the column index as in the PivotDataModel#getDataTableModel. It could be -1 if the column
	 *                     index is not available.
	 *  @param value       the value
	 *  @deprecated replaced by {@link #addValue(PivotValueProvider, PivotField, Values, Values, Object)}
	 */
	@java.lang.Deprecated
	public void addValue(IPivotDataModel dataModel, PivotField field, int rowIndex, int columnIndex, Object value) {
	}

	/**
	 *  Adds a value for calculation..
	 * 
	 *  @param valueProvider the PivotValueProvider
	 *  @param field         the PivotField
	 *  @param value         the value
	 *  @deprecated replaced by {@link #addValue(PivotValueProvider, PivotField, Values, Values, Object)}
	 */
	@java.lang.Deprecated
	public void addValue(PivotValueProvider valueProvider, PivotField field, Object value) {
	}

	@java.lang.Override
	public void addValue(PivotValueProvider dataModel, PivotField field, Values rowValues, Values columnValues, Object object) {
	}
}
