/**
 *  The package contains classes for JIDE Pivot Grid product.
 */
package com.jidesoft.pivot;


/**
 *  Default implementation of Values interface.
 *  <p/>
 *  The equality of two <code>DefaultValues</code>'s is depending on the actual equality from the Value inside it.
 *  <p/>
 *  If you extend a new Values class from DefaultValues, you need override {@link SortableAggregateTableModel#compare(int,
 *  int, int)} to make sure your new value type will present in right position while sorting together with other type of
 *  values.
 */
public class DefaultValues implements Values {

	/**
	 *  Creates <code>DefaultValues</code> from <code>ExpandableValue</code>. <code>ExpandableValue</code> can have
	 *  parent so this constructor will find all its ancestors and create the DefaultValues until the parent is null.
	 * 
	 *  @param value a ExpandableValue
	 */
	public DefaultValues(ExpandableValue value) {
	}

	/**
	 *  Creates <code>DefaultValues</code> from an array of <code>Value</code>s. Sometimes it is difficult to create or
	 *  access the ExpandableValue and use the {@link #DefaultValues(ExpandableValue)}. So we introduces this constructor
	 *  to make it possible to create a DefaultValues if you have all the Values.
	 * 
	 *  @param values an array of <code>Value</code>s.
	 */
	public DefaultValues(Value[] values) {
	}

	/**
	 *  Creates <code>DefaultValues</code> from an array of <code>Value</code>s. Sometimes it is difficult to create or
	 *  access the ExpandableValue and use the {@link #DefaultValues(ExpandableValue)}. So we introduces this constructor
	 *  to make it possible to create a DefaultValues if you have all the Values.
	 * 
	 *  @param values a list of <code>Value</code>s.
	 */
	public DefaultValues(java.util.List values) {
	}

	/**
	 *  Creates <code>DefaultValues</code> from an array of <code>Value</code>s. Sometimes it is difficult to create or
	 *  access the ExpandableValue and use the {@link #DefaultValues(ExpandableValue)}. So we introduces this constructor
	 *  to make it possible to create a DefaultValues if you only know the actual values.
	 * 
	 *  @param values an array of Values.
	 */
	public DefaultValues(Object[] values) {
	}

	public Value getValueAt(int index) {
	}

	public int getCount() {
	}

	@java.lang.Override
	public boolean equals(Object o) {
	}

	@java.lang.Override
	public int hashCode() {
	}

	/**
	 *  Creates a CompoundKey from this DefaultValues. The keys in the CompoundKeys are the actual values from the
	 *  DefaultValues.
	 * 
	 *  @return a CompoundKey.
	 */
	public CompoundKey toCompoundKey() {
	}

	@java.lang.Override
	public String toString() {
	}
}
