/**
 *  The package contains classes for JIDE Pivot Grid product.
 */
package com.jidesoft.pivot;


/**
 *  The component that represents a field in pivot table.
 */
public class FieldBox extends HeaderBox implements java.beans.PropertyChangeListener {

	public static final String PROPERTY_SORT_ARROW_VISIBLE = "sortArrowVisible";

	public static final String PROPERTY_FILTER_BUTTON_VISIBLE = "filterButtonVisible";

	public static final String PROPERTY_ASCENDING = "ascending";

	public static final String PROPERTY_SORT_ORDER = "sortOrder";

	public static final String PROPERTY_SORT_BY = "sortBy";

	public static final String PROPERTY_SORT_BY_ROW = "sortByRow";

	public static final String PROPERTY_POSSIBLE_VALUES = "possibleValues";

	public static final String PROPERTY_SELECTED_POSSIBLE_VALUES = "selectedPossibleValues";

	public static final String PROPERTY_FILTER = "filter";

	protected Object HIDE_POPUP_KEY;

	/**
	 *  Creates a button with no set text or icon.
	 */
	public FieldBox() {
	}

	public FieldBox(PivotField field) {
	}

	public FieldBox(PivotField field, String title) {
	}

	public FieldBox(PivotField field, javax.swing.Icon icon) {
	}

	public FieldBox(PivotField field, String title, javax.swing.Icon icon) {
	}

	public FieldBox(PivotField field, boolean sortArrowVisible, boolean filterButtonVisible) {
	}

	public FieldBox(PivotField field, String title, javax.swing.Icon icon, boolean sortArrowVisible, boolean filterButtonVisible) {
	}

	public FieldBox(PivotField field, String title, javax.swing.Icon icon, String description, boolean sortArrowVisible, boolean filterButtonVisible) {
	}

	protected void initComponents(PivotField field, String text, javax.swing.Icon icon, String description, boolean sortArrowVisible, boolean filterButtonVisible) {
	}

	protected void installListeners() {
	}

	public void propertyChange(java.beans.PropertyChangeEvent evt) {
	}

	/**
	 *  Add a <code>DynamicTableFilter</code>. <code>DynamicTableFilter</code> allows to add your own customize filter to
	 *  the drop down filter list. Any <code>DynamicTableFilter</code> will become an entry in the list. If user clicks
	 *  on that entry, the filter will be used to filter the column. What's special about <code>DynamicTableFilter</code>
	 *  is it allows to to create a filter on fly. For example, in initializeFilter method of DynamicTableFilter, you can
	 *  pop up a dialog to allow user to select certain information and you return a filter based on user selection.
	 * 
	 *  @param filter a <code>DynamicTableFilter</code>.
	 */
	public void addDynamicTableFilter(DynamicTableFilter filter) {
	}

	/**
	 *  Removes a <code>DynamicTableFilter</code> which was added earlier.
	 * 
	 *  @param filter a <code>DynamicTableFilter</code>.
	 */
	public void removeDynamicTableFilter(DynamicTableFilter filter) {
	}

	/**
	 *  Gets all the <code>DynamicTableFilter</code>s.
	 * 
	 *  @return an array of <code>DynamicTableFilter</code>s.
	 */
	public DynamicTableFilter[] getDynamicTableFilters() {
	}

	public void updateFilterIcon() {
	}

	protected void uninstallListeners() {
	}

	public boolean isSortArrowVisible() {
	}

	public void setSortArrowVisible(boolean sortArrowVisible) {
	}

	/**
	 *  Gets the filter button visible flag.
	 * 
	 *  @return true if the filter button should be visible always or on mouse over. Otherwise false.
	 */
	public boolean isFilterButtonVisible() {
	}

	/**
	 *  Sets the filter button visible flag.
	 *  <p/>
	 *  If {@link com.jidesoft.pivot.PivotTablePane#isShowFilterButtonsOnMouseOver()} returns false, this flag itself
	 *  controls the visibility of the filter button. However, if {@link com.jidesoft.pivot.PivotTablePane#isShowFilterButtonsOnMouseOver()}
	 *  returns true, this flag just means that if the filter button could be visible when the mouse is over the FieldBox.
	 * 
	 *  @param filterButtonVisible the flag
	 *  @see PivotTablePane#isShowFilterButtonsOnMouseOver()
	 */
	public void setFilterButtonVisible(boolean filterButtonVisible) {
	}

	public void setTitle(String title) {
	}

	@java.lang.Override
	public void setIcon(javax.swing.Icon icon) {
	}

	@java.lang.Override
	public void setFont(java.awt.Font font) {
	}

	public boolean isAscending() {
	}

	public void toggleAscending() {
	}

	public void setAscending(boolean ascending) {
	}

	public Object[] getPossibleValues() {
	}

	public void setPossibleValues(Object[] possibleValues) {
	}

	public void setSelectedPossibleValues(Object[] selectedPossibleValues) {
	}

	public void setFilter(Filter filter) {
	}

	public Object[] getSelectedPossibleValues() {
	}

	public Filter getFilter() {
	}

	/**
	 *  Creates the default combobox button. This method is used only if createButtonComponent() returns null. The idea
	 *  is each combobox can implement createButtonComponent() to provide its own button. However the default
	 *  implementation should still be the button created by this method.
	 * 
	 *  @return the default combobox button.
	 */
	protected javax.swing.AbstractButton createDefaultButton() {
	}

	/**
	 *  Creates the popup window. By default it will create a JidePopup which is not detached and not resizable. Subclass
	 *  can override it to create your own JidePopup or customize the default one.
	 * 
	 *  @return the popup window.
	 */
	protected JidePopup createPopupWindow() {
	}

	protected PopupPanel createPopupPanel(PivotTablePane pivotTablePane, PivotField field, Object[] possibleValues) {
	}

	/**
	 *  Creates the CustomFilterEditor used in the FieldBox's custom filter drop down list.
	 * 
	 *  @param filterFactoryManager the FilterFactoryManager.
	 *  @param type                 the type.
	 *  @param converterContext     the ConverterContext.
	 *  @param possibleValues       the possible values.
	 *  @return a new instance of CustomFilterEditor.
	 */
	protected CustomFilterEditor createCustomFilterEditor(FilterFactoryManager filterFactoryManager, Class type, ConverterContext converterContext, Object[] possibleValues) {
	}

	protected void customizePopupWindow(JidePopup popup, PopupPanel popupPanel) {
	}

	/**
	 *  calculate the popup location.
	 * 
	 *  @param popupPanel the PopupPanel
	 *  @return the location of popup.
	 */
	protected java.awt.Point calculatePopupLocation(PopupPanel popupPanel) {
	}

	/**
	 *  Causes the combo box to close its popup window.
	 */
	public void hidePopup() {
	}

	/**
	 *  Determines the visibility of the popup.
	 * 
	 *  @return true if the popup is visible, otherwise returns false
	 */
	public boolean isPopupVisible() {
	}

	public PivotField getField() {
	}

	public PivotTablePane getPivotTablePane() {
	}

	public void setPivotTablePane(PivotTablePane pivotTablePane) {
	}

	@java.lang.Override
	public java.awt.Dimension getPreferredSize() {
	}

	public java.awt.Dimension getActualPreferredSize() {
	}

	@java.lang.Override
	public void updateUI() {
	}

	public class ArrowIcon {


		public FieldBox.ArrowIcon(int direction) {
		}

		public int getIconWidth() {
		}

		public int getIconHeight() {
		}

		public synchronized void paintIcon(java.awt.Component c, java.awt.Graphics g, int x, int y) {
		}
	}
}
