/**
 *  The package contains classes for JIDE Pivot Grid product.
 */
package com.jidesoft.pivot;


/**
 *  This is a FilterableTableModel designed to wrap AggregateTableModel. This is a subclass of {@link
 *  com.jidesoft.grid.FilterableTableModel}. With this class, you can designate which level of values you want to keep
 *  anyway. By default, your filter will just work on standard rows and keep grand total values and summary values. In
 *  another scenario, you can change the configuration to filter on summary values only and keep all its "child" standard
 *  rows.
 * 
 *  @see #setFilterTarget(int)
 *  @see #FILTER_TARGET_ON_STANDARD_ROWS
 *  @see #FILTER_TARGET_ON_SUMMARY_ROWS
 */
public class FilterableAggregateTableModel extends FilterableTableModel {

	/**
	 *  Only filter on standard rows. Keep summary rows and grand total rows anyway.
	 */
	public static final int FILTER_TARGET_ON_STANDARD_ROWS = 0;

	/**
	 *  Only filter on summary rows. Keep grand total rows anyway. Only the "child" rows of the kept summary rows will be
	 *  kept.
	 */
	public static final int FILTER_TARGET_ON_SUMMARY_ROWS = 1;

	public FilterableAggregateTableModel(javax.swing.table.TableModel model) {
	}

	@java.lang.Override
	protected boolean shouldBeFiltered(int rowIndex) {
	}

	@java.lang.Override
	protected boolean shouldBeIgnored(ValueProvider valueProvider, int rowIndex) {
	}

	@java.lang.Override
	protected boolean shouldBeKept(ValueProvider valueProvider, int rowIndex, java.util.List remainingRows) {
	}

	/**
	 *  Get the configuration indicating the filter should apply on summary rows or standard rows.
	 *  <p/>
	 *  The default value is {@link #FILTER_TARGET_ON_STANDARD_ROWS}.
	 * 
	 *  @return the configuration.
	 */
	public int getFilterTarget() {
	}

	/**
	 *  Set the configuration indicating the filter should apply on summary rows or standard rows.
	 * 
	 *  @param filterTarget the configuration
	 */
	public void setFilterTarget(int filterTarget) {
	}
}
