/**
 *  The package contains classes for JIDE Pivot Grid product.
 */
package com.jidesoft.pivot;


/**
 *  The table used by the PivotTablePane in the row header area or column header area.
 *  <p/>
 *  To set tool tip text for the cells in the header table, please get its actual renderer component and invoke
 *  setToolTipText for that component.
 */
public class HeaderTable extends CategorizedTable implements java.beans.PropertyChangeListener {

	public static final String PROPERTY_DOUBLE_CLICK_ENABLED = "doubleClickEnabled";

	public HeaderTable(PivotTablePane pivotTablePane) {
	}

	public HeaderTable(PivotTablePane pivotTablePane, javax.swing.table.TableModel dm) {
	}

	@java.lang.Override
	public void addColumn(javax.swing.table.TableColumn column) {
	}

	@java.lang.Override
	public void tableChanged(javax.swing.event.TableModelEvent e) {
	}

	@java.lang.Override
	public java.awt.Dimension getPreferredScrollableViewportSize() {
	}

	@java.lang.Override
	public void valueChanged(TableSelectionEvent e) {
	}

	public void propertyChange(java.beans.PropertyChangeEvent evt) {
	}

	/**
	 *  Creates the special cell renderer for the first column which paints +/- icon and tree line.
	 * 
	 *  @return an instance of TreeTableCellRenderer. The same instance will be used to paint the cell of all rows in
	 *  TreeTable.
	 */
	protected javax.swing.table.TableCellRenderer createCellRenderer() {
	}

	/**
	 *  Creates the mouse listener used to handle mouse click on +/- icon.
	 * 
	 *  @return a mouse listener.
	 */
	protected HeaderTable.ExpandMouseListener createExpandMouseListener() {
	}

	/**
	 *  Creates the mouse listener used to handle mouse click on +/- icon.
	 * 
	 *  @param listener old listener
	 *  @return a mouse listener.
	 */
	protected javax.swing.event.MouseInputListener createExpandMouseInputListener(javax.swing.event.MouseInputListener listener) {
	}

	/**
	 *  Checks if the +/- icon should visible for the node.
	 * 
	 *  @param node the node.
	 *  @return true or false.
	 */
	public boolean isExpandIconVisible(Node node) {
	}

	/**
	 *  Handles the mouse press event. It does three things. If single mouse clicks on the +/- icon will expand/collapse
	 *  the row. Otherwise, it will select the related rows or columns.
	 * 
	 *  @param e the MouseEvent.
	 */
	protected void handleMousePressedEvent(java.awt.event.MouseEvent e) {
	}

	/**
	 *  Checks if the click iis on an expand / collapse icon.
	 * 
	 *  @param p the mouse point
	 *  @return true if the click is on an expand / collapse icon. Otherwise false.
	 *  @since 3.2.4
	 */
	protected boolean isClickOnIcon(java.awt.Point p) {
	}

	/**
	 *  Handles the mouse drag event. it will select the related rows or columns.
	 * 
	 *  @param e          the MouseEvent.
	 *  @param startPoint the start point when the mouse was pressed.
	 */
	protected void handleMouseDraggedEvent(java.awt.event.MouseEvent e, java.awt.Point startPoint) {
	}

	/**
	 *  Converts the Values to string to show in the context menu.
	 * 
	 *  @param values      the Values instance
	 *  @param isRowHeader the flag indicating that the values is row values or column values
	 *  @return the converted string. Empty string if its not a valid value.
	 *  @since 3.3.3
	 */
	protected String convertValuesToString(Values values, boolean isRowHeader) {
	}

	/**
	 *  Creates context menu for specific row/column in the header table.
	 * 
	 *  @param rowIndex    the row index
	 *  @param columnIndex the column index
	 *  @return the context menu to be displayed for the cell.
	 */
	protected javax.swing.JPopupMenu createContextMenu(int rowIndex, int columnIndex) {
	}

	public void expandAll() {
	}

	public void collapseAll() {
	}

	@java.lang.Override
	public javax.swing.table.TableCellRenderer getCellRenderer(int rowIndex, int columnIndex) {
	}

	@java.lang.Override
	protected void collectCellStyles(int row, int column) {
	}

	@java.lang.Override
	public boolean isCellSelected(int row, int column) {
	}

	@java.lang.Override
	public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
	}

	@java.lang.Override
	public void updateUI() {
	}

	public PivotTablePane getPivotTablePane() {
	}

	public Expandable getExpandableAt(int rowIndex, int columnIndex) {
	}

	public HeaderTableModel getHeaderTableModel() {
	}

	@java.lang.Override
	public boolean editCellAt(int row, int column, java.util.EventObject o) {
	}

	@java.lang.Override
	public Object getValueAt(int row, int column) {
	}

	@java.lang.Override
	public boolean needAdjustCellValueString(int rowIndex, int columnIndex) {
	}

	/**
	 *  Gets the string value with summary name or the total/grand total. For example, if the stringValue parameter is
	 *  "Aug", this method will return "Aug Sum" if the cell is a subtotal row/column of "Sum". If the cell is a grand
	 *  total row or column, this method will return "Grand Total" which is defined in pivot.properties.
	 * 
	 *  @param rowIndex    the row index of the cell
	 *  @param columnIndex the column index of the cell
	 *  @param converter   the cell value converter if applicable. null if you are not invoking this method for exporting
	 *                     to excel purpose.
	 *  @return the string including the summary, total or grand total.
	 */
	public String getValueAtInString(int rowIndex, int columnIndex, ValueConverter converter) {
	}

	/**
	 *  Gets the title for the running summary type
	 * 
	 *  @param value       the RunningSummaryValue
	 *  @param stringValue the original title
	 *  @return the formatted string to show running summary.
	 *  @since 3.3.2
	 */
	protected String getRunningSummaryTitle(RunningSummaryValue value, String stringValue) {
	}

	/**
	 *  Gets the flag indicating if context menu should be displayed on right click.
	 * 
	 *  @return true if the context menu should be displayed. Otherwise false.
	 *  @see #setShowContextMenu(boolean)
	 *  @since 3.2.1
	 */
	public boolean isShowContextMenu() {
	}

	/**
	 *  Sets the flag indicating if context menu should be displayed on right click.
	 *  <p/>
	 *  By default, the flag is true. However, if you want to add an additional mouse listener to do something else, you
	 *  might have to set this flag to false to make your listener get mouse event correctly.
	 * 
	 *  @param showContextMenu the flag
	 *  @since 3.2.1
	 */
	public void setShowContextMenu(boolean showContextMenu) {
	}

	/**
	 *  Gets the flag indicating if the AggregateTable should use native renderer to paint its aggregated cells.
	 * 
	 *  @return true if native renderer should be used. Otherwise false.
	 *  @since 3.5.12
	 */
	public boolean isUseNativeRenderer() {
	}

	/**
	 *  Sets the flag indicating if the AggregateTable should use native renderer to paint its aggregated cells.
	 * 
	 *  @param useNativeRenderer the flag
	 *  @since 3.5.12
	 */
	public void setUseNativeRenderer(boolean useNativeRenderer) {
	}

	protected class ExpandMouseListener {


		protected HeaderTable.ExpandMouseListener() {
		}

		public void mousePressed(java.awt.event.MouseEvent e) {
		}

		public void mouseReleased(java.awt.event.MouseEvent e) {
		}

		public void mouseDragged(java.awt.event.MouseEvent e) {
		}

		public void mouseClicked(java.awt.event.MouseEvent e) {
		}

		public void mouseEntered(java.awt.event.MouseEvent e) {
		}

		public void mouseExited(java.awt.event.MouseEvent e) {
		}

		public void mouseMoved(java.awt.event.MouseEvent e) {
		}
	}

	protected class DelegateExpandMouseInputListener {


		public HeaderTable.DelegateExpandMouseInputListener(javax.swing.event.MouseInputListener listener) {
		}

		@java.lang.Override
		public void mousePressed(java.awt.event.MouseEvent e) {
		}

		@java.lang.Override
		public void mouseReleased(java.awt.event.MouseEvent e) {
		}

		@java.lang.Override
		public void mouseDragged(java.awt.event.MouseEvent e) {
		}
	}
}
