/**
 *  The package contains classes for JIDE Pivot Grid product.
 */
package com.jidesoft.pivot;


/**
 *  TableModel for the row header and column header of the pivot table.
 */
public class HeaderTableModel extends javax.swing.table.AbstractTableModel implements PivotConstants {

	/**
	 *  @param pivotDataModel the PivotDataModel.
	 *  @param rows           the compound keys.
	 *  @param rowHeader      true if it is the row header. False if it is the column header.
	 */
	public HeaderTableModel(IPivotDataModel pivotDataModel, CompoundKey[] rows, boolean rowHeader) {
	}

	/**
	 *  Check if the refresh process should be optimized.
	 *  <p/>
	 *  The default implementation is check if changed compound key count is not more than 10.
	 * 
	 *  @param changedKeyCount changed CompoundKey counts
	 *  @param totalKeyCount   the total CompoundKey counts
	 *  @return true if the process should be optimized. Otherwise false.
	 */
	protected boolean shouldOptimize(int changedKeyCount, int totalKeyCount) {
	}

	protected void setRows(CompoundKey[] rows) {
	}

	protected CompoundKey[] filterRows(CompoundKey[] originalRows) {
	}

	protected CompoundKey[] filterRows(PivotField dataField, CompoundKey[] originalRows) {
	}

	protected int getNumberOfDataFields() {
	}

	/**
	 *  Refresh the header table model after updating expandable.
	 *  <p/>
	 *  By default, this method will recreate the table model and fire table data change or structure change event
	 *  according to the scope which was impacted.
	 *  <p/>
	 *  This is a single point method for any kind of collapse/expand, which means, you could override this method to
	 *  customize your behavior upon expanding/collapsing. When this method is invoked, all expandable have been
	 *  updated.
	 * 
	 *  @param oldColumnCount the column count before updating
	 */
	public void refreshAfterUpdateExpandable(int oldColumnCount) {
	}

	/**
	 *  Update the value's expandable status.
	 *  <p/>
	 *  This is a single point method for any kind of collapse/expand, which means, you could override this method to
	 *  customize your behavior upon expanding/collapsing. Comparing to {@link #refreshAfterUpdateExpandable(int)}, when
	 *  this method is invoked, the expandable has not been updated. However, this method could be invoked many times if
	 *  collapseAll() or expandAll() is invoked.
	 * 
	 *  @param value    the expandable value
	 *  @param expanded the new expanded status
	 */
	protected void setValueExpanded(Expandable value, boolean expanded) {
	}

	public void fireTableStructureChanged() {
	}

	/**
	 *  Creates the List used internally. By default, we created {@link com.jidesoft.utils.CachedArrayList} instance so
	 *  that we get a faster indexOf performance.
	 * 
	 *  @return a List.
	 */
	protected java.util.List createList() {
	}

	/**
	 *  Checks if the table model is for row header.
	 * 
	 *  @return true if the table model is for row header.
	 */
	public boolean isRowHeader() {
	}

	/**
	 *  Gets the row count.
	 * 
	 *  @return the row count.
	 */
	public int getRowCount() {
	}

	public Object getColumnIdentifier(int column) {
	}

	@java.lang.Override
	public String getColumnName(int column) {
	}

	/**
	 *  Gets the column count.
	 * 
	 *  @return the column count.
	 */
	public int getColumnCount() {
	}

	/**
	 *  Returns the Values at the row specified by <code>row</code>.
	 * 
	 *  @param index the row whose row is to be queried
	 *  @return the row at the specified row index
	 */
	public Values getValuesAt(int index) {
	}

	public Object[] getKeyValuesAt(int index) {
	}

	/**
	 *  Returns the value for the cell at <code>columnIndex</code> and <code>rowIndex</code>.
	 * 
	 *  @param rowIndex    the row whose value is to be queried
	 *  @param columnIndex the column whose value is to be queried
	 *  @return the value Object at the specified cell
	 */
	public Object getValueAt(int rowIndex, int columnIndex) {
	}

	public synchronized Class getRowValueClass(int rowIndex) {
	}

	public int getSummaryType(int rowIndex) {
	}

	public int getSummaryColumn(int rowIndex) {
	}

	/**
	 *  Gets the Expandable object at specified row index and column index.
	 * 
	 *  @param rowIndex    the row index of the cell.
	 *  @param columnIndex the column index of the cell
	 *  @return expandable.
	 */
	public Expandable getExpandable(int rowIndex, int columnIndex) {
	}

	public CellSpan getCellSpanAt(int rowIndex, int columnIndex) {
	}

	/**
	 *  Sets the cell span on or off.
	 * 
	 *  @param cellSpanOn true or false.
	 */
	public void setCellSpanOn(boolean cellSpanOn) {
	}

	/**
	 *  Checks if the cell span is on for this table model.
	 * 
	 *  @return true or false.
	 */
	public boolean isCellSpanOn() {
	}

	/**
	 *  Gets the pivot field associated with the cell.
	 * 
	 *  @param rowIndex    the row index
	 *  @param columnIndex the column index
	 *  @return the pivot field associated with the cell.
	 */
	public PivotField getFieldAt(int rowIndex, int columnIndex) {
	}

	public ConverterContext getConverterContextAt(int row, int column) {
	}

	public EditorContext getEditorContextAt(int row, int column) {
	}

	public Class getCellClassAt(int row, int column) {
	}

	/**
	 *  Checks if the cell at the specified row and column index is expandable.
	 * 
	 *  @param rowIndex    the row index of the cell
	 *  @param columnIndex the column index of the cell
	 *  @return true or false.
	 */
	public boolean isExpandable(int rowIndex, int columnIndex) {
	}

	/**
	 *  Checks if the cell at the specified row and column index is expanded. It will return true only when it has
	 *  children and expanded. If it doesn't have children, it will return false.
	 * 
	 *  @param rowIndex    the row index.
	 *  @param columnIndex the column index.
	 *  @return true or false.
	 */
	public boolean isExpanded(int rowIndex, int columnIndex) {
	}

	/**
	 *  Checks if the cell at the specified row and column index is collapsed. It will return true only when it has
	 *  children and not expanded. If it doesn't have children, it will return false.
	 * 
	 *  @param rowIndex    the row index.
	 *  @param columnIndex the column index.
	 *  @return true or false.
	 */
	public boolean isCollapsed(int rowIndex, int columnIndex) {
	}

	/**
	 *  Expands the cell at the specified row and column index is expandable.
	 * 
	 *  @param rowIndex    the row index.
	 *  @param columnIndex the column index.
	 */
	public void expand(int rowIndex, int columnIndex) {
	}

	/**
	 *  Expands the whole column if if it is the row header or expands the whole row if it is the column header.
	 * 
	 *  @param index the row index if it is the column header or the column index if it is the row header.
	 */
	public void expand(int index) {
	}

	public void collapse(int index) {
	}

	/**
	 *  Collapses the cell at the specified row and column index is expandable.
	 * 
	 *  @param rowIndex    the row index.
	 *  @param columnIndex the column index.
	 */
	public void collapse(int rowIndex, int columnIndex) {
	}

	/**
	 *  Toggles the cell at the specified row and column index is expandable.
	 * 
	 *  @param rowIndex    the row index.
	 *  @param columnIndex the column index.
	 */
	public void toggle(int rowIndex, int columnIndex) {
	}

	/**
	 *  Expands all expandable cells.
	 */
	public void expandAll() {
	}

	/**
	 *  Expands all expandable level cells without touching those PivotFields in the array.
	 * 
	 *  @param noActionFieldIndices those fields that should not be collapsed
	 */
	public void expandAll(int[] noActionFieldIndices) {
	}

	/**
	 *  Collapses all expandable level cells.
	 */
	public void collapseAll() {
	}

	/**
	 *  Collapses all expandable level cells without touching those PivotFields in the array.
	 * 
	 *  @param noActionFieldIndices those fields that should not be collapsed
	 */
	public void collapseAll(int[] noActionFieldIndices) {
	}

	/**
	 *  Should date fields added to this field table model.
	 * 
	 *  @return true or false.
	 */
	protected boolean isDataFieldAdded() {
	}

	public boolean isDataCell(int rowIndex, int columnIndex) {
	}

	/**
	 *  Gets the cell style at the specified cell. This method is final. Please use {@link
	 *  PivotDataModel#setCellStyleProvider(PivotCellStyleProvider)} to provide cell style for HeaderTable.
	 * 
	 *  @param rowIndex    the row index.
	 *  @param columnIndex the column index.
	 *  @return the cell style at the specified cell.
	 */
	public final CellStyle getCellStyleAt(int rowIndex, int columnIndex) {
	}

	public final boolean isCellStyleOn() {
	}

	/**
	 *  Checks if the row or column at the index is a running summary row or column.
	 * 
	 *  @param index the row index if the HeaderTableModel is used in row header of the pivot table. If the
	 *               HeaderTableModel is used as column header, the rowIndex should be the column index.
	 *  @return true if the row or column at the index is a sub total row or column.
	 */
	public boolean isRunningSummaryRowOrColumn(int index) {
	}

	/**
	 *  Checks if the row or column at the index is a sub total row or column.
	 * 
	 *  @param index the row index if the HeaderTableModel is used in row header of the pivot table. If the
	 *               HeaderTableModel is used as column header, the rowIndex should be the column index.
	 *  @return true if the row or column at the index is a sub total row or column.
	 */
	public boolean isSubtotalRowOrColumn(int index) {
	}

	/**
	 *  Checks if the row or column at the index is a grand total row or column.
	 * 
	 *  @param index the row index if the HeaderTableModel is used in row header of the pivot table. If the
	 *               HeaderTableModel is used as column header, the rowIndex should be the column index.
	 *  @return true if the row or column at the index is a grant total row or column.
	 */
	public boolean isGrandTotalRowOrColumn(int index) {
	}

	/**
	 *  Gets the pivot data model.
	 * 
	 *  @return the pivot data model.
	 */
	public IPivotDataModel getPivotDataModel() {
	}

	@java.lang.Override
	public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
	}

	@java.lang.Override
	public boolean isCellEditable(int rowIndex, int columnIndex) {
	}

	/**
	 *  Index of the Objects in the HeaderTableModel. In the case of row HeaderTableModel, the index will be the row
	 *  index. In the case of column HeaderTableModel, the index will be the column index.
	 * 
	 *  @param keys the Objects array
	 *  @return the index.
	 */
	public int indexOf(Object[] keys) {
	}

	/**
	 *  Gets the string value with summary name or the total/grand total. For example, if the stringValue parameter is
	 *  "Aug", this method will return "Aug Sum" if the cell is a subtotal row/column of "Sum". If the cell is a grand
	 *  total row or column, this method will return "Grand Total" which is defined in pivot.properties.
	 *  <p/>
	 *  This method will invoke getValueAt first to get the value, then invoke {@link #getValueAtInString(PivotTablePane,
	 *  Object, int, int)}
	 * 
	 *  @param pane        the PivotTablePane
	 *  @param rowIndex    the row index of the cell
	 *  @param columnIndex the column index of the cell
	 *  @return the string including the summary, total or grand total.
	 *  @deprecated replaced by {@link HeaderTable#getValueAtInString(int, int, com.jidesoft.hssf.HssfTableUtils.CellValueConverter)}
	 *  in PivotTablePane scenario or {@link com.jidesoft.pivot.AggregateTable#getValueAtInString(int, int,
	 *  com.jidesoft.grid.ValueConverter)}  in AggregateTable scenario.
	 */
	@java.lang.Deprecated
	public String getValueAtInString(PivotTablePane pane, int rowIndex, int columnIndex) {
	}

	/**
	 *  Gets the string value with summary name or the total/grand total. For example, if the stringValue parameter is
	 *  "Aug", this method will return "Aug Sum" if the cell is a subtotal row/column of "Sum". If the cell is a grand
	 *  total row or column, this method will return "Grand Total" which is defined in pivot.properties.
	 *  <p/>
	 *  This method will invoke getValueAt first to get the value, then invoke {@link #getValueAtInString(PivotTablePane,
	 *  Object, int, int)}
	 * 
	 *  @param locale      the locale to get the correct string.
	 *  @param rowIndex    the row index of the cell
	 *  @param columnIndex the column index of the cell
	 *  @return the string including the summary, total or grand total.
	 *  @deprecated replaced by {@link HeaderTable#getValueAtInString(int, int, com.jidesoft.hssf.HssfTableUtils.CellValueConverter)}
	 *  in PivotTablePane scenario or {@link com.jidesoft.pivot.AggregateTable#getValueAtInString(int, int,
	 *  com.jidesoft.grid.ValueConverter)}  in AggregateTable scenario.
	 */
	@java.lang.Deprecated
	public String getValueAtInString(java.util.Locale locale, int rowIndex, int columnIndex) {
	}

	/**
	 *  Gets the string value with summary name or the total/grand total. For example, if the stringValue parameter is
	 *  "Aug", this method will return "Aug Sum" if the cell is a subtotal row/column of "Sum". If the cell is a grand
	 *  total row or column, this method will return "Grand Total" which is defined in pivot.properties.
	 * 
	 *  @param pane        the PivotTablePane
	 *  @param value       the value
	 *  @param rowIndex    the row index of the cell
	 *  @param columnIndex the column index of the cell
	 *  @return the string including the summary, total or grand total.
	 *  @deprecated replaced by {@link HeaderTable#getValueAtInString(int, int, com.jidesoft.hssf.HssfTableUtils.CellValueConverter)}
	 *  in PivotTablePane scenario or {@link com.jidesoft.pivot.AggregateTable#getValueAtInString(int, int,
	 *  com.jidesoft.grid.ValueConverter)}  in AggregateTable scenario.
	 */
	@java.lang.Deprecated
	public String getValueAtInString(PivotTablePane pane, Object value, int rowIndex, int columnIndex) {
	}

	/**
	 *  Gets the string value with summary name or the total/grand total. For example, if the stringValue parameter is
	 *  "Aug", this method will return "Aug Sum" if the cell is a subtotal row/column of "Sum". If the cell is a grand
	 *  total row or column, this method will return "Grand Total" which is defined in pivot.properties.
	 * 
	 *  @param locale      the locale to get the correct string.
	 *  @param value       the value
	 *  @param rowIndex    the row index of the cell
	 *  @param columnIndex the column index of the cell
	 *  @return the string including the summary, total or grand total.
	 *  @deprecated replaced by {@link HeaderTable#getValueAtInString(int, int, com.jidesoft.hssf.HssfTableUtils.CellValueConverter)}
	 *  in PivotTablePane scenario or {@link com.jidesoft.pivot.AggregateTable#getValueAtInString(int, int,
	 *  com.jidesoft.grid.ValueConverter)}  in AggregateTable scenario.
	 */
	@java.lang.Deprecated
	public String getValueAtInString(java.util.Locale locale, Object value, int rowIndex, int columnIndex) {
	}

	/**
	 *  Gets the expansion sate of the HeaderTableModel. You can call it to save it somewhere. After the header table is
	 *  changed (reloaded for example), you can call {@link #setExpansionState(java.util.Map)} to restore the expansion
	 *  state.
	 *  <p/>
	 *  In high performance mode, it will always return null to avoid going through the tree hierarchy.
	 * 
	 *  @return the expansion state in a map.
	 */
	public java.util.Map getExpansionState() {
	}

	/**
	 *  Sets the expansion state.
	 * 
	 *  @param expandedMap the expansion state.
	 */
	public void setExpansionState(java.util.Map expandedMap) {
	}
}
