/**
 *  The package contains classes for JIDE Pivot Grid product.
 */
package com.jidesoft.pivot;


/**
 *  PivotCellStyleProvider is an interface to allow user to customize the CellStyle
 *  for the data table, the row header table and the column header table in the pivot table.
 */
public interface PivotCellStyleProvider {

	/**
	 *  Gets the CellStyle for the row header table cells.
	 * 
	 *  @param model       the HeaderTableModel which is used by the row header table.
	 *  @param rowIndex    the row index
	 *  @param columnIndex the column index.
	 *  @return the CellStyle for the row header table cells.
	 */
	public CellStyle getRowHeaderCellStyleAt(HeaderTableModel model, int rowIndex, int columnIndex);

	/**
	 *  Gets the CellStyle for the column header table cells.
	 * 
	 *  @param model       the HeaderTableModel which is used by the column header table.
	 *  @param rowIndex    the row index
	 *  @param columnIndex the column index.
	 *  @return the CellStyle for the column header table cells.
	 */
	public CellStyle getColumnHeaderCellStyleAt(HeaderTableModel model, int rowIndex, int columnIndex);

	/**
	 *  Gets the CellStyle for the data table in the pivot table.
	 * 
	 *  @param model             the DataTableModel which is used by the data table.
	 *  @param rowHeaderModel    the HeaderTableModel which is used by the row header table.
	 *  @param columnHeaderModel the HeaderTableModel which is used by the column header table.
	 *  @param rowIndex          the row index
	 *  @param columnIndex       the column index.
	 *  @return the CellStyle for the data table in the pivot table.
	 */
	public CellStyle getDataTableCellStyleAt(DataTableModel model, HeaderTableModel rowHeaderModel, HeaderTableModel columnHeaderModel, int rowIndex, int columnIndex);
}
