/**
 *  The package contains classes for JIDE Pivot Grid product.
 */
package com.jidesoft.pivot;


/**
 *  Constants used in pivot grid product.
 */
public interface PivotConstants {

	/**
	 *  A constant for the pivot field area for row fields. Used by {@link PivotField#setAreaType(int)}.
	 */
	public static final int AREA_ROW = 0;

	/**
	 *  A constant for the pivot field area for column fields. Used by {@link PivotField#setAreaType(int)}.
	 */
	public static final int AREA_COLUMN = 1;

	/**
	 *  A constant for the pivot field area for filter fields. Used by {@link PivotField#setAreaType(int)}.
	 */
	public static final int AREA_FILTER = 2;

	/**
	 *  A constant for the pivot field area for data fields. Used by {@link PivotField#setAreaType(int)}.
	 */
	public static final int AREA_DATA = 3;

	/**
	 *  A constant for the pivot field area for not assigned fields. Those fields will appear in the field chooser panel
	 *  only Used by {@link PivotField#setAreaType(int)}.
	 */
	public static final int AREA_NOT_ASSIGNED = -1;

	/**
	 *  All the field area names. The names are localized using Locale.getDefault() as the locale. If you want a
	 *  different locale, using {@link com.jidesoft.pivot.PivotTablePane#getAreaName(java.util.Locale, int)} instead.
	 */
	public static final String[] AREA_NAMES;

	/**
	 *  A constant for summary type. Used by {@link PivotField#setSummaryType(int)} and {@link
	 *  PivotField#setCustomSubtotals(int[])}.
	 */
	public static final int SUMMARY_NONE;

	/**
	 *  A constant for summary type. Used by {@link PivotField#setSummaryType(int)} and {@link
	 *  PivotField#setCustomSubtotals(int[])}.
	 */
	public static final int SUMMARY_CUSTOM;

	/**
	 *  A constant for summary type. Used by {@link PivotField#setSummaryType(int)} and {@link
	 *  PivotField#setCustomSubtotals(int[])}.
	 */
	public static final int SUMMARY_SUM;

	/**
	 *  A constant for summary type. Used by {@link PivotField#setSummaryType(int)} and {@link
	 *  PivotField#setCustomSubtotals(int[])}.
	 */
	public static final int SUMMARY_MAX;

	/**
	 *  A constant for summary type. Used by {@link PivotField#setSummaryType(int)} and {@link
	 *  PivotField#setCustomSubtotals(int[])}.
	 */
	public static final int SUMMARY_MIN;

	/**
	 *  A constant for summary type. Used by {@link PivotField#setSummaryType(int)} and {@link
	 *  PivotField#setCustomSubtotals(int[])}.
	 */
	public static final int SUMMARY_MEAN;

	/**
	 *  A constant for summary type. Used by {@link PivotField#setSummaryType(int)} and {@link
	 *  PivotField#setCustomSubtotals(int[])}.
	 */
	public static final int SUMMARY_VAR;

	/**
	 *  A constant for summary type. Used by {@link PivotField#setSummaryType(int)} and {@link
	 *  PivotField#setCustomSubtotals(int[])}.
	 */
	public static final int SUMMARY_STDDEV;

	/**
	 *  A constant for summary type. Used by {@link PivotField#setSummaryType(int)} and {@link
	 *  PivotField#setCustomSubtotals(int[])}.
	 */
	public static final int SUMMARY_COUNT;

	/**
	 *  A constant for summary type. Used by {@link PivotField#setSummaryType(int)} and {@link
	 *  PivotField#setCustomSubtotals(int[])}.
	 */
	public static final int SUMMARY_CONSTANT;

	/**
	 *  A constant for the maximum value of summary type. If you need to define your own summary statistics, you must
	 *  start your summary type value from from SUMMARY_RESERVED_MAX + 1, and continues with SUMMARY_RESERVED_MAX + 2,
	 *  SUMMARY_RESERVED_MAX + 3, etc. There should be no gap in between.
	 */
	public static final int SUMMARY_RESERVED_MAX;

	/**
	 *  A running type, which represents the difference between this value and the compared value.
	 */
	public static final int RUNNING_SUMMARY_DIFFERENCE = 0;

	/**
	 *  A running type, which represents the percentage of this value comparing to the compared value.
	 */
	public static final int RUNNING_SUMMARY_PERCENTAGE_OF = 1;

	/**
	 *  A running type, which represents the percentage from the compared value to this value.
	 */
	public static final int RUNNING_SUMMARY_PERCENTAGE_FROM = 2;

	/**
	 *  A running type, which represents the total summary from the beginning in the range to this value.
	 */
	public static final int RUNNING_SUMMARY_TOTAL = 3;

	/**
	 *  A running type, which represents the percentage of this value comparing to the summary within the range.
	 */
	public static final int RUNNING_SUMMARY_PERCENTAGE_TOTAL = 4;

	/**
	 *  Special PivotField instance to represent that the running summary will run through all the columns.
	 */
	public static final PivotField RANGE_IN_TOTAL;

	/**
	 *  An object to represent that the running summary would compare to the previous value.
	 */
	public static final Object COMPARE_TO_PREVIOUS;

	/**
	 *  An object to represent that the running summary would compare to the next value.
	 */
	public static final Object COMPARE_TO_NEXT;

	/**
	 *  All the summary type names. The names are localized using Locale.getDefault() as the locale. If you want a
	 *  different locale, using {@link com.jidesoft.pivot.PivotTablePane#getSummaryName(java.util.Locale, int)} instead.
	 */
	public static final String[] SUMMARY_NAMES;

	/**
	 *  A constant for subtotal type. Used by {@link PivotField#setSubtotalType(int)}.
	 */
	public static final int SUBTOTAL_NONE = 0;

	/**
	 *  A constant for subtotal type. Used by {@link PivotField#setSubtotalType(int)}. SUBTOTAL_AUTOMATIC means it will
	 *  use Sum to calculate the subtotal.
	 */
	public static final int SUBTOTAL_AUTOMATIC = 1;

	/**
	 *  A constant for subtotal type. Used by {@link PivotField#setSubtotalType(int)}. SUBTOTAL_CUSTOM means it will use
	 *  the value in {@link PivotField#setCustomSubtotals(int[])} to decide how to calculate the subtotals.
	 */
	public static final int SUBTOTAL_CUSTOM = 2;

	/**
	 *  A constant for statistics calculation type. This is the default calculation type which will calculate the
	 *  statistics based on the original values in the table model.
	 */
	public static final int STATISTICS_CALCULATION_DEFAULT = 0;

	/**
	 *  A constant for statistics calculation type. This is a calculation type which will calculation the statistics
	 *  based on the running values in the next level as displayed in the UI. If both keys are summary values, it will
	 *  calculate the value based on the values in the same row by default
	 */
	public static final int STATISTICS_CALCULATION_RUNNING = 1;

	/**
	 *  A constant for statistics calculation type. This is a calculation type which will calculation the statistics
	 *  based on the running values as displayed in the UI. It only applies to the scenario that both keys are summary
	 *  values, it will then calculate the value based on the values in the same column.
	 */
	public static final int STATISTICS_CALCULATION_RUNNING_IN_COLUMN = 2;

	/**
	 *  A constant for statistics calculation type. This is a calculation type which will calculation the statistics
	 *  based on the running values in the leaf level as displayed in the UI. If both keys are summary values, it will
	 *  calculate the value based on the values in the same row by default
	 * 
	 *  @since 3.4.4
	 */
	public static final int STATISTICS_CALCULATION_RUNNING_LEAF = 3;

	/**
	 *  A constant for header selection mode. In this mode, the header could be selected and if the header is clicked,
	 *  only the header cell is selected.
	 */
	public static final int HEADER_SELECTION_HEADER_TABLE_ONLY = 0;

	/**
	 *  A constant for header selection mode. In this mode, the header will not be selected and gain focus in any cases.
	 *  If the header is clicked, the corresponding row or column in the DataTable are selected.
	 */
	public static final int HEADER_SELECTION_DATA_TABLE_ONLY = 1;
}
