/**
 *  The package contains classes for JIDE Pivot Grid product.
 */
package com.jidesoft.pivot;


/**
 *  PivotCornerCellStyleProvider extends PivotCellStyleProvider and add getCornerCellStyleAt to provide cell style
 *  for corner table which is the table appears on the top-left corner. By default, this table is not used in PivotTablePane.
 */
public interface PivotCornerCellStyleProvider extends PivotCellStyleProvider {

	/**
	 *  Gets the CellStyle for the corner header cells.
	 * 
	 *  @param model       the HeaderTableModel which is used by the row header table.
	 *  @param rowIndex    the row index
	 *  @param columnIndex the column index.
	 *  @return the CellStyle for the row header table cells.
	 */
	public CellStyle getCornerCellStyleAt(CornerTableModel model, int rowIndex, int columnIndex);
}
