/**
 *  The package contains classes for JIDE Pivot Grid product.
 */
package com.jidesoft.pivot;


/**
 *  The model that contains the data for pivot table. It takes any table model as input. Then you can {@link
 *  #getField(String)} method to get the PivotField to specify different settings such as which ones are row fields,
 *  column fields, filter fields or data fields, do you want to calculate subtotals, the sort order. There are also a few
 *  settings on PivotDataModel itself such as grand total. Once you setup everything, you can call {@link #calculate()}
 *  to generate pivot data.
 */
public class PivotDataModel implements IPivotDataModel, PivotValueProvider {

	protected PivotDataSource _dataSource;

	protected javax.swing.event.EventListenerList listenerList;

	public static final String PROPERTY_SHOW_GRAND_TOTAL_FOR_ROW = "showGrandTotalForRow";

	public static final String PROPERTY_SHOW_GRAND_TOTAL_FOR_COLUMN = "showGrandTotalForColumn";

	public static final String PROPERTY_HIDE_REDUNDANT_SUBTOTAL = "hideRedundantSubtotal";

	public static final String PROPERTY_SHOW_SUBTOTAL_AS_CHILD = "showSubtotalAsChild";

	public static final String PROPERTY_HIDE_SINGLE_DATA_FIELD = "hideSingleDataField";

	public PivotDataModel() {
	}

	/**
	 *  Creates a PivotDataModel using table model as the data source.
	 * 
	 *  @param tableModel the table model.
	 */
	public PivotDataModel(javax.swing.table.TableModel tableModel) {
	}

	/**
	 *  Creates a PivotDataModel using PivotDataSource interface.
	 * 
	 *  @param dataSource the <code>PivotDataSource</code>.
	 */
	public PivotDataModel(PivotDataSource dataSource) {
	}

	protected PivotDataCube createPivotDataCube() {
	}

	/**
	 *  Initializes the PivotDataModel. Whenever your original table model structured changed (column added, removed or
	 *  changed), you need to call this method then {@link #calculate()}. If only the data is changed, just {@link
	 *  #calculate()} is enough.
	 */
	public void initialize() {
	}

	/**
	 *  Sets the original table model.
	 * 
	 *  @param tableModel the new original table model.
	 */
	public void setOriginalTableModel(javax.swing.table.TableModel tableModel) {
	}

	/**
	 *  Creates default PivotDataSource which is TableModelPivotDataSource.
	 * 
	 *  @param tableModel the table model.
	 *  @return TableModelPivotDataSource.
	 */
	protected TableModelPivotDataSource createDefaultPivotDataSource(javax.swing.table.TableModel tableModel) {
	}

	/**
	 *  Sets the data source.
	 * 
	 *  @param dataSource the new data source.
	 */
	public void setDataSource(PivotDataSource dataSource) {
	}

	@java.lang.SuppressWarnings("RedundantCast")
	protected boolean tableCellsUpdated(int column, int firstRow, int lastRow) {
	}

	protected boolean addRowIndex(CompoundKey rowKey, CompoundKey columnKey, int rowIndex) {
	}

	protected boolean addPrefixRowIndex(CompoundKey rowKey, CompoundKey columnKey, int rowIndex) {
	}

	@java.lang.SuppressWarnings("RedundantCast")
	protected boolean tableRowsUpdated(int firstRow, int lastRow) {
	}

	protected boolean tableRowsInserted(int firstRow, int lastRow) {
	}

	@java.lang.SuppressWarnings("RedundantCast")
	protected boolean tableRowsDeleted(int firstRow, int lastRow) {
	}

	/**
	 *  Creates the <code>PivotField</code>.
	 * 
	 *  @param dataSource  the data source.
	 *  @param columnIndex the column index.
	 *  @return the <code>PivotField</code>.
	 */
	protected PivotField createPivotField(PivotDataSource dataSource, int columnIndex) {
	}

	/**
	 *  Gets the table model. This is the table model after filtering.
	 *  <p/>
	 *  Please note, we introduced {@link PivotDataSource} concept in 2.2.2 release. With the help of
	 *  <code>PivotDataSource</code>, <code>PivotDataModel</code> doesn't have to use TableModel as the data source.
	 *  Although this method will still return the table model in the default case when the data source is the default
	 *  <code>TableModelPivotDataSource</code>, it is not guaranteed. If you set your own <code>PivotDataSource</code>
	 *  which doesn't depend on any table model, this getTableModel will return null.
	 * 
	 *  @return the table model .
	 */
	public javax.swing.table.TableModel getTableModel() {
	}

	/**
	 *  Gets the data source.
	 * 
	 *  @return the data source.
	 */
	public PivotDataSource getDataSource() {
	}

	/**
	 *  Gets the PivotField by the name.
	 * 
	 *  @param name the field name
	 *  @return the PivotField by the name.
	 */
	public PivotField getField(String name) {
	}

	/**
	 *  Gets the PivotField by the index.
	 * 
	 *  @param index the field index
	 *  @return the PivotField by the index.
	 */
	public PivotField getField(int index) {
	}

	/**
	 *  Gets all the PivotFields.
	 * 
	 *  @return all the PivotFields.
	 */
	public PivotField[] getFields() {
	}

	public void setPivotFields(PivotField[] rowFields, PivotField[] columnFields, PivotField[] dataFields, PivotField[] filterFields) {
	}

	protected void handleFieldPropertyEvent(java.beans.PropertyChangeEvent evt) {
	}

	public void updateFields() {
	}

	/**
	 *  Calculates the pivot data. Whenever you are done updating PivotField settings or the data in the original table
	 *  model is changed, you should call this method to use the new settings or new data. If you call this method after
	 *  the PivotDataModel has been set on PivotTablePane, you also need to call {@link
	 *  com.jidesoft.pivot.PivotTablePane#fieldsUpdated()} method in order for the change to take effect.
	 */
	public void calculate() {
	}

	public void forceCalculate() {
	}

	/**
	 *  Manages CompoundKeys after calculation to fill in some necessary CompoundKeys without adding dummy records in the
	 *  original table model or removing some unnecessary CompoundKeys without removing records in the original table
	 *  model.
	 *  <p/>
	 *  Please construct row keys or column keys then invoke {@link #addRowIndex(CompoundKey, CompoundKey, int)} with the
	 *  third parameter as -1 to fill in the extra compound keys. Please invoke {@link #removeColumnKey(CompoundKey)} or
	 *  {@link #removeRowKey(CompoundKey)} to remove unnecessary CompoundKeys.
	 *  <p/>
	 *  Please make sure you will check the {@link #getRowFields()} and {@link #getColumnFields()} first to construct
	 *  correct CompoundKeys. Otherwise, the behavior might be very odd.
	 *  <code><pre>
	 *  // assume the first column field is year, the second is quarter and the third is month.
	 *  for (int year = 1993; year <= 1997; year++) {
	 *      for (int quarter = 0; quarter <= 3; quarter++) {
	 *          for (int month = quarter * 3; month <= quarter * 3 + 2; month++) {
	 *              addRowIndex(CompoundKey.newInstance(new Object[0]), CompoundKey.newInstance(new Object[]{year,
	 *  quarter, month}), -1);
	 *          }
	 *      }
	 *  }
	 *  </pre></code>
	 * 
	 *  @since 3.4.6
	 */
	protected void manageCompoundKeys() {
	}

	/**
	 *  Removes the CompoundKey in row header area.
	 *  <p/>
	 *  You could invoke this method in {@link #manageCompoundKeys()} to remove some unnecessary row keys as you wish.
	 * 
	 *  @param rowKey the CompoundKey
	 *  @since 3.4.6
	 */
	protected void removeRowKey(CompoundKey rowKey) {
	}

	/**
	 *  Removes the CompoundKey in column header area.
	 *  <p/>
	 *  You could invoke this method in {@link #manageCompoundKeys()} to remove some unnecessary column keys as you
	 *  wish.
	 * 
	 *  @param columnKey the CompoundKey
	 *  @since 3.4.6
	 */
	protected void removeColumnKey(CompoundKey columnKey) {
	}

	public boolean isCalculating() {
	}

	protected void updateFilters() {
	}

	/**
	 *  Checks if {@link #calculate()} is called on this pivot data model. There is no setter for this flag. Only {@link
	 *  #calculate()} will set it to true.
	 * 
	 *  @return true if {@link #calculate()} is already called.
	 */
	public boolean isCalculated() {
	}

	/**
	 *  Gets the designated compound key from the row index in the data source.
	 * 
	 *  @param rowIndex the row index in the data source.
	 *  @param areaType AREA_ROW or AREA_COLUMN
	 *  @return the compound key.
	 *  @since 3.3.7
	 */
	protected CompoundKey getCompoundKeyAt(int rowIndex, int areaType) {
	}

	/**
	 *  Gets the closest row index in DataTable that includes the actual row index in the original table model.
	 *  <p/>
	 *  There might be many rows that represents the actual row in the original table model. If this is the case, the
	 *  closest one will be returned. If there are multiple data fields, the top-most row will be returned.
	 * 
	 *  @param actualRow the actual row index in the original table model
	 *  @return the closest row index in DataTable.
	 *  @since 3.4.4
	 */
	public int getRowAt(int actualRow) {
	}

	/**
	 *  Gets the closest column index in DataTable that includes the actual row index in the original table model.
	 *  <p/>
	 *  There might be many columns that represents the actual row in the original table model. If this is the case, the
	 *  closest one will be returned. If there are multiple data fields, the left-most column will be returned.
	 * 
	 *  @param actualRow the actual row index in the original table model
	 *  @return the closest column index in DataTable.
	 *  @since 3.4.4
	 */
	public int getColumnAt(int actualRow) {
	}

	public void invalidateRowHeaderTableModel() {
	}

	public void invalidateColumnHeaderTableModel() {
	}

	public void invalidateCornerTableModel() {
	}

	public void invalidateDataTableModel() {
	}

	/**
	 *  Gets the possible values of the specified columnIndex. The values are sorted.
	 * 
	 *  @param columnIndex the column index.
	 *  @return the possible values of in the column.
	 *  @deprecated the order of the possible values returned from this method is not clear. Please use {@link
	 *  #getPossibleValues(int, java.util.Comparator)} instead. We didn't use this method anymore in our code.
	 */
	@java.lang.Deprecated
	public Object[] getPossibleValues(int columnIndex) {
	}

	public Object[] getPossibleValues(PivotField field) {
	}

	/**
	 *  Gets the possible values of the specified columnIndex. The values are sorted using the comparator passed in as
	 *  parameter.
	 *  <p/>
	 *  If the {@link com.jidesoft.pivot.PivotField#isPreferSelectedPossibleValues()} returns false, all values in {@link
	 *  com.jidesoft.pivot.PivotField#getFilteredPossibleValues()} will also present in the return array.
	 * 
	 *  @param columnIndex the column index
	 *  @param comparator  the comparator
	 *  @return the possible values of in the column.
	 */
	@java.lang.SuppressWarnings("RawUseOfParameterizedType")
	public Object[] getPossibleValues(int columnIndex, java.util.Comparator comparator) {
	}

	/**
	 *  Gets the row header table model. It can be used by HeaderTable.
	 * 
	 *  @return the row header table model.
	 */
	public HeaderTableModel getRowHeaderTableModel() {
	}

	/**
	 *  Creates the row header table model.
	 * 
	 *  @param keys the row keys.
	 *  @return the HeaderTableModel used for the row header table.
	 */
	protected HeaderTableModel createRowHeaderTableModel(CompoundKey[] keys) {
	}

	/**
	 *  Gets the corner table model. It is the table model for the top left corner but in regular PivotTablePane, this
	 *  model is not used. You need to enable it by overriding the following method in PivotTablePane and override
	 *  setupLayout to add _dataFieldsArea and _rowFieldsArea to somewhere else in order to set the _cornerTable to
	 *  UPPER_LEFT_CORNER of the JScrollPane.
	 *  <code><pre>
	 *  protected void initComponents() {
	 *      super.initComponents();
	 *     _cornerTable = new HeaderTable(this);
	 *     _cornerTable.setRowHeight(getRowHeight());
	 *     setCornerTableModel(_cornerTable, getPivotDataModel().getCornerTableModel());
	 *     _cornerTable.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
	 *      _cornerTable.setCellSelectionEnabled(true);
	 *      ((JideTable) _cornerTable).setColumnResizable(true);
	 *      ((JideTable) _cornerTable).setNonContiguousCellSelection(true);
	 *  }
	 *  </pre></code>
	 * 
	 *  @return the corner table model.
	 */
	public javax.swing.table.TableModel getCornerTableModel() {
	}

	/**
	 *  Gets the column header table model. It can be used by HeaderTable.
	 * 
	 *  @return the column header table model.
	 */
	public HeaderTableModel getColumnHeaderTableModel() {
	}

	/**
	 *  Creates the column header table model.
	 * 
	 *  @param keys the column keys.
	 *  @return the HeaderTableModel used for the column header table.
	 */
	protected HeaderTableModel createColumnHeaderTableModel(CompoundKey[] keys) {
	}

	/**
	 *  Gets the data table model.
	 * 
	 *  @return the data table model.
	 */
	public javax.swing.table.TableModel getDataTableModel() {
	}

	/**
	 *  Creates DataTableModel.
	 * 
	 *  @return the DataTableModel.
	 */
	protected DataTableModel createDataTableModel() {
	}

	/**
	 *  Gets the row fields. It must be called after {@link #calculate()} is called. Otherwise, it will return null.
	 * 
	 *  @return the row fields.
	 */
	public PivotField[] getRowFields() {
	}

	protected int[] getFieldIndices(PivotField[] fields) {
	}

	/**
	 *  Gets the model indices for the row fields. It must be called after {@link #calculate()} is called. Otherwise, it
	 *  will return null.
	 * 
	 *  @return the row fields.
	 */
	public int[] getRowFieldIndices() {
	}

	/**
	 *  Gets the column fields. It must be called after {@link #calculate()} is called. Otherwise, it will return null.
	 * 
	 *  @return the column fields.
	 */
	public PivotField[] getColumnFields() {
	}

	/**
	 *  Gets the model indices for the column fields. It must be called after {@link #calculate()} is called. Otherwise,
	 *  it will return null.
	 * 
	 *  @return the column fields.
	 */
	public int[] getColumnFieldIndices() {
	}

	/**
	 *  Gets the data fields. it must be called after {@link #calculate()} is called. Otherwise, it will return null.
	 * 
	 *  @return the data fields.
	 */
	public PivotField[] getDataFields() {
	}

	public void resetDataFields() {
	}

	/**
	 *  Gets the model indices for the data fields. It must be called after {@link #calculate()} is called. Otherwise, it
	 *  will return null.
	 * 
	 *  @return the data fields.
	 */
	public int[] getDataFieldIndices() {
	}

	/**
	 *  Gets the filter fields. it must be called after {@link #calculate()} is called. Otherwise, it will return null.
	 * 
	 *  @return the filter fields.
	 */
	public PivotField[] getFilterFields() {
	}

	/**
	 *  Gets the model indices for the filter fields. It must be called after {@link #calculate()} is called. Otherwise,
	 *  it will return null.
	 * 
	 *  @return the filter fields.
	 */
	public int[] getFilterFieldIndices() {
	}

	/**
	 *  Gets the unassigned fields. it must be called after {@link #calculate()} is called. Otherwise, it will return
	 *  null.
	 * 
	 *  @return the unassigned fields.
	 */
	public PivotField[] getUnassignedFields() {
	}

	/**
	 *  Gets the model indices for the unassigned fields. It must be called after {@link #calculate()} is called.
	 *  Otherwise, it will return null.
	 * 
	 *  @return the unassigned fields.
	 */
	public int[] getUnassignedFieldIndices() {
	}

	/**
	 *  Gets the row index list at the specified row index and column index. If both indices are greater than or equal 0,
	 *  it will get the row index list as in the data table model. If the row index is less than 0 but the column index
	 *  is greater than or equal 0, it will get the row index list as in the column header table model. The negative row
	 *  index is converted to the row index relative to row header table model using - rowIndex - 1. If the column index
	 *  is less than 0 but the row index is greater than or equal 0, it will get the row index list as in the row header
	 *  table model. The negative column index is converted to the column index relative to column header table model
	 *  using - columnIndex - 1.
	 *  <p/>
	 *  Please note, the list returned from this method is used internally. If you iterate through the list and modify
	 *  the table model at the same time, the list could be changed as well. So to be safe, you should replicate the list
	 *  if you plan to modify the table model.
	 * 
	 *  @param rowIndex    the row index relative to DataTableModel.
	 *  @param columnIndex the column index relative to DataTableModel.
	 *  @return a list of integer which are row indexes to the data source that you can get using {@link
	 *  #getDataSource()}.
	 */
	public java.util.List getDataAt(int rowIndex, int columnIndex) {
	}

	/**
	 *  Gets the row index list that matches with the rowKey and columnKey.
	 * 
	 *  @param rowKey    the row compound key
	 *  @param columnKey the column compound key
	 *  @return a list of integer which are row indexes to the data source that you can get using {@link
	 *  #getDataSource()}.
	 */
	public java.util.List getDataAt(CompoundKey rowKey, CompoundKey columnKey) {
	}

	/**
	 *  Sorts the compound keys based on the sort order in the fields.
	 * 
	 *  @param keys   the list of CompoundKeys.
	 *  @param fields the array of the fields.
	 *  @return sorted compound key array.
	 */
	protected CompoundKey[] sortCompoundKeys(CompoundKey[] keys, PivotField[] fields) {
	}

	/**
	 *  Is the data field displayed on the row header area. It possibly returns true only if isColumnDataFields return
	 *  false. Otherwise data fields will display on the column header area.
	 * 
	 *  @return true or false.
	 */
	public boolean isRowDataFields() {
	}

	/**
	 *  Checks if the data field displayed on the column header area.
	 * 
	 *  @return true or false.
	 */
	public boolean isColumnDataFields() {
	}

	/**
	 *  Checks if the data fields will always displayed on the column header area. If this method returns true,
	 *  isColumnDataFields will always return true.
	 * 
	 *  @return true or false.
	 */
	public boolean isAlwaysColumnDataFields() {
	}

	/**
	 *  Sets the flag whether the data fields will always be displayed on the column header area. By default, we might
	 *  use row header area to display the data fields if there is no field in the row area.
	 * 
	 *  @param alwaysColumnDataFields true or false.
	 */
	public void setAlwaysColumnDataFields(boolean alwaysColumnDataFields) {
	}

	/**
	 *  Is the data field always displayed on the row header area. If this method returns true, isRowDataFields will
	 *  always return true as long as isColumnDataFields returns false.
	 * 
	 *  @return true or false.
	 */
	public boolean isAlwaysRowDataFields() {
	}

	/**
	 *  Sets the flag whether the data fields will always be displayed on the row header area. By default, we might use
	 *  row header area to display the data fields if there is no field in the row area.
	 * 
	 *  @param alwaysRowDataFields true or false.
	 */
	public void setAlwaysRowDataFields(boolean alwaysRowDataFields) {
	}

	public boolean isHideSingleDataField() {
	}

	public void setHideSingleDataField(boolean hideSingleDataField) {
	}

	/**
	 *  Checks if grand total row is visible.
	 * 
	 *  @return true if grand total row is visible. Otherwise is false.
	 */
	public boolean isShowGrandTotalForRow() {
	}

	/**
	 *  Shows grand total row. If you changed this value, you need to call {@link PivotTablePane#rowHeaderUpdated()} or
	 *  {@link PivotTablePane#bothHeadersUpdated()} if you also changed grandTotalForColumn.
	 * 
	 *  @param showGrandTotalForRow whether show grand total for row.
	 */
	public void setShowGrandTotalForRow(boolean showGrandTotalForRow) {
	}

	/**
	 *  Checks if grand total column is visible.
	 * 
	 *  @return true if grand total column is visible. Otherwise is false.
	 */
	public boolean isShowGrandTotalForColumn() {
	}

	/**
	 *  Shows grand total column. If you changed this value, you need to call {@link
	 *  PivotTablePane#columnHeaderUpdated()} or {@link PivotTablePane#bothHeadersUpdated()} if you also changed
	 *  grandTotalForRow.
	 * 
	 *  @param showGrandTotalForColumn whether show grand total for column.
	 */
	public void setShowGrandTotalForColumn(boolean showGrandTotalForColumn) {
	}

	/**
	 *  Gets the PivotCellStyleProvider.
	 * 
	 *  @return the PivotCellStyleProvider.
	 */
	public PivotCellStyleProvider getCellStyleProvider() {
	}

	/**
	 *  Sets the PivotCellStyleProvider. You can use this provider to provide CellStyle for column header table, row
	 *  header table and data table.
	 * 
	 *  @param cellStyleProvider the cell style provider.
	 */
	public void setCellStyleProvider(PivotCellStyleProvider cellStyleProvider) {
	}

	/**
	 *  Sets the PivotDataEditingProvider that is used for the row header table. You can use this provider to provide a
	 *  way to edit cell directly in pivot table. The provide will interpret the user change and modify the actual data
	 *  source.
	 * 
	 *  @param rowHeaderEditingProvider the date editing provider.
	 */
	public void setRowHeaderEditingProvider(PivotDataEditingProvider rowHeaderEditingProvider) {
	}

	/**
	 *  Gets the PivotDataEditingProvider for the row header table.
	 * 
	 *  @return the PivotDataEditingProvider.
	 */
	public PivotDataEditingProvider getRowHeaderEditingProvider() {
	}

	/**
	 *  Sets the PivotDataEditingProvider that is used for the column header table. You can use this provider to provide
	 *  a way to edit cell directly in pivot table. The provide will interpret the user change and modify the actual data
	 *  source.
	 * 
	 *  @param columnHeaderEditingProvider the date editing provider.
	 */
	public void setColumnHeaderEditingProvider(PivotDataEditingProvider columnHeaderEditingProvider) {
	}

	/**
	 *  Gets the PivotDataEditingProvider for the column header table.
	 * 
	 *  @return the PivotDataEditingProvider.
	 */
	public PivotDataEditingProvider getColumnHeaderEditingProvider() {
	}

	/**
	 *  Gets the PivotDataEditingProvider for the data table.
	 * 
	 *  @return the PivotDataEditingProvider.
	 */
	public PivotDataEditingProvider getDataEditingProvider() {
	}

	/**
	 *  Sets the PivotDataEditingProvider for the data table. You can use this provider to provide a way to edit cell
	 *  directly in pivot table. The provide will interpret the user change and modify the actual data source.
	 * 
	 *  @param dataEditingProvider the date editing provider.
	 */
	public void setDataEditingProvider(PivotDataEditingProvider dataEditingProvider) {
	}

	/**
	 *  Gets the statistics calculator used to calculate all the statistics for the pivot data model.
	 * 
	 *  @return the statistics calculator.
	 */
	public SummaryCalculator getSummaryCalculator() {
	}

	/**
	 *  Sets the statistics calculator.
	 * 
	 *  @param summaryCalculator the summary calculator.
	 */
	public void setSummaryCalculator(SummaryCalculator summaryCalculator) {
	}

	/**
	 *  Gets the summary calculator factory which will create summary calculator to calculate all the statistics for the
	 *  pivot data model. Please note, this SummaryCalculatorFactory is only used when the {@link
	 *  #calculateStatistics(PivotField, int, int, int, Object[])} method is called from a non-EDT. On EDT, we will use
	 *  {@link #getSummaryCalculator()} method to get the SummaryCalculator.
	 * 
	 *  @return the summary calculator factory.
	 */
	public SummaryCalculatorFactory getSummaryCalculatorFactory() {
	}

	/**
	 *  Sets the statistics calculator factory. We will use this factory to create SummaryCalculator if the calculation
	 *  is running in a multiple thread environment. Otherwise we will use {@link #getSummaryCalculator()} method to get
	 *  the SummaryCalculator.
	 * 
	 *  @param summaryCalculatorFactory the summary calculator factory.
	 */
	public void setSummaryCalculatorFactory(SummaryCalculatorFactory summaryCalculatorFactory) {
	}

	public boolean isDisplayGrandTotalFirstForRow() {
	}

	public void setDisplayGrandTotalFirstForRow(boolean displayGrandTotalFirstForRow) {
	}

	public boolean isDisplayGrandTotalFirstForColumn() {
	}

	public void setDisplayGrandTotalFirstForColumn(boolean displayGrandTotalFirstForColumn) {
	}

	/**
	 *  Checks if the grand total is displayed as the first column (row).
	 * 
	 *  @return true or false.
	 */
	public boolean isDisplayGrandTotalFirst() {
	}

	/**
	 *  By default, grand total is displayed at the last column (row) in the pivot table. If you set this flag to true,
	 *  it will be displayed as the first column (row).
	 *  <p/>
	 *  It's deprecated since 2.11.1. To keep backward compatibility, if the user happens to invoke this method to set
	 *  the flag, it will automatically invoke both {@link #setDisplayGrandTotalFirstForRow(boolean)} and {@link
	 *  #setDisplayGrandTotalFirstForColumn(boolean)}.
	 * 
	 *  @param displayGrandTotalFirst true or false.
	 *  @deprecated replaced by {@link #setDisplayGrandTotalFirstForRow(boolean)} and {@link
	 *  #setDisplayGrandTotalFirstForColumn(boolean)}
	 */
	@java.lang.Deprecated
	public void setDisplayGrandTotalFirst(boolean displayGrandTotalFirst) {
	}

	/**
	 *  Checks if the pivot data will be automatically updated when the underlying table model data changes.
	 * 
	 *  @return true or false.
	 */
	public boolean isAutoUpdate() {
	}

	/**
	 *  Sets the flag if the pivot data will be automatically updated when the underlying table model data changes. By
	 *  default, it is false because in most cases people use pivot data to analyze static data. If the data changes, you
	 *  have to call {@link #calculate()} method when the underlying table model data changes. However because the data
	 *  inside pivot table is very complex, right now autoUpdate will only update correctly if the table model data
	 *  change is cellUpdated event and rowUpdated event. If you add/remove rows or columns, you still have to call
	 *  {@link #calculate()} just like before.
	 * 
	 *  @param autoUpdate true or false.
	 */
	public void setAutoUpdate(boolean autoUpdate) {
	}

	/**
	 *  Checks if the PivotDataModel is adjusting. If it is adjusting, other code should not call calculate() or update
	 *  UI automatically when a property is changed. Right now, we used in {@link com.jidesoft.pivot.PivotField#setSelectedPossibleValues(Object[])}.
	 *  By default, isAdjusting is false, so setSelectedPossibleValues will call calculate() and bothHeaderUpdated(). If
	 *  isAdjusting is true, they will be not be called.
	 * 
	 *  @return true if adjusting. Otherwise false.
	 */
	public boolean isAdjusting() {
	}

	/**
	 *  Sets the PivotDataModel to adjusting mode. If it is adjusting, PivotDataModel will not call calculate() and
	 *  update the UI when something is changed. After you set adjusting to false, PivotDataModel will then calculate().
	 *  But you will be still be responsible to call the XxxUpdated() method on PivotTablePane to update the UI.
	 * 
	 *  @param adjusting true or false.
	 */
	public void setAdjusting(boolean adjusting) {
	}

	/**
	 *  Checks if the pivot data model works in summary mode. Summary mode means instead of display the summary (such as
	 *  sum, max, min, stddev etc statistics) of the values in the data table, it displays the first value that matches
	 *  the key.
	 *  <p/>
	 *  Default is true.
	 * 
	 *  @return true or false.
	 */
	public boolean isSummaryMode() {
	}

	/**
	 *  Sets the flag for the summary mode. Summary mode means instead of display the summary (such as sum, max, min,
	 *  stddev etc statistics) of the values in the data table, it displays the first value that matches the key.
	 * 
	 *  @param summaryMode true to set to summary mode. Otherwise false.
	 *  @see #isSummaryMode()
	 */
	public void setSummaryMode(boolean summaryMode) {
	}

	/**
	 *  Checks if the pivot data model works in aggregate mode. Aggregate mode is only used by {@link
	 *  com.jidesoft.pivot.AggregateTableModel} to show the actual cell values for the matched keys. By default, the
	 *  actual values will not be displayed. Typically you should setSummaryMode(false).
	 *  <p/>
	 *  Default is false.
	 * 
	 *  @return true or false.
	 */
	public boolean isAggregateMode() {
	}

	/**
	 *  The cells in the data table are actually summary of multiple rows in the original table model. For example, if
	 *  the summary is SUM, we will display the sum of all the values of all the rows and display it in the cell of the
	 *  data table. However In the single value mode, whenever there are two rows that maps to the same cell, we will
	 *  delete the second row.
	 * 
	 *  @return true or false.
	 */
	public boolean isSingleValueMode() {
	}

	/**
	 *  Sets the single value mode.
	 * 
	 *  @param singleValueMode true or false.
	 */
	public void setSingleValueMode(boolean singleValueMode) {
	}

	/**
	 *  This method is for debugging purpose, not a public API. It will print out if there is any cell span errors in the
	 *  row header and the column header table.
	 */
	@java.lang.SuppressWarnings({"UseOfSystemOutOrSystemErr", "JavaDoc"})
	public boolean verify() {
	}

	/**
	 *  Gets the row index in the row header table which has the data from the original table model at the specified
	 *  rowIndex.
	 * 
	 *  @param rowIndex the row at the original table model.
	 *  @return the row index as in the row header table.
	 */
	public int getRowHeaderRowIndexAt(int rowIndex) {
	}

	/**
	 *  Gets the column index in the column header table which has the data from the original table model at the
	 *  specified rowIndex.
	 * 
	 *  @param rowIndex the row at the original table model.
	 *  @return the column index as in the column  header table.
	 */
	public int getColumnHeaderColumnIndexAt(int rowIndex) {
	}

	/**
	 *  Checks the valueImmutable flag.
	 * 
	 *  @return true or false.
	 */
	public static boolean isValueImmutable() {
	}

	/**
	 *  Sets the valueImmutable flag. By default, we assume all values in getValueAt of PivotDataSource or TableModel are
	 *  immutable so that we can cache the hashCode of those values for the performance reason. All primitives, Number,
	 *  String are immutable which are most table model getValueAt will return. If you need to return your own classes in
	 *  getValueAt, you can make them immutable. But if for whatever reason you can't do that, you can call
	 *  PivotDataModel#setValueImmutable(false) before creating any PivotDataModel. Just so you know, from our
	 *  performance testing based on PivotTableDemo, setValueImmutable(false) will double the time to do the calculate()
	 *  method. It's something you need to consider.
	 * 
	 *  @param valueImmutable true or false.
	 */
	public static void setValueImmutable(boolean valueImmutable) {
	}

	/**
	 *  Checks the useComparable flag.
	 * 
	 *  @return true or false.
	 *  @since 3.3.3
	 */
	public static boolean isUseComparable() {
	}

	/**
	 *  Sets the flag of useComparable. This flag is used when comparing. If the two objects are Comparable, we will use
	 *  Comparable's compareTo method to compare, which is usually faster than using using Comparator. However if for
	 *  whatever reason, we can't use Comparator, you can set this flag to false so that it will always use
	 *  ObjectComparatorManager to compare.
	 * 
	 *  @param useComparable true or false.
	 *  @since 3.3.3
	 */
	public static void setUseComparable(boolean useComparable) {
	}

	/**
	 *  Get the flag that indicating if summary values should be hidden if all its children values are hidden.
	 *  <p/>
	 *  The default value of this flag is true, which could cause incompatible behavior with release earlier than 2.8.3.
	 * 
	 *  @return true if summary values need be hidden. otherwise false.
	 */
	public boolean isHideSummaryValues() {
	}

	/**
	 *  Set the flag that indicating if summary values should be hidden if all its children values are hidden.
	 * 
	 *  @param hideSummaryValues the flag
	 *  @see #isHideSummaryValues()
	 */
	public void setHideSummaryValues(boolean hideSummaryValues) {
	}

	public boolean isKeepRowChildrenOnSummaryFilter() {
	}

	public void setKeepRowChildrenOnSummaryFilter(boolean keepRowChildrenOnSummaryFilter) {
	}

	/**
	 *  Get the flag indicating if the expand/collapse icon will be hidden if there is only one row as its child.
	 * 
	 *  @return true if the icon would be hidden. Otherwise false.
	 *  @see #setHideExpandIconOnSingleRow(boolean)
	 */
	public boolean isHideExpandIconOnSingleRow() {
	}

	/**
	 *  Set the flag indicating if the expand/collapse icon will be hidden if there is only one row as its child.
	 *  <p/>
	 *  By default, the flag is true to hide the expand icon.
	 * 
	 *  @param hideExpandIconOnSingleRow the flag
	 */
	public void setHideExpandIconOnSingleRow(boolean hideExpandIconOnSingleRow) {
	}

	public void setOriginalDataUpdate(Object o) {
	}

	/**
	 *  Gets the flag indicating if the data field should be laid out in the first level or not.
	 * 
	 *  @return true if the data field should be laid out first. Otherwise false.
	 *  @see #setLayoutDataFieldsFirst(boolean)
	 *  @since 3.3.8
	 */
	public boolean isLayoutDataFieldsFirst() {
	}

	/**
	 *  Sets the flag indicating if the data field should be laid out in the first level or not.
	 *  <p/>
	 *  By default the flag is false to keep the default behavior backward compatible.
	 * 
	 *  @param layoutDataFieldsFirst the flag
	 *  @since 3.3.8
	 */
	public void setLayoutDataFieldsFirst(boolean layoutDataFieldsFirst) {
	}

	@java.lang.Override
	public boolean isHighPerformanceMode() {
	}

	@java.lang.Override
	public void setHighPerformanceMode(boolean highPerformanceMode) {
	}

	/**
	 *  Gets the row merger.
	 * 
	 *  @return the row merger.
	 *  @see com.jidesoft.pivot.PivotDataModel.RowMerger
	 */
	public PivotDataModel.RowMerger getRowMerger() {
	}

	/**
	 *  Sets the row merger.
	 * 
	 *  @param rowMerger a new RowMerger
	 *  @see com.jidesoft.pivot.PivotDataModel.RowMerger
	 */
	public void setRowMerger(PivotDataModel.RowMerger rowMerger) {
	}

	/**
	 *  Checks whether the CompoundKeys automatically are sorted.
	 * 
	 *  @return true or false.
	 */
	public boolean isAutoSortKeys() {
	}

	/**
	 *  Sets the flag whether the CompoundKeys should be automatically sorted when calcuate() is called.
	 * 
	 *  @param autoSortKeys true or false.
	 */
	public void setAutoSortKeys(boolean autoSortKeys) {
	}

	public int getStatisticsType(Values rowValues, Values columnValues, PivotField dataField) {
	}

	/**
	 *  Calculate statistics for the cell with the same rowValues and the same columnValues in DataTable.
	 * 
	 *  @param field        the data field
	 *  @param rowValues    the row values
	 *  @param columnValues the column values
	 *  @param summaryType  the summary type
	 *  @param objects      the base values
	 *  @return the calculated value.
	 */
	protected Object calculateStatistics(PivotField field, Values rowValues, Values columnValues, int summaryType, Object[] objects) {
	}

	/**
	 *  Calculate statistics for the cell with (rowIndex, columnIndex) in DataTable. This method will only be invoked by
	 *  DataTableModel if this pivot data model is NOT a CalculatedPivotDataModel.
	 * 
	 *  @param field       the data field
	 *  @param rowIndex    the row index in the data table
	 *  @param columnIndex the column index in the data table
	 *  @param summaryType the summary type
	 *  @param objects     the base values
	 *  @return the calculated value.
	 *  @deprecated replaced by {@link #calculateStatistics(PivotField, Values, Values, int, Object[])}
	 */
	@java.lang.Deprecated
	protected Object calculateStatistics(PivotField field, int rowIndex, int columnIndex, int summaryType, Object[] objects) {
	}

	@java.lang.SuppressWarnings("UnusedDeclaration")
	protected Object[] collectValuesForCell(PivotField field, Values rowKeys, Values columnKeys, int summaryType) {
	}

	@java.lang.SuppressWarnings("UnusedDeclaration")
	protected Object[] collectValuesForCell(PivotField field, int rowIndex, int columnIndex, int summaryType) {
	}

	public Object getValueAt(PivotField field, Values rowKeys, Values columnKeys) {
	}

	/**
	 *  Check if the cell in the DataTable need calculate summary.
	 *  <p/>
	 *  PivotTablePane will get corresponding class, editorContext, converterContext, value, etc., depending on this
	 *  method.
	 *  <p/>
	 *  You don't have to override this method unless you want to control the details of the cell behavior.
	 * 
	 *  @param rowIndex    the row index of the cell
	 *  @param columnIndex the column index of the cell
	 *  @return true if the cell needs calculation. Otherwise false.
	 */
	protected boolean shouldCalculateSummary(int rowIndex, int columnIndex) {
	}

	/**
	 *  Checks if the Values is visible.
	 * 
	 *  @param values the Values.
	 *  @return true or false True means the Values is visible.
	 */
	public boolean isValuesVisible(Values values) {
	}

	/**
	 *  Adds the values to the hidden values. For example, if you want to hide the column or row, as in PivotTableDemo,
	 *  that year is 1994, quarter is 2 and month is 6, you can call the code below to do it.
	 *  <pre><code>
	 *  addHiddenValues(new DefaultValues(new Object[]{1994, 2, 6});
	 *  </code></pre>
	 * 
	 *  @param values the Values.
	 */
	public void addHiddenValues(Values values) {
	}

	/**
	 *  Removes the values from the hidden values.
	 * 
	 *  @param values the Values.
	 */
	public void removeHiddenValues(Values values) {
	}

	/**
	 *  Clears the hidden values. In the other word, all Values will be shown on the header tables.
	 */
	public void clearHiddenValues() {
	}

	/**
	 *  Checks if there are hidden values.
	 * 
	 *  @return True if there are hidden values. Otherwise false.
	 */
	public boolean hasHiddenValues() {
	}

	/**
	 *  Gets all the hidden values.
	 * 
	 *  @return the hidden values in an array.
	 */
	public Values[] getHiddenValues() {
	}

	public boolean isRowVisible(Values values, PivotField field) {
	}

	public void addHiddenRow(Values values, PivotField field) {
	}

	public String removeHiddenRow(Values values, PivotField field) {
	}

	public void clearHiddenRows() {
	}

	public boolean hasHiddenRows() {
	}

	public Object[][] getHiddenRows() {
	}

	public boolean isColumnVisible(Values values, PivotField field) {
	}

	public void addHiddenColumn(Values values, PivotField field) {
	}

	public void addHiddenColumn(Values values, PivotField dataField, String width) {
	}

	public String removeHiddenColumn(Values values, PivotField field) {
	}

	public void clearHiddenColumns() {
	}

	public boolean hasHiddenColumns() {
	}

	public Object[][] getHiddenColumns() {
	}

	/**
	 *  Gets the flag if empty headers are allowed.
	 * 
	 *  @return true or false.
	 */
	public boolean isAllowEmptyColumnHeader() {
	}

	/**
	 *  Sets the flag if empty column header is allowed. This is used when there are no column fields but there are data
	 *  fields. If this flag is set to false, we will display summary information on the data fields in the data table.
	 *  If set to true, the data table will be empty.
	 * 
	 *  @param allowEmptyColumnHeader true or false.
	 */
	public void setAllowEmptyColumnHeader(boolean allowEmptyColumnHeader) {
	}

	/**
	 *  Gets the flag if empty headers are allowed.
	 * 
	 *  @return true or false.
	 */
	public boolean isAllowEmptyRowHeader() {
	}

	/**
	 *  Sets the flag if empty row header is allowed. This is used when there are no row fields but there are data
	 *  fields. If this flag is set to false, we will display summary information on the data fields in the data table.
	 *  If set to true, the data table will be empty.
	 * 
	 *  @param allowEmptyRowHeader true or false.
	 */
	public void setAllowEmptyRowHeader(boolean allowEmptyRowHeader) {
	}

	/**
	 *  Checks the flag whether the pivot table expands to show all the values.
	 * 
	 *  @return true or false.
	 */
	public boolean isExpandByDefault() {
	}

	/**
	 *  Sets the flag whether the pivot table should expand to show all the values. By default, when calculate() method
	 *  is called on PivotDataModel, all values are expanded so that user will see a fully expanded pivot table. You can
	 *  change it to false so that it will show only the top level summary.
	 * 
	 *  @param expandByDefault true or false.
	 */
	public void setExpandByDefault(boolean expandByDefault) {
	}

	public boolean isShowSubtotalAsChild() {
	}

	/**
	 *  By default, the subtotal rows/columns are at the same level as the values. For example, if there is a year value
	 *  is 1994, 1994 total is at the same level as sibling. If this flag is set to true, the subtotal will become a
	 *  child of the value.
	 * 
	 *  @param showSubtotalAsChild true or false.
	 */
	public void setShowSubtotalAsChild(boolean showSubtotalAsChild) {
	}

	/**
	 *  When the subtotal is configured as automatically and there is only one item, the subtotal is redundant. By
	 *  setting this flag to false, we will hide the subtotal if there is only one item.
	 * 
	 *  @return true or false.
	 *  @since 3.3.3
	 */
	public boolean isHideRedundantSubtotal() {
	}

	/**
	 *  Sets the hideRedundantSubtotal flag.
	 * 
	 *  @param hideRedundantSubtotal true or false.
	 *  @see #isHideRedundantSubtotal()
	 *  @since 3.3.3
	 */
	public void setHideRedundantSubtotal(boolean hideRedundantSubtotal) {
	}

	public void addPivotValueProviderListener(PivotValueProviderListener l) {
	}

	public void removePivotValueProviderListener(PivotValueProviderListener l) {
	}

	public PivotValueProviderListener[] getPivotValueProviderListeners() {
	}

	public void firePivotValueProviderChanged(int type) {
	}

	public void firePivotValueProviderChanged(int type, Object object) {
	}

	public CompoundKey[] getRowKeys() {
	}

	public CompoundKey[] getColumnKeys() {
	}

	public boolean isSummaryLayer() {
	}

	public void setSummaryLayer(boolean summaryLayer) {
	}

	/**
	 *  Support for reporting property changes for boolean properties. This method can be called when a property has
	 *  changed and it will send the appropriate PropertyChangeEvent to any registered PropertyChangeListeners.
	 * 
	 *  @param propertyName the property whose value has changed
	 *  @param oldValue     the property's previous value
	 *  @param newValue     the property's new value
	 */
	protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
	}

	/**
	 *  Adds a PropertyChangeListener to the listener list.
	 *  <p/>
	 *  If <code>listener</code> is <code>null</code>, no exception is thrown and no action is performed.
	 * 
	 *  @param listener the property change listener to be added
	 *  @see #removePropertyChangeListener
	 */
	public void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  Removes a PropertyChangeListener from the listener list. This method should be used to remove
	 *  PropertyChangeListeners that were registered for all bound properties of this class.
	 *  <p/>
	 *  If listener is null, no exception is thrown and no action is performed.
	 * 
	 *  @param listener the PropertyChangeListener to be removed
	 *  @see #addPropertyChangeListener
	 */
	public void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  Get the flag indicating that if the PivotValueProviderEvent will contain the affected cells information on
	 *  original data model change scenario.
	 * 
	 *  @return true if the PivotValueProviderEvent will contain the affected cells information. Otherwise false.
	 *  @see #isAutoUpdate()
	 *  @see #setComputeAffectedCellOnUpdate(boolean)
	 */
	public boolean isComputeAffectedCellOnUpdate() {
	}

	/**
	 *  Set the flag indicating that if the PivotValueProviderEvent will contain the affected cells information on
	 *  original data model change scenario.
	 *  <p/>
	 *  By default, the flag is false. You could set it to true however it may hit the performance since we have to cache
	 *  the values before and after value changed to get the affected cells.
	 *  <p/>
	 *  This flag could only take effect when both isAutoUpdate() and isCacheEnabled() return true.
	 * 
	 *  @param computeAffectedCellOnUpdate the flag
	 */
	public void setComputeAffectedCellOnUpdate(boolean computeAffectedCellOnUpdate) {
	}

	/**
	 *  An interface to merge the rows when they have the same row and column fields. We will call this method when the
	 *  original data changed and caused rows having the same row and column fields when and only when {@link
	 *  PivotDataModel#isSingleValueMode()} is true.
	 */
	public static interface class RowMerger {


		public void mergeRow(PivotDataModel dataModel, java.util.List rows, int index) {
		}
	}
}
