/**
 *  The package contains classes for JIDE Pivot Grid product.
 */
package com.jidesoft.pivot;


public interface PivotEditingProvider {

	/**
	 *  Checks if the data table editable.
	 * 
	 *  @return true or false.
	 */
	public boolean isDataEditable();

	/**
	 *  Sets the flag to indicate if the data table is editable.
	 * 
	 *  @param dataEditable true or false.
	 */
	public void setDataEditable(boolean dataEditable);

	/**
	 *  Checks if the row header table is editable.
	 * 
	 *  @return true or false.
	 */
	public boolean isRowHeaderEditable();

	/**
	 *  Sets the flag to indicate if the row header table is editable.
	 * 
	 *  @param rowHeaderEditable true or false.
	 */
	public void setRowHeaderEditable(boolean rowHeaderEditable);

	/**
	 *  Checks if the column header table is editable.
	 * 
	 *  @return true or false.
	 */
	public boolean isColumnHeaderEditable();

	/**
	 *  Sets the flag to indicate if the column header table is editable.
	 * 
	 *  @param columnHeaderEditable true or false.
	 */
	public void setColumnHeaderEditable(boolean columnHeaderEditable);

	/**
	 *  Gets the PivotDataEditingProvider for the row header table.
	 * 
	 *  @return the PivotDataEditingProvider for the row header table.
	 */
	public PivotDataEditingProvider getPivotRowHeaderEditingProvider();

	/**
	 *  Gets the PivotDataEditingProvider for the column header table.
	 * 
	 *  @return the PivotDataEditingProvider for the column header table.
	 */
	public PivotDataEditingProvider getPivotColumnHeaderEditingProvider();

	/**
	 *  Gets the PivotDataEditingProvider for the data table.
	 * 
	 *  @return the PivotDataEditingProvider for the data table.
	 */
	public PivotDataEditingProvider getPivotDataEditingProvider();

	/**
	 *  Adds a row to the original table model.
	 * 
	 *  @param model the PivotDataModel
	 *  @return the index of the newly added row.
	 */
	public int addRow(IPivotDataModel model);

	/**
	 *  Removes a row from the original table model.
	 * 
	 *  @param model    the PivotDataModel
	 *  @param rowIndex the index of the row to be removed.
	 */
	public void removeRow(IPivotDataModel model, int rowIndex);

	/**
	 *  Sets the value at the original table model.
	 * 
	 *  @param model       the PivotDataModel
	 *  @param value       the new value
	 *  @param rowIndex    the row index
	 *  @param columnIndex the column index
	 */
	public void setValueAt(IPivotDataModel model, Object value, int rowIndex, int columnIndex);
}
