/**
 *  The package contains classes for JIDE Pivot Grid product.
 */
package com.jidesoft.pivot;


/**
 *  PivotField represents a field in Pivot Table. Those fields can be row fields, column fields, data fields or filter
 *  fields.
 */
public class PivotField extends Field implements Comparable, PivotConstants, Cloneable {

	public static final int LOCATION_AFTER = 0;

	public static final int LOCATION_BEFORE = 1;

	public static final String PROPERTY_SUMMARY_TYPE = "summaryType";

	public static final String PROPERTY_GRAND_TOTAL_SUMMARY_TYPE = "grandTotalSummaryType";

	public static final String PROPERTY_SUBTOTAL_SUMMARY_TYPE = "subtotalSummaryType";

	public static final String PROPERTY_SUBTOTAL_TYPE = "subtotalType";

	public static final String PROPERTY_SUBTOTAL_LOCATION = "subtotalLocation";

	public static final String PROPERTY_CUSTOM_SUBTOTALS = "customSubtotals";

	public static final String PROPERTY_AREA_TYPE = "areaType";

	public static final String PROPERTY_AREA_INDEX = "areaIndex";

	public static final String PROPERTY_SORT_BY = "sortBy";

	public static final String PROPERTY_SORT_BY_ROW = "sortByRow";

	public static final String PROPERTY_FILTER_ON_SUMMARY = "filterOnSummary";

	public static final String PROPERTY_RUNNING_SUMMARY_LIST = "runningSummaryList";

	/**
	 *  Default constructor.
	 */
	public PivotField() {
	}

	/**
	 *  Creates the PivotField.
	 * 
	 *  @param tableModel the table model.
	 *  @param modelIndex the model index.
	 */
	public PivotField(javax.swing.table.TableModel tableModel, int modelIndex) {
	}

	/**
	 *  Creates the PivotField.
	 * 
	 *  @param dataSource the data source
	 *  @param modelIndex the model index.
	 */
	public PivotField(PivotDataSource dataSource, int modelIndex) {
	}

	/**
	 *  Gets the area type.
	 *  <p/>
	 *  The valid values are {@link PivotField#AREA_ROW}, {@link PivotField#AREA_COLUMN}, {@link PivotField#AREA_DATA},
	 *  {@link PivotField#AREA_FILTER} and {@link PivotField#AREA_NOT_ASSIGNED}.
	 * 
	 *  @return the area type.
	 */
	public int getAreaType() {
	}

	/**
	 *  Checks if the type of the PivotField is numeric type.
	 * 
	 *  @return true if it is numeric type including all subclasses of Number, double, int, float, short and long.
	 */
	public boolean isNumericType() {
	}

	/**
	 *  Sets the area type.
	 *  <p/>
	 *  The valid values are {@link PivotField#AREA_ROW}, {@link PivotField#AREA_COLUMN}, {@link PivotField#AREA_DATA},
	 *  {@link PivotField#AREA_FILTER} and {@link PivotField#AREA_NOT_ASSIGNED}.
	 *  <p/>
	 *  This is a bounded property. Property change event will be fired if the name is changed.
	 * 
	 *  @param areaType the area type.
	 */
	public void setAreaType(int areaType) {
	}

	/**
	 *  Gets the index in its area.
	 * 
	 *  @return the index in its area.
	 */
	public int getAreaIndex() {
	}

	/**
	 *  Sets the index in its area. In normal, the index should be 2 * n + 1, where n is the column number in its area
	 *  type. That means, the area index should be unique in the same area type. When the field order is changed, the
	 *  area index will have a temporary even number as 2 * n + 2, it's for internal use. If you get an event changing
	 *  index from even number 2 * n + 2 to 2 * n + 1, you can just ignore it.
	 *  <p/>
	 *  This is a bounded property. Property change event will be fired if the name is changed.
	 * 
	 *  @param areaIndex the area index.
	 */
	public void setAreaIndex(int areaIndex) {
	}

	public int compareTo(PivotField o) {
	}

	public Summary getCustomSummary() {
	}

	public void setCustomSummary(Summary customSummary) {
	}

	/**
	 *  Gets the summary type.
	 * 
	 *  @return the summary type.
	 */
	public int getSummaryType() {
	}

	/**
	 *  Sets the summary type. This is only valid for data field. Valid summary types are defined in {@link
	 *  PivotConstants} starting with "SUMMARY_".
	 * 
	 *  @param summaryType the new summary type.
	 */
	public void setSummaryType(int summaryType) {
	}

	/**
	 *  Gets the summary type for the grand total.
	 * 
	 *  @return the summary type for the grand total.
	 */
	public int getGrandTotalSummaryType() {
	}

	/**
	 *  Sets the summary type for the grand total. This is only valid for data field. Valid summary types are defined in
	 *  {@link PivotConstants} starting with "SUMMARY_".
	 * 
	 *  @param grandTotalSummaryType the new summary type for the grand total.
	 */
	public void setGrandTotalSummaryType(int grandTotalSummaryType) {
	}

	/**
	 *  Gets the summary type for the subtotal.
	 * 
	 *  @return the summary type for the subtotal.
	 */
	public int getSubtotalSummaryType() {
	}

	/**
	 *  Sets the summary type for the subtotal. This is only valid for data field. Valid summary types are defined in
	 *  {@link PivotConstants} starting with "SUMMARY_".
	 * 
	 *  @param subtotalSummaryType the new summary type for the subtotal.
	 */
	public void setSubtotalSummaryType(int subtotalSummaryType) {
	}

	/**
	 *  Gets the subtotal type.
	 *  <p/>
	 *  The valid values are {@link PivotField#SUBTOTAL_NONE}, {@link PivotField#SUBTOTAL_AUTOMATIC} and {@link
	 *  PivotField#SUBTOTAL_CUSTOM}. If it is {@link PivotField#SUBTOTAL_CUSTOM}, the actual subtotal types are defined
	 *  in {@link #getCustomSubtotals()}.
	 *  <p/>
	 *  This is a bounded property. Property change event will be fired if the name is changed.
	 * 
	 *  @return the subtotal type.
	 */
	public int getSubtotalType() {
	}

	/**
	 *  Sets the subtotal types. Calling this method will trigger a call <code>#setSeparateSubtotalSettings(false)</code>.
	 *  <p/>
	 *  The valid values are {@link PivotField#SUBTOTAL_NONE}, {@link PivotField#SUBTOTAL_AUTOMATIC} and {@link
	 *  PivotField#SUBTOTAL_CUSTOM}. If you set it as {@link PivotField#SUBTOTAL_CUSTOM}, you also need to define the
	 *  actual subtotal types using {@link #setCustomSubtotals(int[])}.
	 *  <p/>
	 *  This is a bounded property. Property change event will be fired if the name is changed.
	 * 
	 *  @param subtotalType the subtotal type.
	 */
	public void setSubtotalType(int subtotalType) {
	}

	/**
	 *  Gets the subtotal display location. It could be {@link PivotField#LOCATION_AFTER} so that the subtotal is
	 *  displayed after the actual data that produces the subtotal. Or it could be be {@link PivotField#LOCATION_BEFORE}
	 *  which is the opposite.
	 * 
	 *  @return the subtotal display location.
	 */
	public int getSubtotalLocation() {
	}

	/**
	 *  Sets the subtotal display location. Valid locations are {@link #LOCATION_AFTER} and {@link #LOCATION_BEFORE}.
	 *  <p/>
	 *  This is a bounded property. Property change event will be fired if the name is changed.
	 * 
	 *  @param subtotalLocation the subtotal display location
	 */
	public void setSubtotalLocation(int subtotalLocation) {
	}

	/**
	 *  Gets the custom subtotals.
	 * 
	 *  @return the custom subtotals.
	 */
	public int[] getCustomSubtotals() {
	}

	/**
	 *  Sets the custom subtotals. This is only used when subtotal type is SUBTOTAL_CUSTOM.
	 *  <p/>
	 *  This is a bounded property. Property change event will be fired if the name is changed.
	 * 
	 *  @param customSubtotals the custom subtotals.
	 */
	public void setCustomSubtotals(int[] customSubtotals) {
	}

	/**
	 *  Gets the subtotal type for row fields. This method will get the subtotal for row fields only if {@link
	 *  #isSeparateSubtotalSettings()} return true. If it returns false, this method will return the value of {@link
	 *  #getSubtotalType()}.
	 *  <p/>
	 *  The valid values are {@link PivotField#SUBTOTAL_NONE}, {@link PivotField#SUBTOTAL_AUTOMATIC} and {@link
	 *  PivotField#SUBTOTAL_CUSTOM}. If it is {@link PivotField#SUBTOTAL_CUSTOM}, the actual subtotal types are defined
	 *  in {@link #getCustomSubtotals()}.
	 *  <p/>
	 *  This is a bounded property. Property change event will be fired if the value is changed.
	 * 
	 *  @return the subtotal type.
	 */
	public int getSubtotalTypeForRow() {
	}

	/**
	 *  Sets the subtotal types for row fields. Calling this method will trigger a call
	 *  <code>#setSeparateSubtotalSettings(true)</code>.
	 *  <p/>
	 *  The valid values are {@link PivotField#SUBTOTAL_NONE}, {@link PivotField#SUBTOTAL_AUTOMATIC} and {@link
	 *  PivotField#SUBTOTAL_CUSTOM}. If you set it as {@link PivotField#SUBTOTAL_CUSTOM}, you also need to define the
	 *  actual subtotal types using {@link #setCustomSubtotals(int[])}.
	 *  <p/>
	 *  This is a bounded property. Property change event will be fired if the value is changed.
	 * 
	 *  @param subtotalTypeForRow the subtotal type for row
	 */
	public void setSubtotalTypeForRow(int subtotalTypeForRow) {
	}

	/**
	 *  Sets the flag of separateSubtotalSettings. If true, the subtotal could have different settings for row fields and
	 *  column fields.
	 * 
	 *  @param separateSubtotalSettings true or false.
	 */
	public void setSeparateSubtotalSettings(boolean separateSubtotalSettings) {
	}

	/**
	 *  Checks if the subtotal settings are separately for row fields and column fields.
	 * 
	 *  @return true if separated.
	 */
	public boolean isSeparateSubtotalSettings() {
	}

	/**
	 *  Gets the custom subtotals for row fields. This method will set the custom subtotal for row fields only. If you
	 *  use {@link #setCustomSubtotals(int[])} method, it will set for both row fields and column fields.
	 * 
	 *  @return the custom subtotals.
	 */
	public int[] getCustomSubtotalsForRow() {
	}

	/**
	 *  Sets the custom subtotals. This is only used when subtotal type is SUBTOTAL_CUSTOM.
	 *  <p/>
	 *  This is a bounded property. Property change event will be fired if the name is changed.
	 * 
	 *  @param customSubtotalsForRow the custom subtotals for the row.
	 */
	public void setCustomSubtotalsForRow(int[] customSubtotalsForRow) {
	}

	/**
	 *  Gets the subtotal type for row fields. This method will get the subtotal for column fields only if {@link
	 *  #isSeparateSubtotalSettings()} return true. If it returns false, this method will return the value of {@link
	 *  #getSubtotalType()}.
	 *  <p/>
	 *  The valid values are {@link PivotField#SUBTOTAL_NONE}, {@link PivotField#SUBTOTAL_AUTOMATIC} and {@link
	 *  PivotField#SUBTOTAL_CUSTOM}. If it is {@link PivotField#SUBTOTAL_CUSTOM}, the actual subtotal types are defined
	 *  in {@link #getCustomSubtotals()}.
	 *  <p/>
	 *  This is a bounded property. Property change event will be fired if the name is changed.
	 * 
	 *  @return the subtotal type.
	 */
	public int getSubtotalTypeForColumn() {
	}

	/**
	 *  Sets the subtotal types for column fields. Calling this method will trigger a call
	 *  <code>#setSeparateSubtotalSettings(true)</code>.
	 *  <p/>
	 *  The valid values are {@link PivotField#SUBTOTAL_NONE}, {@link PivotField#SUBTOTAL_AUTOMATIC} and {@link
	 *  PivotField#SUBTOTAL_CUSTOM}. If you set it as {@link PivotField#SUBTOTAL_CUSTOM}, you also need to define the
	 *  actual subtotal types using {@link #setCustomSubtotals(int[])}.
	 *  <p/>
	 *  This is a bounded property. Property change event will be fired if the name is changed.
	 * 
	 *  @param subtotalTypeForColumn the subtotal types for the column.
	 */
	public void setSubtotalTypeForColumn(int subtotalTypeForColumn) {
	}

	/**
	 *  Gets the custom subtotals for row fields. This method will set the custom subtotal for row fields only. If you
	 *  use {@link #setCustomSubtotals(int[])} method, it will set for both row fields and column fields.
	 * 
	 *  @return the custom subtotals.
	 */
	public int[] getCustomSubtotalsForColumn() {
	}

	/**
	 *  Sets the custom subtotals. This is only used when subtotal type is SUBTOTAL_CUSTOM.
	 *  <p/>
	 *  This is a bounded property. Property change event will be fired if the name is changed.
	 * 
	 *  @param customSubtotalsForColumn the custom subtotals for the column.
	 */
	public void setCustomSubtotalsForColumn(int[] customSubtotalsForColumn) {
	}

	/**
	 *  Gets the summary class. By default it will return null if the type is the same as the data itself. For example,
	 *  if the data is a double, sum of it will still be double. Thus getSummaryClass(SUMMARY_SUM) will return null.
	 *  However getSummaryClass(SUMMARY_COUNT) will return Long.class.
	 * 
	 *  @param type the new summary type.
	 *  @return the summary class.
	 */
	public Class getSummaryClass(int type) {
	}

	public void setSortOrder(int sortOrder) {
	}

	/**
	 *  Gets the statistics calculation type. It will determine how the statistics is calculated. The default type is
	 *  {@link #STATISTICS_CALCULATION_DEFAULT}. It will accumulate the values from original table model and calculate
	 *  statistics on them. There is also a type called {@link #STATISTICS_CALCULATION_RUNNING}. It will accumulate the
	 *  values from the cells as seen in the next level on the UI and calculate statistics on them. One more type called
	 *  {@link #STATISTICS_CALCULATION_RUNNING_LEAF} is used to accumulate the values from the cells as seen in the leaf
	 *  level on the UI and calculate statistics on them.
	 *  <p/>
	 *  For example, let's say we have two cells - one for the sales data in October, the other is for sales data in
	 *  November. In October, there are actual two transactions - one is $200, the other is $300. So the October cell
	 *  will display $500. There is only one transaction is November which is $400 so the November cell will display
	 *  $400. Now we want to calculate Max statistics on these two cells. If using {@link
	 *  #STATISTICS_CALCULATION_DEFAULT}, the Max will be $400 because that's the maximum sales in a single transaction
	 *  in October and November. However if we use {@link # STATISTICS_CALCULATION_RUNNING}, the Max will be $500 because
	 *  that's the maximum value of October cell and November cell.
	 *  <p/>
	 *  Please be noted that this flag takes effect only if the {@link CalculatedPivotDataModel} is in use.
	 * 
	 *  @return the statistics calculation type.
	 */
	public int getStatisticsCalculationType() {
	}

	/**
	 *  Sets the statistics calculation type.
	 * 
	 *  @param statisticsCalculationType the statistics calculation type. It could be {@link #STATISTICS_CALCULATION_DEFAULT}
	 *                                   or {@link #STATISTICS_CALCULATION_RUNNING} OR {@link #STATISTICS_CALCULATION_RUNNING_LEAF}.
	 */
	public void setStatisticsCalculationType(int statisticsCalculationType) {
	}

	public boolean isAllowedAsDataField() {
	}

	public void setAllowedAsDataField(boolean allowedAsDataField) {
	}

	public boolean isAllowedAsFilterField() {
	}

	public void setAllowedAsFilterField(boolean allowedAsFilterField) {
	}

	public boolean isAllowedAsRowField() {
	}

	public void setAllowedAsRowField(boolean allowedAsRowField) {
	}

	public boolean isAllowedAsColumnField() {
	}

	public void setAllowedAsColumnField(boolean allowedAsColumnField) {
	}

	public boolean isAllowedAsUnassignedField() {
	}

	public void setAllowedAsUnassignedField(boolean allowedAsUnassignedField) {
	}

	public boolean isAllowedAsField(int areaType) {
	}

	/**
	 *  Gets the sort-by row key.
	 * 
	 *  @return the sort-by row keys.
	 *  @since 3.5.16
	 */
	public Values getSortByRowKeys() {
	}

	/**
	 *  Sets the sort-by row key. This is to support sorting the column fields by a certain row. When user right clicks
	 *  on the data table, there will be a context menu with menu items like "sort ascending by row" or "sort descending
	 *  by row".
	 * 
	 *  @param sortByRowKeys the sort-by row keys.
	 *  @since 3.5.16
	 */
	public void setSortByRowKeys(Values sortByRowKeys) {
	}

	/**
	 *  Gets the sort-by column key.
	 * 
	 *  @return the sort-by column keys.
	 */
	public Values getSortByColumnKeys() {
	}

	/**
	 *  Sets the sort-by column key. This is to support sorting the row fields by a certain column. When user right
	 *  clicks on the data table, there will be a context menu with menu items like "sort ascending" or "sort
	 *  descending".
	 * 
	 *  @param sortByColumnKeys the sort-by column keys.
	 */
	public void setSortByColumnKeys(Values sortByColumnKeys) {
	}

	/**
	 *  Gets the sort-by data field index.
	 * 
	 *  @return the sort-by data field index.
	 */
	public int getSortByDataFieldModelIndex() {
	}

	/**
	 *  Sets the sort-by data field index.
	 * 
	 *  @param sortByDataFieldModelIndex a new sort-by data field index.
	 */
	public void setSortByDataFieldModelIndex(int sortByDataFieldModelIndex) {
	}

	/**
	 *  Gets the sort order of the sort-by.
	 * 
	 *  @return the sort order of the sort-by.
	 */
	public boolean isSortByAscending() {
	}

	/**
	 *  Sets the sort order of the sort-by.
	 * 
	 *  @param sortByAscending the sort order of the sort-by
	 */
	public void setSortByAscending(boolean sortByAscending) {
	}

	/**
	 *  Gets the summary type of the sort-by.
	 * 
	 *  @return the summary type of the sort-by.
	 */
	public int getSortBySummaryType() {
	}

	/**
	 *  Sets the summary type of the sort-by. It is usually the summary type of the particular row where user right
	 *  clicks to show the context menu. If the row is not a summary row, it will be the summary type of the row field.
	 * 
	 *  @param sortBySummaryType the summary type of the sort-by.
	 */
	public void setSortBySummaryType(int sortBySummaryType) {
	}

	/**
	 *  Sets the selected possible values for this field. Please note, you have to call this method after PivotTablePane
	 *  for this PivotDataModel is created.
	 *  <p/>
	 *  The method will update the table automatically. But you can call {@link PivotDataModel#setAdjusting(boolean)} to
	 *  false if you want to disable the auto-update when you need to set selected possible values on several fields. If
	 *  so, remember to call calculate() and bothHeaderUpdated() after you finished the changes.
	 *  <p/>
	 *  Please note, this method has a lower priority than {@link #setFilter(com.jidesoft.filter.Filter)} method. In the
	 *  other word, if setFilter is called with a valid filter, the (Custom...) item will be selected in the drop down
	 *  list and the selected possible values will be ignored.
	 * 
	 *  @param selectedPossibleValues new selected possible values.
	 */
	@java.lang.Override
	public void setSelectedPossibleValues(Object[] selectedPossibleValues) {
	}

	/**
	 *  Sets the filtered possible values for this field. Please note, you have to call this method after PivotTablePane
	 *  for this PivotDataModel is created.
	 *  <p/>
	 *  The method will update the table automatically. But you can call {@link PivotDataModel#setAdjusting(boolean)} to
	 *  false if you want to disable the auto-update when you need to set filtered possible values on several fields. If
	 *  so, remember to call calculate() and bothHeaderUpdated() after you finished the changes.
	 *  <p/>
	 *  Please note, this method has a lower priority than {@link #setFilter(com.jidesoft.filter.Filter)} method. In the
	 *  other word, if setFilter is called with a valid filter, the (Custom...) item will be selected in the drop down
	 *  list and the filtered possible values will be ignored.
	 * 
	 *  @param filteredPossibleValues new deselected possible values.
	 */
	@java.lang.Override
	public void setFilteredPossibleValues(Object[] filteredPossibleValues) {
	}

	public boolean isDataFieldFilterOnSummary() {
	}

	public void setDataFieldFilterOnSummary(boolean dataFieldFilterOnSummary) {
	}

	/**
	 *  Get the running summary list.
	 * 
	 *  @return the running summary list.
	 */
	public java.util.List getRunningSummaryList() {
	}

	/**
	 *  Set the running summary list.
	 * 
	 *  @param runningSummaryList the running summary list
	 */
	public void setRunningSummaryList(java.util.List runningSummaryList) {
	}

	/**
	 *  Get the flag indicating if the original calculated data columns should be hidden if there is any running
	 *  summary.
	 *  <p/>
	 *  By default the flag is false. If you want to hide the original data, you could set it to false.
	 *  <p/>
	 *  This flag will only be evaluated if the running summary list configuration is not null.
	 * 
	 *  @return true if the original calculated data columns should be hidden. Otherwise false.
	 *  @see #setRunningSummaryList(java.util.List)
	 */
	public boolean isHideOriginalData() {
	}

	/**
	 *  Set the flag indicating if the original calculated data columns should be hidden if there is any running
	 *  summary.
	 * 
	 *  @param hideOriginalData the flag
	 *  @see #isHideOriginalData()
	 */
	public void setHideOriginalData(boolean hideOriginalData) {
	}

	@java.lang.Override
	protected Object clone() {
	}

	@java.lang.Override
	public void setTitle(String title) {
	}

	/**
	 *  Gets the field to be filtered in row header table or column table header.
	 *  <p/>
	 *  This setting only takes effects if this field is a DataField.
	 * 
	 *  @return the pivot field.
	 *  @since 3.5.16
	 */
	public PivotField getFilterField() {
	}

	/**
	 *  Sets the field to be filtered in row header table or column table header.
	 *  <p/>
	 *  This setting only takes effects if this field is a DataField.
	 * 
	 *  @param filterField the pivot field
	 *  @since 3.5.16
	 */
	public void setFilterField(PivotField filterField) {
	}

	/**
	 *  Gets the base values to be evaluated to filter in row header table or column table header.
	 *  <p/>
	 *  This setting only takes effects if this field is a DataField.
	 * 
	 *  @return the base values to be evaluated to filter.
	 *  @since 3.5.16
	 */
	public Values getFilterBaseValues() {
	}

	/**
	 *  Sets the base values to be evaluated to filter in row header table or column table header.
	 *  <p/>
	 *  This setting only takes effects if this field is a DataField.
	 * 
	 *  @param filterBaseValues the base values to be evaluated to filter
	 *  @since 3.5.16
	 */
	public void setFilterBaseValues(Values filterBaseValues) {
	}

	/**
	 *  Gets the value filters.
	 *  <p/>
	 *  This setting only takes effects if this field is a DataField.
	 * 
	 *  @return the value filters
	 *  @since 3.5.16
	 */
	public Filter[] getValueFilters() {
	}

	/**
	 *  Sets the value filters.
	 *  <p/>
	 *  This setting only takes effects if this field is a DataField.
	 * 
	 *  @param valueFilters the value filters
	 *  @since 3.5.16
	 */
	public void setValueFilters(Filter[] valueFilters) {
	}

	/**
	 *  Gets if the filters are in "and" mode or "or" mode.
	 *  <p/>
	 *  This setting only takes effects if this field is a DataField.
	 * 
	 *  @return true if and mode. Otherwise or mode.
	 *  @since 3.5.16
	 */
	public boolean isAndMode() {
	}

	/**
	 *  Sets if the filters are in "and" mode or "or" mode.
	 *  <p/>
	 *  This setting only takes effects if this field is a DataField.
	 * 
	 *  @param andMode the filtering mode
	 *  @since 3.5.16
	 */
	public void setAndMode(boolean andMode) {
	}

	/**
	 *  Gets the filter editor possible values to be listed as an option in the FilterEditor.
	 *  <p/>
	 *  This setting only takes effects if this field is a DataField.
	 * 
	 *  @return the possible values.
	 *  @since 3.5.16
	 */
	public Object[] getFilterEditorPossibleValues() {
	}

	/**
	 *  Sets the filter editor possible values to be listed as an option in the FilterEditor.
	 *  <p/>
	 *  This setting only takes effects if this field is a DataField.
	 * 
	 *  @param filterEditorPossibleValues the possible values
	 *  @since 3.5.16
	 */
	public void setFilterEditorPossibleValues(Object[] filterEditorPossibleValues) {
	}
}
