/**
 *  The package contains classes for JIDE Pivot Grid product.
 */
package com.jidesoft.pivot;


/**
 *  An interface used to calculate the summary for pivot table. It extends the {@link
 *  com.jidesoft.grid.SummaryCalculator} under the grid package.
 *  <p/>
 *  This interface added extra parameters (such as PivotValueProvider, PivotField, Values for rows and columns etc.) to
 *  addValue methods in case the summary calculation needs to know about it. However in our default implementation, these
 *  extra parameters are not used.
 */
public interface PivotSummaryCalculator {

	/**
	 *  Adds a value for calculation. Different from {@link #addValue(Object)} which only takes the value as parameter,
	 *  this method provides PivotValueProvider, PivotField and row/column values of the cell as in the DataTableModel.
	 *  <p/>
	 *  To get the row indices in the original table model, please try to use the following code.
	 *  <code><pre>
	 *  ((IPivotDataModel) dataModel).getDataAt(((DefaultValues) rowValues).toCompoundKey(), ((DefaultValues)
	 *  columnValues).toCompoundKey());
	 *  </pre></code>
	 * 
	 *  @param dataModel    the PivotDataModel
	 *  @param field        the PivotField
	 *  @param rowValues    the row values corresponding to the cell to calculate.
	 *  @param columnValues the column values corresponding to the cell to calculate.
	 *  @param value        the value
	 */
	public void addValue(PivotValueProvider dataModel, PivotField field, Values rowValues, Values columnValues, Object value);

	/**
	 *  Adds a value for calculation. Different from {@link #addValue(Object)} which only takes the value as parameter,
	 *  this method provides PivotDataModel, PivotField and row/column index of the cell as in the DataTableModel.
	 * 
	 *  @param dataModel   the PivotDataModel
	 *  @param field       the PivotField
	 *  @param rowIndex    the row index as in the PivotDataModel#getDataTableModel. It could be -1 if the row index is
	 *                     not available.
	 *  @param columnIndex the column index as in the PivotDataModel#getDataTableModel. It could be -1 if the column
	 *                     index is not available.
	 *  @param value       the value
	 *  @deprecated replaced by {@link #addValue(PivotValueProvider, PivotField, Values, Values, Object)}
	 */
	@java.lang.Deprecated
	public void addValue(IPivotDataModel dataModel, PivotField field, int rowIndex, int columnIndex, Object value);

	/**
	 *  Adds a value for calculation..
	 * 
	 *  @param valueProvider the PivotValueProvider
	 *  @param field         the PivotField
	 *  @param value         the value
	 *  @deprecated replaced by {@link #addValue(PivotValueProvider, PivotField, Values, Values, Object)}
	 */
	@java.lang.Deprecated
	public void addValue(PivotValueProvider valueProvider, PivotField field, Object value);
}
