/**
 *  The package contains classes for JIDE Pivot Grid product.
 */
package com.jidesoft.pivot;


/**
 *  <tt>PivotTablePane</tt> is the main component for JIDE Pivot Grid.
 */
public class PivotTablePane extends javax.swing.JPanel implements PivotConstants, java.beans.PropertyChangeListener, PivotValueProviderListener {

	protected FieldArea _filterFieldsArea;

	protected FieldArea _dataFieldsArea;

	protected FieldArea _rowFieldsArea;

	protected FieldArea _columnFieldsArea;

	protected java.util.Map _fieldBoxMap;

	protected javax.swing.JTable _rowHeaderTable;

	protected javax.swing.JTable _columnHeaderTable;

	protected javax.swing.JTable _dataTable;

	protected javax.swing.JTable _cornerTable;

	public static final int FIELD_GAP = 2;

	protected UnassignedFieldsArea _unassignedFieldsArea;

	public static final String PROPERTY_PLAIN_HEADER_TABLES = "plainHeaderTables";

	public static final String PROPERTY_HEADER_SELECTION_MODEL = "headerSelectionModel";

	public static final String PROPERTY_GRID_COLOR = "gridColor";

	public static final String PROPERTY_FILTER_FIELD_AREA_VISIBLE = "filterFieldAreaVisible";

	public static final String PROPERTY_DATA_FIELD_AREA_VISIBLE = "dataFieldAreaVisible";

	public static final String PROPERTY_ROW_FIELD_AREA_VISIBLE = "rowFieldAreaVisible";

	public static final String PROPERTY_COLUMN_FIELD_AREA_VISIBLE = "columnFieldAreaVisible";

	public static final String PROPERTY_FIELD_CHOOSER_AREA_VISIBLE = "fieldChooserAreaVisible";

	public static final String PROPERTY_DATA_FIELD_FILTERABLE = "dataFieldFilterable";

	public static final String PROPERTY_COLUMN_FIELD_FILTERABLE = "columnFieldFilterable";

	public static final String PROPERTY_ROW_FIELD_FILTERABLE = "rowFieldFilterable";

	public static final String PROPERTY_HIDE_EXPAND_ICON_ON_SINGLE_ROW = "hideExpandIconOnSignleRow";

	public static final String PROPERTY_SCROLL_SELECTION_TO_VISIBLE = "scrollSelectionToVisible";

	public static final String PROPERTY_FLAT_LAYOUT = "flatLayout";

	public static final String PROPERTY_SHOW_FILTER_BUTTONS_ON_MOUSE_OVER = "showFilterButtonsOnMouseOver";

	public static final String PROPERTY_DATA_FIELDS_DUPLICATION_ENABLED = "dataFieldsDuplicationEnabled";

	protected javax.swing.JPanel _separator;

	protected java.awt.Container _contentPanel;

	protected javax.swing.JScrollPane _scrollPane;

	protected javax.swing.JComboBox _addToComboBox;

	protected javax.swing.JButton _addToButton;

	protected PivotField _addToComboBoxField;

	protected TableColumnAutoResizer[] _columnAutoResizer;

	protected static final String CLIENT_PROPERTY_COLUMN_MODEL_LISTENER = "PivotTablePane.columnModelListener";

	protected static final String CLIENT_PROPERTY_PROPERTY_CHANGE_LISTENER = "PivotTablePane.propertyChangeListener";

	protected static final String CLIENT_PROPERTY_COMPONENT_LISTENER = "PivotTablePane.componentListener";

	public static final String FIELD_SETTING_DIALOG_OK_BUTTON = "OptionPane.okButtonText";

	public static final String FIELD_SETTING_DIALOG_CANCEL_BUTTON = "OptionPane.cancelButtonText";

	public static final String FIELD_SETTING_DIALOG_HIDE_BUTTON = "PivotTablePane.hide";

	public static final ConverterContext CONVERTER_CONTEXT_RUNNING_TYPE;

	public static final EditorContext EDITOR_CONTEXT_RUNNING_TYPE;

	public static final ConverterContext CONVERTER_CONTEXT_PIVOT_FIELD;

	public static final EditorContext EDITOR_CONTEXT_PIVOT_FIELD;

	public static final EditorContext EDITOR_CONTEXT_COMPARE_TO;

	/**
	 *  Create an empty PivotTablePane.
	 */
	public PivotTablePane() {
	}

	/**
	 *  Creates a PivotTablePane.
	 * 
	 *  @param dataModel the pivot data model
	 */
	public PivotTablePane(IPivotDataModel dataModel) {
	}

	/**
	 *  Set the PivotDataModel. Usually you should pass in the data model through the constructor. But if you have to use
	 *  the empty constructor, you can use this method to set the data model.
	 * 
	 *  @param dataModel the pivot data model.
	 */
	public void setPivotDataModel(IPivotDataModel dataModel) {
	}

	@java.lang.Override
	public void updateUI() {
	}

	/**
	 *  Creates the panel holds the field chooser.
	 * 
	 *  @return a panel holds the field chooser.
	 */
	protected java.awt.Container createFieldPanel() {
	}

	/**
	 *  Creates the content panel that holds the pivot table and all the field areas.
	 *  <p/>
	 *  By default, the content panel will paint a light blue background in the filter/row/column field area. If you want
	 *  to change the default behavior, please override this method to create a plain JPanel. If you want to change the
	 *  color setting globally, Please use the following code.
	 *  <code><pre>
	 *           UIDefaultsLookup.put(UIManager.getDefaults(), "Theme.painter", new Office2007Painter() {
	 *  <p/>
	 *               public void paintContentBackground(JComponent c, Graphics g, Rectangle rect, int orientation, int
	 *  state) {
	 *                   Graphics2D g2d = (Graphics2D) g.create();
	 *                   g2d.setColor(Color.red);
	 *                   g2d.fillRect(rect.x, rect.y, rect.width, rect.height);
	 *                   g2d.dispose();
	 *               }
	 *           });
	 *  <p/>
	 *  </pre></code>
	 * 
	 *  @return the content panel.
	 */
	protected java.awt.Container createContentPanel() {
	}

	/**
	 *  Creates the child components.
	 */
	protected void initComponents() {
	}

	protected void initConvertersAndEditors() {
	}

	public void propertyChange(java.beans.PropertyChangeEvent evt) {
	}

	/**
	 *  Creates the FieldBoxInputListener. This is the listener added to the FieldBox to implement drag-n-drop, handle
	 *  clicks etc.
	 * 
	 *  @return FieldBoxInputListener.
	 */
	protected FieldBoxInputListener createFieldBoxInputListener() {
	}

	/**
	 *  A validation method before a field box is dropped to a target . By default, it will return true. You could
	 *  override this method to add some widgets or checking here.
	 * 
	 *  @param draggingFieldBox          the FieldBox that is currently being dragged
	 *  @param targetFieldBoxOrFieldArea the target field box or target field area. Could be null if the field box is
	 *                                   dragged outside and will be moved to the unassigned field area.
	 *  @param before                    if the second parameter is a FieldBox, this parameter indicates if the dragging
	 *                                   field box will be moved before or after the target field box.
	 *  @return true by default.
	 *  @since 3.4.1
	 */
	protected boolean validateFieldBoxDragging(FieldBox draggingFieldBox, java.awt.Component targetFieldBoxOrFieldArea, boolean before) {
	}

	public void indexChanged(IndexChangeEvent event) {
	}

	public void pivotValueProviderEventHandler(PivotValueProviderEvent event) {
	}

	/**
	 *  Creates FieldArea for different fields. Subclass can override it to create a subclass of the FieldArea or
	 *  customize the default FieldArea.
	 * 
	 *  @param areaType the area type.
	 *  @return FieldArea.
	 */
	protected FieldArea createFieldArea(int areaType) {
	}

	/**
	 *  Customizes the scroll pane for data table. You must override configureEnclosingScrollPane method of the data
	 *  table and call this method.
	 * 
	 *  @param table the data table
	 *  @see #createDataTable()
	 */
	protected void configureEnclosingScrollPaneForDataTable(javax.swing.JTable table) {
	}

	/**
	 *  Creates the table which is used for the data table. Here is the default code.
	 *  <code><pre>
	 *  protected CellStyleTable createDataTable() {
	 *      return new DataTable(this);
	 *  }
	 *  </pre></code>
	 * 
	 *  @return the data table.
	 */
	protected DataTable createDataTable() {
	}

	/**
	 *  Creates the header table for row header and column header. By default, we simple return new HeaderTable(this).
	 * 
	 *  @return a header table.
	 */
	protected HeaderTable createHeaderTable() {
	}

	/**
	 *  Gets the number of row height each row will occupy.
	 * 
	 *  @return the number of the row height each row will occupy. it returns 1 by default meaning each row is at one
	 *  full row height. Subclass can override to return more.
	 */
	protected int getAdjustedRowHeights() {
	}

	/**
	 *  Setup the layout of the field areas and the child tables.
	 * 
	 *  @param contentPanel the content panel where the whole pivot table is placed.
	 *  @param fieldsPanel  the unassigned fields panel
	 */
	protected void setupLayout(java.awt.Container contentPanel, java.awt.Container fieldsPanel) {
	}

	/**
	 *  Creates the scroll pane used by PivotTablePane. By default, we will create an instance of {@link
	 *  JideScrollPaneEx}.
	 * 
	 *  @return a scroll pane.
	 */
	protected javax.swing.JScrollPane createScrollPane() {
	}

	/**
	 *  Customizes the scroll pane. Subclass can override it to customize this scroll pane.
	 * 
	 *  @param scrollPane the scroll pane used by the pivot table.
	 */
	protected void customizeScrollPane(javax.swing.JScrollPane scrollPane) {
	}

	protected void customizeFieldsPanel(java.awt.Container panel) {
	}

	@java.lang.SuppressWarnings("UnusedDeclaration")
	public void updatePossibleValues() {
	}

	public void updatePossibleValues(FieldBox box) {
	}

	protected String getDuplicatedTitle(PivotField field) {
	}

	/**
	 *  Fills the field boxes for the unassigned fields to the UnassignedFieldsArea. By default, we add all field boxes
	 *  to UnassignedFieldsArea using a JideBoxLayout. If the filterField has filtering text and we will do the filter by
	 *  not adding the field box to the UnassignedFieldsArea. See below for the actual code for your reference.
	 *  <code><pre>
	 *  fieldsArea.removeAll();
	 *  fieldsArea.clearFieldBoxs();
	 *  fieldsArea.setLayout(new JideBoxLayout(fieldsArea, JideBoxLayout.Y_AXIS));
	 *  for (FieldBox box : boxes) {
	 *      fieldsArea.addFieldBox(box);
	 *      if (isFieldChooserFilterFieldVisible() && !filterField.matches(box.getField(),
	 *  filterField.getSearchingText())) {
	 *          continue;
	 *      }
	 *      fieldsArea.add(box);
	 *  }
	 *  fieldsArea.add(Box.createGlue(), JideBoxLayout.VARY);
	 *  fieldsArea.revalidate();
	 *  </pre></code>
	 * 
	 *  @param fieldsArea  the unassigned field area. It is a JPanel.
	 *  @param boxes       the field boxes for unassigned fields.
	 *  @param filterField the filter field for the unassigned field area.
	 */
	protected void fillUnassignedFieldArea(UnassignedFieldsArea fieldsArea, java.util.List boxes, QuickFilterField filterField) {
	}

	/**
	 *  Creates the FieldBox.
	 * 
	 *  @param field               the pivot field
	 *  @param sortArrowVisible    whether sort arrow should be visible.
	 *  @param filterButtonVisible whether the filter button should be visible.
	 *  @return a Field Box.
	 */
	protected FieldBox createFieldBox(PivotField field, boolean sortArrowVisible, boolean filterButtonVisible) {
	}

	/**
	 *  Initialize the FieldBox by adding the necessary listeners.
	 * 
	 *  @param box the field box to be initialized.
	 */
	protected void initializeFieldBox(FieldBox box) {
	}

	/**
	 *  Customizes the FieldBox. This method is called when a FieldBox is created as well as before it is added to a new
	 *  field area.
	 * 
	 *  @param box the field box to be customized.
	 */
	protected void customizeFieldBox(FieldBox box) {
	}

	/**
	 *  Uninitialize the FieldBox by removing the listeners that were added in the {@link
	 *  #initializeFieldBox(FieldBox)}.
	 * 
	 *  @param box the field box to be uninitialized.
	 */
	protected void uninitializeFieldBox(FieldBox box) {
	}

	public void selectFieldBox(FieldBox box) {
	}

	/**
	 *  Calls this method to tell the pivot table that the row header needs to be updated. For example, if you call
	 *  {@link PivotDataModel#setShowGrandTotalForRow(boolean)}, you should call this method to update the UI.
	 *  <p/>
	 *  Please note, this method implies {@link #dataTableUpdated()}.
	 */
	public void rowHeaderUpdated() {
	}

	/**
	 *  Calls this method to tell the pivot table that the column header needs to be updated. For example, if you call
	 *  {@link PivotDataModel#setShowGrandTotalForColumn(boolean)} , you should call this method to update the UI.
	 *  <p/>
	 *  Please note, this method implies {@link #dataTableUpdated()}.
	 */
	public void columnHeaderUpdated() {
	}

	/**
	 *  Sets the data table model to the data table. We exposed this method to allow user to add a wrapper table model
	 *  (such as CacheTableModel) to the table model before setting it to the data table.
	 * 
	 *  @param table      the data table
	 *  @param tableModel the data table model
	 */
	protected void setDataTableModel(javax.swing.JTable table, javax.swing.table.TableModel tableModel) {
	}

	/**
	 *  Sets the header table model to header table. We exposed this method to allow user to add a wrapper table model
	 *  (such as CacheTableModel) to the table model before setting it to the header table.
	 * 
	 *  @param table      the data table
	 *  @param tableModel the data table model
	 */
	protected void setHeaderTableModel(javax.swing.JTable table, javax.swing.table.TableModel tableModel) {
	}

	protected void setCornerTableModel(javax.swing.JTable table, javax.swing.table.TableModel tableModel) {
	}

	public static java.util.Map[] getTableColumnWidth(HeaderTable table) {
	}

	public static void setTableColumnWidth(HeaderTable table, java.util.Map[] widths) {
	}

	/**
	 *  Calls this method to tell the pivot table that both row and column header need to be updated. For example, if you
	 *  call {@link PivotDataModel#setShowGrandTotalForColumn(boolean)} and {@link PivotDataModel#setShowGrandTotalForRow(boolean)},
	 *  you should call this method to update the UI.
	 *  <p/>
	 *  Please note, this method implies {@link #dataTableUpdated()}.
	 */
	public void bothHeadersUpdated() {
	}

	/**
	 *  Calls this method to tell the pivot table that the data table needs to be repainted. This method equals to
	 *  ((DataTableModel) getPivotDataModel().getDateTableModel()).fireTableDataChanged().
	 */
	public void dataTableUpdated() {
	}

	/**
	 *  Calls this method to tell the pivot table that the fields are updated so pivot table pane needs to update so that
	 *  user can see the changes in the UI. The main reason we didn't automatically update the UI is because you might
	 *  want to update many settings then just update UI once. For example, you can get several PivotFields from
	 *  PivotDataModel, change summary type of subtotal types. After you are done changing, just call fieldsUpdated
	 *  once.
	 *  <p/>
	 *  Please note, this method is thread safe.
	 */
	public void fieldsUpdated() {
	}

	/**
	 *  Calls this method to tell the pivot table that the row fields are updated so pivot table pane needs to update so
	 *  that user can see the changes in the UI.
	 *  <p/>
	 *  Please note, this method is thread safe.
	 */
	public void rowFieldsUpdated() {
	}

	/**
	 *  Calls this method to tell the pivot table that the column fields are updated so pivot table pane needs to update
	 *  so that user can see the changes in the UI.
	 *  <p/>
	 *  Please note, this method is thread safe.
	 */
	public void columnFieldsUpdated() {
	}

	public void synchronizeFieldAreaWithColumnWidth(javax.swing.JTable table, FieldArea fieldArea) {
	}

	public void synchronizeFieldAreaTableWidth(javax.swing.JTable table, FieldArea fieldArea, FieldArea secondaryFieldArea) {
	}

	@java.lang.SuppressWarnings("UnusedDeclaration")
	public void synchronizeFieldAreaWithField(FieldBox box) {
	}

	public int getRowHeight() {
	}

	public void setRowHeight(int rowHeight) {
	}

	/**
	 *  Sets the preferred number of rows in the lists.
	 * 
	 *  @param visibleRowCount the visible row count.
	 */
	public void setVisibleRowCount(int visibleRowCount) {
	}

	/**
	 *  Returns the preferred number of visible rows.
	 * 
	 *  @return an integer indicating the preferred number of rows to display without using a scroll bar
	 */
	@java.lang.SuppressWarnings("UnusedDeclaration")
	public int getVisibleRowCount() {
	}

	@java.lang.Override
	public void paint(java.awt.Graphics g) {
	}

	@java.lang.Override
	public void setCursor(java.awt.Cursor cursor) {
	}

	/**
	 *  Hides the field box.
	 * 
	 *  @param fieldBox the field box to be hidden.
	 */
	protected void hideFieldBox(FieldBox fieldBox) {
	}

	/**
	 *  Moves the field box
	 * 
	 *  @param fieldBox the field box to be moved.
	 *  @param before   true to move it before its current position. False to move after its current position.
	 */
	protected void moveFieldBox(FieldBox fieldBox, boolean before) {
	}

	protected void moveFieldBoxToBeginning(FieldBox fieldBox) {
	}

	protected void moveFieldBoxToEnd(FieldBox fieldBox) {
	}

	protected void addFieldBox(FieldBox fieldBox, int areaType) {
	}

	protected void moveFieldBox(FieldBox fieldBox, FieldBox destFieldBox, boolean before) {
	}

	/**
	 *  Shows or hide the field chooser area.
	 * 
	 *  @param fieldChooserAreaVisible true or false.
	 */
	public void setFieldChooserVisible(boolean fieldChooserAreaVisible) {
	}

	/**
	 *  Checks if filter chooser area is visible.
	 * 
	 *  @return true if filter chooser is visible. Otherwise false.
	 */
	public boolean isFieldChooserVisible() {
	}

	/**
	 *  Gets the row header table.
	 * 
	 *  @return the row header table.
	 */
	public javax.swing.JTable getRowHeaderTable() {
	}

	/**
	 *  Gets the column header table.
	 * 
	 *  @return the column header table.
	 */
	public javax.swing.JTable getColumnHeaderTable() {
	}

	/**
	 *  Gets the data table.
	 * 
	 *  @return the data table.
	 */
	public javax.swing.JTable getDataTable() {
	}

	/**
	 *  Gets the corner table.
	 * 
	 *  @return the corner table.
	 */
	public javax.swing.JTable getCornerTable() {
	}

	/**
	 *  Gets the PivotDataModel.
	 * 
	 *  @return the PivotDataModel.
	 */
	public IPivotDataModel getPivotDataModel() {
	}

	/**
	 *  Gets an optional version string.
	 * 
	 *  @return version string.
	 */
	public String getVersion() {
	}

	/**
	 *  Sets version string.
	 * 
	 *  @param version the version of the saved layout.
	 */
	public void setVersion(String version) {
	}

	protected void showPopup(java.awt.Point p) {
	}

	/**
	 *  Shows the field setting dialog.
	 * 
	 *  @param fieldBox the field box for which the field settings dialog is for.
	 */
	protected void showFieldSettingsDialog(FieldBox fieldBox) {
	}

	/**
	 *  Create the custom filter editor dialog. This is the dialog that will be used as when the "custom filter" is
	 *  chosen in the filterable FieldBox. Subclass can override this method to create your own dialog.
	 * 
	 *  @param container    the container of the dialog
	 *  @param title        the title of the dialog
	 *  @param filterEditor the corresponding filter editor of the dialog
	 *  @return the CustomFilterEditorDialog instance.
	 */
	protected CustomFilterEditorDialog createCustomFilterEditorDialog(java.awt.Container container, String title, CustomFilterEditor filterEditor) {
	}

	/**
	 *  Creates the field settings panel. This is the panel that will be used as the content pane of the field setting
	 *  dialog. Subclass can override this method to create your own field settings panel.
	 * 
	 *  @return the field settings panel.
	 */
	protected FieldSettingsPanel createFieldSettingsPanel() {
	}

	/**
	 *  Creates the button panel in field settings dialog. This is the panel that will be used as the button pane of the
	 *  field setting dialog. Subclass can override this method to create your own button panel or change the font of the
	 *  buttons.
	 *  <p/>
	 *  By default, we have three buttons: ok, cancel and hide. You can retreive them by getName(). Their names are:
	 *  <p/>
	 *  <code>FIELD_SETTING_DIALOG_OK_BUTTON</code> <code>FIELD_SETTING_DIALOG_CANCEL_BUTTON</code>
	 *  <code>FIELD_SETTING_DIALOG_HIDE_BUTTON</code>
	 * 
	 *  @param dialog the FieldSettingDialog instance
	 *  @return the button panel of the field settings dialog.
	 */
	protected ButtonPanel createFieldSettingsDialogButtonPanel(StandardDialog dialog) {
	}

	/**
	 *  Gets the popup menu customizer to customize the menu when user right click on the fields.
	 * 
	 *  @return the popup menu customizer.
	 */
	public PivotTablePane.PopupMenuCustomizer getPopupMenuCustomizer() {
	}

	/**
	 *  Sets the popup menu customizer to customize the menu when user right click on the fields.
	 * 
	 *  @param popupMenuCustomizer a new PopupMenuCustomizer.
	 */
	public void setPopupMenuCustomizer(PivotTablePane.PopupMenuCustomizer popupMenuCustomizer) {
	}

	/**
	 *  Gets the popup menu customizer to customize the menu when user right click on the row or column header tables.
	 * 
	 *  @return the popup menu customizer.
	 */
	public PivotTablePane.PopupMenuCustomizer getHeaderTablePopupMenuCustomizer() {
	}

	/**
	 *  Sets the popup menu customizer to customize the menu when user right click on the row or column header tables.
	 *  <p/>
	 *  If you want more concise control over the popup menu, please let your class implement {@link
	 *  com.jidesoft.pivot.PivotTablePane.TablePopupMenuCustomizer}. In that case, TablePopupMenuCustomizer will be
	 *  invoked instead of PopupMenuCustomizer.
	 * 
	 *  @param popupMenuCustomizer a new PopupMenuCustomizer.
	 */
	public void setHeaderTablePopupMenuCustomizer(PivotTablePane.PopupMenuCustomizer popupMenuCustomizer) {
	}

	/**
	 *  Gets the popup menu customizer to customize the menu when user right click on the data table.
	 * 
	 *  @return the popup menu customizer.
	 */
	public PivotTablePane.PopupMenuCustomizer getDataTablePopupMenuCustomizer() {
	}

	/**
	 *  Sets the popup menu customizer to customize the menu when user right click on the data table.
	 *  <p/>
	 *  If you want more concise control over the popup menu, please let your class implement {@link
	 *  com.jidesoft.pivot.PivotTablePane.TablePopupMenuCustomizer}. In that case, TablePopupMenuCustomizer will be
	 *  invoked instead of PopupMenuCustomizer.
	 * 
	 *  @param popupMenuCustomizer a new PopupMenuCustomizer.
	 */
	@java.lang.SuppressWarnings("UnusedDeclaration")
	public void setDataTablePopupMenuCustomizer(PivotTablePane.PopupMenuCustomizer popupMenuCustomizer) {
	}

	public static String getAreaName(java.util.Locale locale, int areaType) {
	}

	/**
	 *  Gets the summary count.
	 * 
	 *  @return the summary count.
	 *  @deprecated Moved to {@link com.jidesoft.grid.SummaryCalculator}. Keep this method here for backward
	 *  compatibility
	 */
	@java.lang.Deprecated
	public static int getSummaryCount() {
	}

	/**
	 *  Gets the summary name based on the locale and the summary type
	 * 
	 *  @param locale      the locale
	 *  @param summaryType the summary type
	 *  @return the summary name.
	 *  @deprecated Moved to {@link com.jidesoft.grid.SummaryCalculator}. Keep this method here for backward
	 *  compatibility
	 */
	@java.lang.Deprecated
	public static String getSummaryName(java.util.Locale locale, int summaryType) {
	}

	@java.lang.Override
	public void setLocale(java.util.Locale l) {
	}

	/**
	 *  Checks if the field chooser panel is enabled. If true, user can right click on any field or field area and select
	 *  "Show Field List" from the popup menu to see the field chooser.
	 * 
	 *  @return true if the field chooser is enabled.
	 */
	public boolean isFieldChooserEnabled() {
	}

	/**
	 *  Sets whether the field chooser panel is enabled. Please note, even if it is disable, you can still call {@link
	 *  #setFieldChooserVisible(boolean)} and set it to true to show it. However end users will not be able to access it
	 *  through the default user interface when it is disabled.
	 * 
	 *  @param fieldChooserEnabled true or false.
	 */
	public void setFieldChooserEnabled(boolean fieldChooserEnabled) {
	}

	public boolean isRearrangable() {
	}

	/**
	 *  Sets the rearrangable flag. If true (default), user can drag the fields and rearrange it. If false, the field
	 *  layout can only be setup by API. User will not be able to change it.
	 * 
	 *  @param rearrangable true or false.
	 */
	public void setRearrangable(boolean rearrangable) {
	}

	/**
	 *  Gets the panel for the add to combobox on FieldChooser.
	 * 
	 *  @return the panel.
	 */
	@java.lang.SuppressWarnings("UnusedDeclaration")
	public javax.swing.JPanel getFieldChooserComboBoxPanel() {
	}

	/**
	 *  Shows or hides the quick filter field which is used to filter the field chooser.
	 * 
	 *  @param visible true or false.
	 */
	public void setFieldChooserFilterFieldVisible(boolean visible) {
	}

	/**
	 *  Checks if the the quick filter field which is used to filter the field chooser is visible.
	 * 
	 *  @return true if visible. Otherwise, false.
	 */
	public boolean isFieldChooserFilterFieldVisible() {
	}

	/**
	 *  Gets the row field boxes' width as an int array.
	 * 
	 *  @return the field boxes width.
	 */
	public int[] getRowFieldsWidth() {
	}

	/**
	 *  Auto-resize all table's table column width so that all cell contents are visible.
	 */
	public void autoResizeAllColumns() {
	}

	/**
	 *  Auto-resize all table's table column width so that all cell contents are visible. But different from {@link
	 *  #autoResizeAllColumns()}, this method will resize the visible area only if the parameter is true.
	 * 
	 *  @param visibleAreaOnly true to resize to make the visible cells' content visible.
	 */
	public void autoResizeAllColumns(boolean visibleAreaOnly) {
	}

	/**
	 *  Gets the unassigned field chooser. By default, we will add this panel to BorderLayout.AFTER_LINE_ENDS of a
	 *  BorderLayout panel. You can get it and add it to another panel as long as it is in the same window as the
	 *  PivotTablePane. The {@link #setFieldChooserVisible(boolean)} will simply call setVisible on this field chooser.
	 *  So if you add the field chooser to somewhere else, you need to make sure you response to this call (using
	 *  ComponentListener) and do the right thing to hide the field chooser.
	 * 
	 *  @return the unassigned field chooser.
	 */
	@java.lang.SuppressWarnings("UnusedDeclaration")
	public java.awt.Container getFieldChooser() {
	}

	/**
	 *  Gets the grid color that is used to paint the grid of the header tables and the data table.
	 * 
	 *  @return the grid color.
	 */
	public java.awt.Color getGridColor() {
	}

	/**
	 *  Sets the grid color that is used to paint the grid of the header tables and the data table.
	 * 
	 *  @param gridColor the grid color of the data table.
	 */
	public void setGridColor(java.awt.Color gridColor) {
	}

	/**
	 *  Get the flag indicating the header table painting mode.
	 *  <p/>
	 *  Before release 2.6.4, setting this flag to true also means you can select the cells in the header table.
	 *  Meanwhile, setting this flag to false means you cannot select the cells in the header table.
	 *  <p/>
	 *  Since release 2.6.5, we add a new flag headerSelectionMode. So if you were using plain table header and wish to
	 *  get the original behavior, you also need invoke <code>setHeaderSelectionMode</code> method.
	 *  <p/>
	 * 
	 *  @return true if you want the l&f of the header table be the same with the data table. Otherwise false.
	 *  @see #setHeaderSelectionMode(int)
	 *  @see #getHeaderSelectionMode()
	 */
	public boolean isPlainHeaderTables() {
	}

	/**
	 *  Set the flag indicating the header table painting mode.
	 *  <p/>
	 * 
	 *  @param plainHeaderTables the flag
	 *  @see #isPlainHeaderTables()
	 */
	public void setPlainHeaderTables(boolean plainHeaderTables) {
	}

	public boolean isFilterFieldAreaVisible() {
	}

	public void setFilterFieldAreaVisible(boolean filterFieldAreaVisible) {
	}

	public boolean isColumnFieldAreaVisible() {
	}

	public void setColumnFieldAreaVisible(boolean columnFieldAreaVisible) {
	}

	public boolean isRowFieldAreaVisible() {
	}

	public void setRowFieldAreaVisible(boolean rowFieldAreaVisible) {
	}

	public boolean isDataFieldAreaVisible() {
	}

	public void setDataFieldAreaVisible(boolean dataFieldAreaVisible) {
	}

	public String getFieldAreaMessage(int areaType) {
	}

	public String getFieldAreaName(int areaType) {
	}

	public int getFieldAreaType(String name) {
	}

	/**
	 *  Checks if the data field filterable. If true, you will see a filter button on the FieldBox for data fields.
	 * 
	 *  @return true or false.
	 */
	public boolean isDataFieldFilterable() {
	}

	/**
	 *  Sets the data field filterable flag. If true, you will see a filter button on the FieldBox for data fields. By
	 *  default, it is false.
	 * 
	 *  @param dataFieldFilterable true or false.
	 */
	public void setDataFieldFilterable(boolean dataFieldFilterable) {
	}

	/**
	 *  Checks if the row field filterable. If true, you will see a filter button on the FieldBox for row fields.
	 * 
	 *  @return true or false.
	 */
	public boolean isRowFieldFilterable() {
	}

	/**
	 *  Sets the row field filterable flag. If true, you will see a filter button on the FieldBox for row fields. By
	 *  default, it is true.
	 * 
	 *  @param rowFieldFilterable true or false.
	 */
	public void setRowFieldFilterable(boolean rowFieldFilterable) {
	}

	/**
	 *  Checks if the column field filterable. If true, you will see a filter button on the FieldBox for column fields.
	 * 
	 *  @return true or false.
	 */
	public boolean isColumnFieldFilterable() {
	}

	/**
	 *  Sets the column field filterable flag. If true, you will see a filter button on the FieldBox for column fields.
	 *  By default, it is true.
	 * 
	 *  @param columnFieldFilterable true or false.
	 */
	public void setColumnFieldFilterable(boolean columnFieldFilterable) {
	}

	public boolean isSelectedHeaderFilterable(boolean isRowHeader, int fromRow, int toRow, int fromColumn, int toColumn) {
	}

	/**
	 *  check if the selected field have some rows/columns filtered already
	 * 
	 *  @param isRowHeader If it is true, it means it is triggered by a rowHeaderTable, otherwise columnHeaderTable
	 *  @param fromRow     selected minimum row index
	 *  @param toRow       selected maximum row index
	 *  @param fromColumn  selected minimum column index
	 *  @param toColumn    selected maximum column index
	 *  @return if the selected fields are in filtering mode. True if some rows or columns are filtered. Otherwise false.
	 */
	public boolean isFiltering(boolean isRowHeader, int fromRow, int toRow, int fromColumn, int toColumn) {
	}

	/**
	 *  clear current filters in the selected fields
	 * 
	 *  @param isRowHeader If it is true, it means it is triggered by a rowHeaderTable, otherwise columnHeaderTable
	 *  @param fromRow     selected minimum row index
	 *  @param toRow       selected maximum row index
	 *  @param fromColumn  selected minimum column index
	 *  @param toColumn    selected maximum column index
	 */
	public void clearFilter(boolean isRowHeader, int fromRow, int toRow, int fromColumn, int toColumn) {
	}

	/**
	 *  filter the selected header values or show only the selected header values
	 * 
	 *  @param isRowHeader     If it is true, it means it is triggered by a rowHeaderTable, otherwise columnHeaderTable
	 *  @param isFilterNotShow If it is true, it means it is that the selected values to be filtered, otherwise the
	 *                         selected values to be showed
	 *  @param fromRow         selected minimum row index
	 *  @param toRow           selected maximum row index
	 *  @param fromColumn      selected minimum column index
	 *  @param toColumn        selected maximum column index
	 */
	@java.lang.SuppressWarnings("UnusedDeclaration")
	public void filterSelectedHeaderValues(boolean isRowHeader, boolean isFilterNotShow, int fromRow, int toRow, int fromColumn, int toColumn) {
	}

	/**
	 *  Selects the data cells based on the selection in the row header or column header.
	 * 
	 *  @param isRowHeader true or false.
	 *  @param rowIndex    the cell row index of the header table.
	 *  @param columnIndex the cell column index of the header table.
	 */
	public void selectDataCells(boolean isRowHeader, int rowIndex, int columnIndex) {
	}

	/**
	 *  Selects the data cells based on the selection in the row header or column header.
	 * 
	 *  @param isRowHeader true or false.
	 *  @param rowIndex    the cell row index of the header table.
	 *  @param columnIndex the cell column index of the header table.
	 *  @param toggle      the flag to indicate if the selection should be toggled.
	 *  @since 3.3.4
	 */
	protected void selectDataCells(boolean isRowHeader, int rowIndex, int columnIndex, boolean toggle) {
	}

	/**
	 *  Selects the data cells based on the selection in multiple row headers or column headers.
	 * 
	 *  @param isRowHeader      true or false.
	 *  @param startRowIndex    the start cell row index of the header table.
	 *  @param startColumnIndex the start cell column index of the header table.
	 *  @param endRowIndex      the end cell row index of the header table.
	 *  @param endColumnIndex   the end cell column index of the header table.
	 */
	public void selectDataCellsBetween(boolean isRowHeader, int startRowIndex, int startColumnIndex, int endRowIndex, int endColumnIndex) {
	}

	/**
	 *  Selects the data cells based on the selection in multiple row headers or column headers.
	 * 
	 *  @param isRowHeader      true or false.
	 *  @param startRowIndex    the start cell row index of the header table.
	 *  @param startColumnIndex the start cell column index of the header table.
	 *  @param endRowIndex      the end cell row index of the header table.
	 *  @param endColumnIndex   the end cell column index of the header table.
	 *  @param toggle           the flag to indicate if the selection should be toggled.
	 *  @since 3.3.4
	 */
	protected void selectDataCellsBetween(boolean isRowHeader, int startRowIndex, int startColumnIndex, int endRowIndex, int endColumnIndex, boolean toggle) {
	}

	/**
	 *  Check if the column in DataTable is hidden.
	 * 
	 *  @param columnIndex the column index in DataTable.
	 *  @return true if the column is hidden. Otherwise false.
	 */
	public boolean isColumnHidden(int columnIndex) {
	}

	/**
	 *  Hide the columns in DataTable.
	 * 
	 *  @param columnIndices the column index array to be hidden
	 */
	public void hideColumns(int[] columnIndices) {
	}

	/**
	 *  Show the columns in DataTable.
	 * 
	 *  @param columnIndices the column index array to be shown
	 */
	public void showColumns(int[] columnIndices) {
	}

	/**
	 *  Hides the column or the row based on the row index and column index in the row header or column header.
	 *  <p/>
	 *  We can only hide the normal values in row field or column field. Data fields hiding is not supported. Summary
	 *  Values hiding and Grand Total Values hiding are not supported as well
	 * 
	 *  @param isRowHeader true or false.
	 *  @param rowIndex    the cell row index of the header table.
	 *  @param columnIndex the cell column index of the header table.
	 */
	public void hideValuesAt(boolean isRowHeader, int rowIndex, int columnIndex) {
	}

	/**
	 *  Shows or hides the values based on the selection in the row header or column header.
	 *  <p/>
	 *  Please note, this method is thread safe.
	 * 
	 *  @param values the Values to be shown or hide.
	 */
	public void addHiddenValues(Values values) {
	}

	/**
	 *  Clear hidden header fields.
	 * 
	 *  @see #addHiddenRowField(PivotField)
	 */
	public void clearHiddenRowFields() {
	}

	/**
	 *  Remove hidden header field.
	 * 
	 *  @param field the row field to be hidden
	 *  @see #addHiddenRowField(PivotField)
	 */
	@java.lang.SuppressWarnings("UnusedDeclaration")
	public void removeHiddenRowField(PivotField field) {
	}

	/**
	 *  Add hidden header field. It will just be hidden in the UI while the row field staying in effective.
	 * 
	 *  @param field the row field to be hidden
	 */
	public void addHiddenRowField(PivotField field) {
	}

	/**
	 *  Get all hidden row fields.
	 * 
	 *  @return all hidden row fields.
	 */
	public PivotField[] getHiddenRowFields() {
	}

	/**
	 *  Shows or hides the values based on the selection in the row header or column header.
	 *  <p/>
	 *  Please note, this method is thread safe.
	 * 
	 *  @param values the Values to be shown or hide.
	 */
	@java.lang.SuppressWarnings("UnusedDeclaration")
	public void removeHiddenValues(Values values) {
	}

	/**
	 *  Shows all the hidden values.
	 *  <p/>
	 *  Please note, this method is thread safe.
	 */
	public void clearHiddenValues() {
	}

	/**
	 *  Gets the scroll pane used by PivotTablePane.
	 * 
	 *  @return the scroll pane used by PivotTablePane.
	 */
	public javax.swing.JScrollPane getScrollPane() {
	}

	/**
	 *  Gets the resource string used in PivotTablePane. Subclass can override it to provide their own strings. There are
	 *  exceptions to the field area name and summary name which you have to override {@link
	 *  #getAreaName(java.util.Locale, int)} and {@link #getSummaryName(java.util.Locale, int)} to provide a different
	 *  string although they are also defined in the resource bundle.
	 * 
	 *  @param key the resource key
	 *  @return the localized string.
	 */
	public String getResourceString(String key) {
	}

	/**
	 *  Converters the element to string and used in FieldBox. By default, if the value is Filter.ALL, we will convert it
	 *  to GridResource.getResourceBundle(locale).getString("Filter.all"). If the value is Filter.NULL or null, we will
	 *  convert it to GridResource.getResourceBundle(locale).getString("Filter.null"). Otherwise, we will use
	 *  ObjectConverterManager to do the conversion.
	 * 
	 *  @param locale  the locale
	 *  @param value   the value
	 *  @param clazz   the type
	 *  @param context the converter context.
	 *  @return the String converted from the value.
	 */
	public String convertElementToString(java.util.Locale locale, Object value, Class clazz, ConverterContext context) {
	}

	/**
	 *  If true, it will shrink the data field area so that it doesn't go wider than the row header table. if false, the
	 *  data field area will show all data field boxes in full width.
	 * 
	 *  @return true or false.
	 */
	public boolean isShrinkDataFieldArea() {
	}

	/**
	 *  If true, it will shrink the data field area so that it doesn't go wider than the row header table. if false, the
	 *  data field area will show all data field boxes in full width.
	 * 
	 *  @param shrinkDataFieldArea true or false.
	 */
	public void setShrinkDataFieldArea(boolean shrinkDataFieldArea) {
	}

	/**
	 *  Checks if the field box will be hidden when user drags it and drop outside the field areas. It is true by
	 *  default.
	 * 
	 *  @return true or false.
	 */
	public boolean isHideFieldOnDraggingOut() {
	}

	/**
	 *  Sets the flag if dragging a field box outside the field area will hide the field. It is true by default. If you
	 *  set it to false, your user can still hide it by right click to show the popup menu which has a "Hide" menu item
	 *  or drag it to the unassigned field area to hide it.
	 * 
	 *  @param hideFieldOnDraggingOut true or false.
	 */
	public void setHideFieldOnDraggingOut(boolean hideFieldOnDraggingOut) {
	}

	/**
	 *  Checks if the filter icon should be visible on the FieldBox when there is filter for a field.
	 * 
	 *  @return true or false.
	 */
	public boolean isShowFilterIcon() {
	}

	/**
	 *  Sets the flag to show the filter icon.
	 * 
	 *  @param showFilterIcon true or false.
	 */
	public void setShowFilterIcon(boolean showFilterIcon) {
	}

	/**
	 *  Sets the filter icon. This icon is displayed on the FieldBox when there is filter if {@link #isShowFilterIcon()}
	 *  returns true.
	 * 
	 *  @param filterIcon a new filter icon.
	 */
	@java.lang.SuppressWarnings("UnusedDeclaration")
	public void setFilterIcon(javax.swing.Icon filterIcon) {
	}

	/**
	 *  Gets the filter icon. This icon is displayed on the FieldBox when there is filter if {@link #isShowFilterIcon()}
	 *  returns true.
	 * 
	 *  @return the filter icon.
	 */
	public javax.swing.Icon getFilterIcon() {
	}

	/**
	 *  This is an internally used flag.
	 * 
	 *  @param keepFieldAreaFit true or false.
	 */
	@java.lang.SuppressWarnings("UnusedDeclaration")
	protected void setKeepFieldAreaFit(boolean keepFieldAreaFit) {
	}

	/**
	 *  Gets the filter fields area that contains the FieldBoxes for filter fields.
	 * 
	 *  @return the filter fields area.
	 */
	@java.lang.SuppressWarnings("UnusedDeclaration")
	public FieldArea getFilterFieldsArea() {
	}

	/**
	 *  Gets the data fields area that contains the FieldBoxes for data fields.
	 * 
	 *  @return the data fields area.
	 */
	public FieldArea getDataFieldsArea() {
	}

	/**
	 *  Gets the row fields area that contains the FieldBoxes for row fields.
	 * 
	 *  @return the row fields area.
	 */
	public FieldArea getRowFieldsArea() {
	}

	/**
	 *  Gets the column fields area that contains the FieldBoxes for column fields.
	 * 
	 *  @return the column fields area.
	 */
	public FieldArea getColumnFieldsArea() {
	}

	/**
	 *  Checks if the columns are auto-resizable. If the columns are auto-resizable, user can double click on the grid
	 *  line on column table header and the table column will automatically resize to fit in the content of all the cells
	 *  in that column.
	 * 
	 *  @return true if the columns are auto-resizable.
	 */
	public boolean isColumnAutoResizable() {
	}

	/**
	 *  Enable or disable the column auto-resizable.
	 * 
	 *  @param resizable true to make columns auto-resizable.
	 */
	public void setColumnAutoResizable(boolean resizable) {
	}

	/**
	 *  Get the flag if it should consider row field width while auto resizing the row header table columns.
	 * 
	 *  @return the flag.
	 */
	public boolean isConsiderRowFieldWidth() {
	}

	/**
	 *  Set the flag if it should consider row field width while auto resizing the row header table columns.
	 * 
	 *  @param considerRowFieldWidth the flag
	 */
	public void setConsiderRowFieldWidth(boolean considerRowFieldWidth) {
	}

	/**
	 *  Get the cursor to be displayed when the field is going to be removed from current area.
	 * 
	 *  @return the cursor.
	 */
	public java.awt.Cursor getDragRemoveCursor() {
	}

	/**
	 *  Set the cursor to be displayed when the field is going to be removed from current area.
	 * 
	 *  @param dragRemoveCursor the cursor.
	 */
	@java.lang.SuppressWarnings("UnusedDeclaration")
	public void setDragRemoveCursor(java.awt.Cursor dragRemoveCursor) {
	}

	/**
	 *  Get the cursor to be displayed when the field is prohibited to be dropped into current area.
	 *  <p/>
	 * 
	 *  @return the cursor.
	 *  @see com.jidesoft.pivot.FieldBoxInputListener#isDropAllowed(java.awt.Component, java.awt.Rectangle, int,
	 *  java.awt.Container)
	 */
	public java.awt.Cursor getDragNoDropCursor() {
	}

	/**
	 *  Set the cursor to be displayed when the field is prohibited to be dropped into current area.
	 *  <p/>
	 * 
	 *  @param dragNoDropCursor the cursor.
	 *  @see com.jidesoft.pivot.FieldBoxInputListener#isDropAllowed(java.awt.Component, java.awt.Rectangle, int,
	 *  java.awt.Container)
	 */
	@java.lang.SuppressWarnings("UnusedDeclaration")
	public void setDragNoDropCursor(java.awt.Cursor dragNoDropCursor) {
	}

	/**
	 *  Get the flag indicating if the column width will respect the preferred width defined in PivotField.
	 *  <p/>
	 *  By default, this flag is false to keep the original behavior. You can set it to true if you want to adjust the
	 *  width of the table by setting the preferred width in PivotField.
	 * 
	 *  @return true if you want the column width in PivotTablePane respect the preferred width in PivotField. Otherwise
	 *  false.
	 */
	public boolean isRespectFieldPreferredWidth() {
	}

	/**
	 *  Set the flag indicating if the column width will respect the preferred width defined in PivotField.
	 *  <p/>
	 * 
	 *  @param respectFieldPreferredWidth the flag
	 */
	public void setRespectFieldPreferredWidth(boolean respectFieldPreferredWidth) {
	}

	/**
	 *  Get the flag indicating the selection mode while clicking on the header table.
	 *  <p/>
	 * 
	 *  @return the flag which would be <code>PivotConstants.HEADER_SELECTION_DATA_TABLE_ONLY</code> or
	 *  <code>PivotConstants.HEADER_SELECTION_HEADER_TABLE_ONLY</code>.
	 *  @see com.jidesoft.pivot.PivotConstants#HEADER_SELECTION_DATA_TABLE_ONLY
	 *  @see com.jidesoft.pivot.PivotConstants#HEADER_SELECTION_HEADER_TABLE_ONLY
	 */
	public int getHeaderSelectionMode() {
	}

	/**
	 *  Set the flag indicating the selection mode while clicking on the header table.
	 * 
	 *  @param headerSelectionMode the flag
	 */
	public void setHeaderSelectionMode(int headerSelectionMode) {
	}

	/**
	 *  Get the flag indicating if the expand icon should be hidden if the row only contains one child.
	 *  <p/>
	 *  By default, the value is true, which is a different behavior with the release earlier than 2.8.3. You could set
	 *  this flag to false if you want to keep the original behavior.
	 * 
	 *  @return true if the expand icon should be hidden in one child row scenario. Otherwise false.
	 */
	public boolean isHideExpandIconOnSingleRow() {
	}

	/**
	 *  Set the flag indicating if the expand icon should be hidden if the row only contains one child.
	 * 
	 *  @param hideExpandIconOnSingleRow the flag
	 *  @see #isHideExpandIconOnSingleRow()
	 */
	@java.lang.SuppressWarnings("UnusedDeclaration")
	public void setHideExpandIconOnSingleRow(boolean hideExpandIconOnSingleRow) {
	}

	/**
	 *  Stops the cell editing in case the tables in PivotTablePane is in editing mode.
	 */
	public void stopCellEditing() {
	}

	/**
	 *  Get the flag indicating if PivotTablePane should scroll the selection to visible while loading selections. The
	 *  loading selection behavior happens each time field rearrangement, expanding/expanding, sorting, etc.
	 *  <p/>
	 *  The default value of this flag is true.
	 * 
	 *  @return true if selection should be scrolled to visible. Otherwise false.
	 *  @see #setScrollSelectionToVisible(boolean)
	 */
	public boolean isScrollSelectionToVisible() {
	}

	/**
	 *  Set the flag indicating if PivotTablePane should scroll the selection to visible while loading selections.
	 * 
	 *  @param scrollSelectionToVisible the flag
	 */
	public void setScrollSelectionToVisible(boolean scrollSelectionToVisible) {
	}

	/**
	 *  Gets the flag indicating if the flat layout is in use.
	 * 
	 *  @return true if the flag layout is in use. Otherwise false.
	 *  @see #setFlatLayout(boolean)
	 *  @since 3.3.3
	 */
	public boolean isFlatLayout() {
	}

	/**
	 *  Sets the flag indicating if the flat layout is in use.
	 *  <p/>
	 *  By default, this flag is false to keep backward compatibility. If you have a very long list of row fields, please
	 *  consider set this flag to true so that the row header table would also be able to be scrolled.
	 * 
	 *  @param flatLayout the flag
	 *  @since 3.3.3
	 */
	public void setFlatLayout(boolean flatLayout) {
	}

	/**
	 *  Gets the flag indicating if the context menu in DataTable will allow sort by row.
	 * 
	 *  @return true if allows. Otherwise false
	 *  @see #setAllowSortByRow(boolean)
	 *  @since 3.5.16
	 */
	public boolean isAllowSortByRow() {
	}

	/**
	 *  Sets the flag indicating if the context menu in DataTable will allow sort by row.
	 *  <p/>
	 *  By default, the value is false to not disturbing the existing customers with new menus.
	 * 
	 *  @param sortByRow the flag
	 *  @since 3.5.16
	 */
	public void setAllowSortByRow(boolean sortByRow) {
	}

	/**
	 *  Save the selection of the DataTable part of the PivotTablePane as an array of Values. It works for all cases
	 *  either row selection is allowed or column selection or cell selection is allowed. However you cannot change the
	 *  row/column selection allowed attribute for DataTable between saveSelection and loadSelection.
	 * 
	 *  @return selection as an array
	 */
	public Object[] saveSelection() {
	}

	/**
	 *  Restore the selection in the DataTable part of the PivotTablePane. It must use the array created by
	 *  saveSelection.
	 * 
	 *  @param selectedKeyValues an Values array created by saveSelection
	 */
	public void loadSelection(Object[] selectedKeyValues) {
	}

	/**
	 *  Restore the selection in the DataTable part of the PivotTablePane. It must use the array created by
	 *  saveSelection.
	 * 
	 *  @param selectedKeyValues        an Values array created by saveSelection
	 *  @param scrollSelectionToVisible if the DataTable is row selection mode and this flag is true, this method will
	 */
	public void loadSelection(Object[] selectedKeyValues, boolean scrollSelectionToVisible) {
	}

	/**
	 *  Restore the selection in the DataTable part of the PivotTablePane. It must use the array created by
	 *  saveSelection.
	 * 
	 *  @param selectedKeyValues        an Values array created by saveSelection
	 *  @param scrollSelectionToVisible if the DataTable is row selection mode and this flag is true, this method will
	 *                                  scroll
	 *  @param selectParentNode         if load selection should find its parent node if the pre-selected node is
	 *                                  collapsed
	 */
	public void loadSelection(Object[] selectedKeyValues, boolean scrollSelectionToVisible, boolean selectParentNode) {
	}

	/**
	 *  Gets the flag indicating if the filter buttons in FieldBox should be displayed always or only when the mouse is
	 *  over the button.
	 * 
	 *  @return true if the filter buttons should only be displayed when the mouse is over the button. Otherwise false.
	 *  @see #setShowFilterButtonsOnMouseOver(boolean)
	 *  @since 3.4.0
	 */
	public boolean isShowFilterButtonsOnMouseOver() {
	}

	/**
	 *  Sets the flag indicating if the filter buttons in FieldBox should be displayed always or only when the mouse is
	 *  over the button.
	 *  <p/>
	 *  By default, the value is false to keep the default behavior backward compatibility.
	 * 
	 *  @param showFilterButtonsOnMouseOver the flag
	 *  @since 3.4.0
	 */
	public void setShowFilterButtonsOnMouseOver(boolean showFilterButtonsOnMouseOver) {
	}

	/**
	 *  Gets the flag indicating if the data fields could be duplicated.
	 * 
	 *  @return true if the data fields could be duplicated. Otherwise false.
	 *  @see #setDataFieldsDuplicationEnabled(boolean)
	 *  @since 3.4.1
	 */
	public boolean isDataFieldsDuplicationEnabled() {
	}

	/**
	 *  Sets the flag indicating if the data fields could be duplicated.
	 *  <p/>
	 *  By default, the flag is false.
	 * 
	 *  @param dataFieldsDuplicationEnabled the flag
	 *  @since 3.4.1
	 */
	public void setDataFieldsDuplicationEnabled(boolean dataFieldsDuplicationEnabled) {
	}

	public static interface class PopupMenuCustomizer {


		public void customize(javax.swing.JPopupMenu menu, java.awt.Component target) {
		}
	}

	public static interface class TablePopupMenuCustomizer {


		public void customize(javax.swing.JPopupMenu menu, java.awt.Component target, int rowIndex, int columnIndex) {
		}
	}

	protected static class JideScrollPaneEx {


		protected PivotTablePane.JideScrollPaneEx() {
		}

		@java.lang.Override
		protected javax.swing.JViewport createViewport() {
		}

		@java.lang.Override
		public void setUI(javax.swing.plaf.ScrollPaneUI ui) {
		}
	}
}
