/**
 *  The package contains classes for JIDE Pivot Grid product.
 */
package com.jidesoft.pivot;


/**
 *  A helper class that can support persist PivotTablePane's layout to/from xml file.
 */
public class PivotTablePersistenceUtils {

	public PivotTablePersistenceUtils() {
	}

	/**
	 *  Saves the PivotTablePane's layout to a file.
	 * 
	 *  @param pivot    the PivotTablePane
	 *  @param fileName the file name
	 *  @throws ParserConfigurationException if a DocumentBuilder cannot be created which satisfies the configuration
	 *  @throws IOException                  If the pathname argument is null or any IO errors happen
	 */
	public static void save(PivotTablePane pivot, String fileName) {
	}

	/**
	 *  Saves the PivotTablePane's layout to an output stream.
	 * 
	 *  @param pivot the PivotTablePane
	 *  @param out   the output stream
	 *  @throws ParserConfigurationException if a DocumentBuilder cannot be created which satisfies the configuration
	 *  @throws IOException                  If the pathname argument is null or any IO errors happen
	 */
	public static void save(PivotTablePane pivot, java.io.OutputStream out) {
	}

	/**
	 *  Saves the PivotTablePane's layout to an XML Document
	 * 
	 *  @param pivot the PivotTablePane
	 *  @return XML Document which has the PivotTablePane's layout.
	 *  @throws ParserConfigurationException if a DocumentBuilder cannot be created which satisfies the configuration
	 */
	public static org.w3c.dom.Document save(PivotTablePane pivot) {
	}

	/**
	 *  Saves the PivotTablePane's layout to a file.
	 * 
	 *  @param pivot    the PivotTablePane
	 *  @param fileName the file name
	 *  @param callback The callback which will be called when saving each element to the XML document.
	 *  @throws ParserConfigurationException if a DocumentBuilder cannot be created which satisfies the configuration
	 *  @throws IOException                  If the pathname argument is null or any IO errors happen
	 */
	public static void save(PivotTablePane pivot, String fileName, PersistenceUtilsCallback.Save callback) {
	}

	/**
	 *  Saves the PivotTablePane's layout to a file.
	 * 
	 *  @param pivot    the PivotTablePane
	 *  @param fileName the file name
	 *  @param callback the callback which will be called when saving each element to the XML document
	 *  @param encoding the encoding choice. It would be UTF-8 in default if you call the method without this parameter.
	 *  @throws ParserConfigurationException if a DocumentBuilder cannot be created which satisfies the configuration
	 *  @throws IOException                  If the pathname argument is null or any IO errors happen
	 */
	public static void save(PivotTablePane pivot, String fileName, PersistenceUtilsCallback.Save callback, String encoding) {
	}

	/**
	 *  Saves the PivotTablePane's layout to an output stream.
	 * 
	 *  @param pivot    the PivotTablePane
	 *  @param out      the output stream
	 *  @param callback The callback which will be called when saving each element to the XML document.
	 *  @throws ParserConfigurationException if a DocumentBuilder cannot be created which satisfies the configuration
	 *  @throws IOException                  If the pathname argument is null or any IO errors happen
	 */
	public static void save(PivotTablePane pivot, java.io.OutputStream out, PersistenceUtilsCallback.Save callback) {
	}

	/**
	 *  Saves the PivotTablePane's layout to an output stream.
	 * 
	 *  @param pivot    the PivotTablePane
	 *  @param out      the output stream
	 *  @param callback The callback which will be called when saving each element to the XML document.
	 *  @param encoding the encoding choice. It would be UTF-8 in default if you call the method without this parameter.
	 *  @throws ParserConfigurationException if a DocumentBuilder cannot be created which satisfies the configuration
	 *  @throws IOException                  If the pathname argument is null or any IO errors happen
	 */
	public static void save(PivotTablePane pivot, java.io.OutputStream out, PersistenceUtilsCallback.Save callback, String encoding) {
	}

	/**
	 *  Saves the PivotTablePane's layout to an XML Document
	 * 
	 *  @param pivot    the PivotTablePane
	 *  @param callback The callback which will be called when saving each element to the XML document.
	 *  @return XML Document which has the PivotTablePane's layout.
	 *  @throws ParserConfigurationException if a DocumentBuilder cannot be created which satisfies the configuration
	 */
	public static org.w3c.dom.Document save(PivotTablePane pivot, PersistenceUtilsCallback.Save callback) {
	}

	public static void writePivotTableElement(PivotTablePane pivot, org.w3c.dom.Document document, org.w3c.dom.Element element, PersistenceUtilsCallback.Save callback) {
	}

	public static void load(PivotTablePane pivot, java.io.InputStream in) {
	}

	/**
	 *  Loads the layout from xml file.
	 * 
	 *  @param pivot    the PivotTablePane
	 *  @param fileName the layout file name.
	 *  @throws ParserConfigurationException if a DocumentBuilder cannot be created which satisfies the configuration
	 *                                       requested.
	 *  @throws SAXException                 If any parse errors occur.
	 *  @throws IOException                  If the pathname argument is null or any IO errors happen
	 */
	public static void load(PivotTablePane pivot, String fileName) {
	}

	/**
	 *  Loads the layout from xml document.
	 * 
	 *  @param pivot    the PivotTablePane
	 *  @param document the XML document
	 */
	public static void load(PivotTablePane pivot, org.w3c.dom.Document document) {
	}

	/**
	 *  Loads the layout from input stream.
	 * 
	 *  @param pivot    the PivotTablePane
	 *  @param in       the input stream
	 *  @param callback The callback which will be called when loading each element in the XML document.
	 *  @throws ParserConfigurationException if a DocumentBuilder cannot be created which satisfies the configuration
	 *                                       requested.
	 *  @throws SAXException                 If any parse errors occur.
	 *  @throws IOException                  If the pathname argument is null or any IO errors happen
	 */
	public static void load(PivotTablePane pivot, java.io.InputStream in, PersistenceUtilsCallback.Load callback) {
	}

	/**
	 *  Loads the layout from xml file.
	 * 
	 *  @param pivot    the PivotTablePane
	 *  @param fileName the layout file name.
	 *  @param callback The callback which will be called when loading each element in the XML document.
	 *  @throws ParserConfigurationException if a DocumentBuilder cannot be created which satisfies the configuration
	 *                                       requested.
	 *  @throws SAXException                 If any parse errors occur.
	 *  @throws IOException                  If the pathname argument is null or any IO errors happen
	 */
	public static void load(PivotTablePane pivot, String fileName, PersistenceUtilsCallback.Load callback) {
	}

	/**
	 *  Loads the layout from xml document.
	 * 
	 *  @param pivot    the PivotTablePane
	 *  @param document the XML document
	 *  @param callback The callback which will be called when loading each element in the XML document.
	 */
	public static void load(PivotTablePane pivot, org.w3c.dom.Document document, PersistenceUtilsCallback.Load callback) {
	}

	public static void readPivotTableElement(PivotTablePane pivot, org.w3c.dom.Document document, org.w3c.dom.Element element, PersistenceUtilsCallback.Load callback) {
	}

	/**
	 *  Gets the version of the layout file. Null is the layout file is invalid.
	 * 
	 *  @param in the InputStream
	 *  @return the version.
	 *  @throws ParserConfigurationException if a DocumentBuilder cannot be created which satisfies the configuration
	 *                                       requested.
	 *  @throws SAXException                 If any parse errors occur.
	 *  @throws IOException                  If the pathname argument is null or any IO errors happen
	 */
	public static String getVersion(java.io.InputStream in) {
	}

	/**
	 *  Gets the version of the layout file. Null is the layout file is invalid.
	 * 
	 *  @param fileName the Document for the layout
	 *  @return the version.
	 *  @throws ParserConfigurationException if a DocumentBuilder cannot be created which satisfies the configuration
	 *                                       requested.
	 *  @throws SAXException                 If any parse errors occur.
	 *  @throws IOException                  If the pathname argument is null or any IO errors happen
	 */
	public static String getVersion(String fileName) {
	}

	/**
	 *  Gets the version of the layout file. Null is the layout file is invalid.
	 * 
	 *  @param document the Document for the layout
	 *  @return the version.
	 */
	public static String getVersion(org.w3c.dom.Document document) {
	}

	/**
	 *  Checks if the layout is valid.
	 * 
	 *  @param pivot the pivot table pane.
	 *  @param in    the input steam which is an XML layout file.
	 *  @throws ParserConfigurationException if a DocumentBuilder cannot be created which satisfies the configuration
	 *                                       requested.
	 *  @throws SAXException                 if any parse error occurs.
	 *  @throws IOException                  if any IO error occurs.
	 *  @throws IllegalArgumentException     if the layout content is invalid such as version number is missing or the
	 *                                       field in the layout is no longer in the pivot table pane.
	 */
	public static void isLayoutValid(PivotTablePane pivot, java.io.InputStream in) {
	}

	/**
	 *  Checks if the layout is valid.
	 * 
	 *  @param pivot    the pivot table pane.
	 *  @param fileName the file name of an XML layout file.
	 *  @throws ParserConfigurationException if a DocumentBuilder cannot be created which satisfies the configuration
	 *                                       requested.
	 *  @throws SAXException                 if any parse error occurs.
	 *  @throws IOException                  if any IO error occurs.
	 *  @throws IllegalArgumentException     if the layout content is invalid such as version number is missing or the
	 *                                       field in the layout is no longer in the pivot table pane.
	 */
	public static void isLayoutValid(PivotTablePane pivot, String fileName) {
	}

	/**
	 *  Checks if the layout is valid.
	 * 
	 *  @param pivot    the pivot table pane
	 *  @param document the XML Document
	 *  @throws IllegalArgumentException if the layout content is invalid such as version number is missing or the field
	 *                                   in the layout is no longer in the pivot table pane.
	 */
	public static void isLayoutValid(PivotTablePane pivot, org.w3c.dom.Document document) {
	}
}
